/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.terminalmc.commandkeys.CommandKeys;
import dev.terminalmc.commandkeys.config.Config;
import dev.terminalmc.commandkeys.config.Message;
import dev.terminalmc.commandkeys.config.Profile;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_3675;

public class Macro {
    public final int version = 3;
    public final transient Profile profile;
    public boolean addToHistory;
    public boolean showHudMessage;
    private ConflictStrategy conflictStrategy;
    private SendMode sendMode;
    public int spaceTicks;
    public transient int cycleIndex;
    private transient class_3675.class_306 key;
    private String keyName;
    private transient class_3675.class_306 limitKey;
    private String limitKeyName;
    final List<Message> messages;
    private final transient List<ScheduledMessage> scheduledMessages = new ArrayList<ScheduledMessage>();

    public Macro(Profile profile) {
        this.addToHistory = false;
        this.showHudMessage = false;
        this.profile = profile;
        this.conflictStrategy = Config.get().defaultConflictStrategy;
        this.sendMode = Config.get().defaultSendMode;
        this.spaceTicks = 0;
        this.cycleIndex = 0;
        this.key = class_3675.field_16237;
        this.keyName = this.key.method_1441();
        this.limitKey = class_3675.field_16237;
        this.limitKeyName = this.limitKey.method_1441();
        this.messages = new ArrayList<Message>();
    }

    private Macro(Profile profile, boolean addToHistory, boolean showHudMessage, ConflictStrategy conflictStrategy, SendMode sendMode, int spaceTicks, class_3675.class_306 key, class_3675.class_306 limitKey, List<Message> messages) {
        this.profile = profile;
        this.addToHistory = addToHistory;
        this.showHudMessage = showHudMessage;
        this.conflictStrategy = conflictStrategy;
        this.sendMode = sendMode;
        this.spaceTicks = spaceTicks;
        this.cycleIndex = 0;
        this.key = key;
        this.keyName = key.method_1441();
        this.limitKey = limitKey;
        this.limitKeyName = limitKey.method_1441();
        this.messages = messages;
        profile.keyMacroMap.put((Object)key, (Object)this);
    }

    public boolean addToHistory() {
        return switch (this.profile.addToHistory) {
            default -> throw new MatchException(null, null);
            case Profile.Control.ON -> true;
            case Profile.Control.OFF -> false;
            case Profile.Control.DEFER -> this.addToHistory;
        };
    }

    public boolean showHudMessage() {
        return switch (this.profile.showHudMessage) {
            default -> throw new MatchException(null, null);
            case Profile.Control.ON -> true;
            case Profile.Control.OFF -> false;
            case Profile.Control.DEFER -> this.showHudMessage;
        };
    }

    public ConflictStrategy getConflictStrategy() {
        return this.conflictStrategy;
    }

    public void setConflictStrategy(ConflictStrategy conflictStrategy) {
        this.stopRepeating();
        this.conflictStrategy = conflictStrategy;
    }

    public SendMode getSendMode() {
        return this.sendMode;
    }

    public void setSendMode(SendMode sendMode) {
        this.stopRepeating();
        this.sendMode = sendMode;
    }

    public class_3675.class_306 getKey() {
        return this.key;
    }

    public void setKey(class_3675.class_306 key) {
        this.stopRepeating();
        this.key = key;
        this.keyName = key.method_1441();
        this.profile.rebuildMacroMap();
    }

    public class_3675.class_306 getLimitKey() {
        return this.limitKey;
    }

    public void setLimitKey(class_3675.class_306 limitKey) {
        this.stopRepeating();
        this.limitKey = limitKey;
        this.limitKeyName = limitKey.method_1441();
    }

    public List<Message> getMessages() {
        return Collections.unmodifiableList(this.messages);
    }

    public void addMessage(Message message) {
        this.messages.add(message);
    }

    public void setMessage(int index, String str) {
        this.messages.get((int)index).string = str;
    }

    public void removeMessage(int index) {
        this.messages.remove(index);
    }

    public void moveMessage(int sourceIndex, int destIndex) {
        if (sourceIndex != destIndex) {
            this.messages.add(destIndex, this.messages.remove(sourceIndex));
        }
    }

    public boolean trigger() {
        if (this.hasRepeating()) {
            this.stopRepeating();
            return false;
        }
        boolean cancel = false;
        switch (this.sendMode.ordinal()) {
            case 0: {
                boolean standardDelay = this.spaceTicks != 0;
                int cumulativeDelay = standardDelay ? -this.spaceTicks : 0;
                for (Message msg : this.messages) {
                    this.schedule(cumulativeDelay += standardDelay ? this.spaceTicks : msg.delayTicks, -1, msg.string, this.addToHistory(), this.showHudMessage());
                }
                break;
            }
            case 1: {
                if (this.messages.isEmpty()) break;
                cancel = true;
                CommandKeys.type(this.messages.getFirst().string);
                break;
            }
            case 2: {
                for (String msg : this.messages.get((int)this.cycleIndex).string.split(",,")) {
                    if (msg.isBlank()) continue;
                    CommandKeys.send(msg, this.addToHistory(), this.showHudMessage());
                }
                if (++this.cycleIndex < this.messages.size()) break;
                this.cycleIndex = 0;
                break;
            }
            case 3: {
                int cumulativeDelay = 0;
                for (Message msg : this.messages) {
                    this.schedule(cumulativeDelay += msg.delayTicks, this.spaceTicks, msg.string, this.addToHistory(), this.showHudMessage());
                }
                break;
            }
        }
        return cancel;
    }

    public boolean hasRepeating() {
        for (ScheduledMessage msg : this.scheduledMessages) {
            if (msg.repeatDelay == -1) continue;
            return true;
        }
        return false;
    }

    public void stopRepeating() {
        this.scheduledMessages.removeIf(msg -> msg.repeatDelay != -1);
    }

    private void schedule(int initialDelay, int repeatDelay, String message, boolean addToHistory, boolean showHudMsg) {
        this.scheduledMessages.add(new ScheduledMessage(initialDelay, repeatDelay, message, addToHistory, showHudMsg));
    }

    public void tick() {
        this.scheduledMessages.removeIf(ScheduledMessage::tick);
    }

    public static enum ConflictStrategy {
        SUBMIT,
        ASSERT,
        VETO,
        AVOID;

    }

    public static enum SendMode {
        SEND,
        TYPE,
        CYCLE,
        REPEAT;

    }

    private static class ScheduledMessage {
        private int delay;
        final int repeatDelay;
        final String message;
        final boolean showHudMessage;
        final boolean addToHistory;

        public ScheduledMessage(int initialDelay, int repeatDelay, String message, boolean showHudMessage, boolean addToHistory) {
            this.delay = initialDelay;
            this.repeatDelay = repeatDelay;
            this.message = message;
            this.showHudMessage = showHudMessage;
            this.addToHistory = addToHistory;
        }

        private boolean tick() {
            if (--this.delay <= 0) {
                CommandKeys.send(this.message, this.showHudMessage, this.addToHistory);
                if (this.repeatDelay != -1) {
                    this.delay = this.repeatDelay;
                } else {
                    return true;
                }
            }
            return false;
        }
    }

    public static class Deserializer
    implements JsonDeserializer<Macro> {
        Profile profile;

        public Deserializer(Profile profile) {
            this.profile = profile;
        }

        public Macro deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext ctx) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            int version = obj.has("version") ? obj.get("version").getAsInt() : 0;
            boolean addToHistory = version >= 3 ? obj.get("addToHistory").getAsBoolean() : false;
            boolean showHudMessage = version >= 3 ? obj.get("showHudMessage").getAsBoolean() : false;
            ConflictStrategy conflictStrategy = version >= 3 ? ConflictStrategy.valueOf(obj.get("conflictStrategy").getAsString()) : Deserializer.getConflictStrategy(obj.get("conflictStrategy").getAsString());
            SendMode sendMode = version >= 3 ? SendMode.valueOf(obj.get("sendMode").getAsString()) : Deserializer.getSendMode(obj.get("sendStrategy").getAsString());
            int spaceTicks = version >= 1 ? obj.get("spaceTicks").getAsInt() : 0;
            class_3675.class_306 key = version >= 3 ? class_3675.method_15981((String)obj.get("keyName").getAsString()) : class_3675.method_15981((String)obj.getAsJsonObject("key").get("name").getAsString());
            class_3675.class_306 limitKey = version >= 3 ? class_3675.method_15981((String)obj.get("limitKeyName").getAsString()) : class_3675.method_15981((String)obj.getAsJsonObject("limitKey").get("name").getAsString());
            ArrayList<Message> messages = new ArrayList<Message>();
            for (JsonElement je : obj.getAsJsonArray("messages")) {
                messages.add(version >= 2 ? (Message)ctx.deserialize(je, Message.class) : new Message(true, je.getAsString(), 0));
            }
            if (spaceTicks < 0) {
                throw new JsonParseException("Macro #1");
            }
            return new Macro(this.profile, addToHistory, showHudMessage, conflictStrategy, sendMode, spaceTicks, key, limitKey, messages);
        }

        public static ConflictStrategy getConflictStrategy(String str) {
            return switch (str) {
                case "ZERO" -> ConflictStrategy.SUBMIT;
                case "ONE" -> ConflictStrategy.ASSERT;
                case "TWO" -> ConflictStrategy.VETO;
                case "THREE" -> ConflictStrategy.AVOID;
                default -> throw new JsonParseException("Macro #2");
            };
        }

        public static SendMode getSendMode(String str) {
            return switch (str) {
                case "ZERO" -> SendMode.SEND;
                case "ONE" -> SendMode.TYPE;
                case "TWO" -> SendMode.CYCLE;
                default -> throw new JsonParseException("Macro #3");
            };
        }
    }
}

