/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.commandkeys.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.terminalmc.commandkeys.CommandKeys;
import dev.terminalmc.commandkeys.config.Macro;
import dev.terminalmc.commandkeys.config.Message;
import dev.terminalmc.commandkeys.config.Profile;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Config {
    public final int version = 4;
    private static final Path DIR_PATH = Path.of("config", new String[0]);
    private static final String FILE_NAME = "commandkeys.json";
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(Config.class, (Object)new Deserializer()).registerTypeAdapter(Profile.class, (Object)new Profile.Deserializer()).registerTypeAdapter(Message.class, (Object)new Message.Deserializer()).setPrettyPrinting().create();
    public Macro.ConflictStrategy defaultConflictStrategy;
    public Macro.SendMode defaultSendMode;
    private final List<Profile> profiles;
    public int spDefault;
    public int mpDefault;
    private static Config instance = null;

    public Config() {
        this.defaultConflictStrategy = Macro.ConflictStrategy.SUBMIT;
        this.defaultSendMode = Macro.SendMode.SEND;
        this.profiles = new ArrayList<Profile>();
        Profile defaultProfile = new Profile();
        defaultProfile.name = "Default Profile";
        this.profiles.add(defaultProfile);
        this.spDefault = 0;
        this.mpDefault = 0;
    }

    private Config(Macro.ConflictStrategy defaultConflictStrategy, Macro.SendMode defaultSendMode, List<Profile> profiles, int spDefault, int mpDefault) {
        this.defaultConflictStrategy = defaultConflictStrategy;
        this.defaultSendMode = defaultSendMode;
        this.profiles = profiles;
        this.spDefault = spDefault;
        this.mpDefault = mpDefault;
        this.activateProfile(spDefault);
    }

    public Profile activeProfile() {
        return this.profiles.getFirst();
    }

    public void activateProfile(int index) {
        this.profiles.getFirst().getMacros().forEach(Macro::stopRepeating);
        if (index != 0) {
            this.profiles.addFirst(this.profiles.remove(index));
            if (index == this.spDefault) {
                this.spDefault = 0;
            } else if (index > this.spDefault) {
                ++this.spDefault;
            }
            if (index == this.mpDefault) {
                this.mpDefault = 0;
            } else if (index > this.mpDefault) {
                ++this.mpDefault;
            }
        }
    }

    public void activateSpProfile(String levelId) {
        Profile profile = Profile.LINK_PROFILE_MAP.getOrDefault(levelId, null);
        if (profile != null) {
            this.activateProfile(this.profiles.indexOf(profile));
        } else {
            this.activateProfile(this.spDefault);
        }
    }

    public void activateMpProfile(String address) {
        Profile profile = Profile.LINK_PROFILE_MAP.getOrDefault(address, null);
        if (profile != null) {
            this.activateProfile(this.profiles.indexOf(profile));
        } else {
            this.activateProfile(this.mpDefault);
        }
    }

    public List<Profile> getProfiles() {
        return Collections.unmodifiableList(this.profiles);
    }

    public void copyProfile(Profile profile) {
        Profile copyProfile = new Profile(profile);
        copyProfile.name = profile.getDisplayName() + " (Copy)";
        this.profiles.add(copyProfile);
    }

    public void addProfile(Profile profile) {
        this.profiles.add(profile);
    }

    public void removeProfile(int index) {
        this.profiles.remove(index);
        if (index < this.spDefault) {
            --this.spDefault;
        }
        if (index < this.mpDefault) {
            --this.mpDefault;
        }
    }

    public void cleanup() {
        for (Profile p : this.profiles) {
            p.cleanup();
        }
    }

    public static Config get() {
        if (instance == null) {
            instance = Config.load();
        }
        return instance;
    }

    public static Config getAndSave() {
        Config.get();
        Config.save();
        return instance;
    }

    public static Config resetAndSave() {
        instance = new Config();
        Config.save();
        return instance;
    }

    @NotNull
    public static Config load() {
        Path file = DIR_PATH.resolve(FILE_NAME);
        Config config = null;
        if (Files.exists(file, new LinkOption[0])) {
            config = Config.load(file, GSON);
        }
        if (config == null) {
            config = new Config();
        }
        return config;
    }

    @Nullable
    private static Config load(Path file, Gson gson) {
        Config config;
        FileReader reader = new FileReader(file.toFile());
        try {
            config = (Config)gson.fromJson((Reader)reader, Config.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                CommandKeys.LOG.error("Unable to load config.", e);
                return null;
            }
        }
        reader.close();
        return config;
    }

    public static void save() {
        instance.cleanup();
        try {
            if (!Files.isDirectory(DIR_PATH, new LinkOption[0])) {
                Files.createDirectories(DIR_PATH, new FileAttribute[0]);
            }
            Path file = DIR_PATH.resolve(FILE_NAME);
            Path tempFile = file.resolveSibling(String.valueOf(file.getFileName()) + ".tmp");
            try (FileWriter writer = new FileWriter(tempFile.toFile());){
                writer.write(GSON.toJson((Object)instance));
            }
            catch (IOException e) {
                throw new IOException(e);
            }
            Files.move(tempFile, file, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            CommandKeys.onConfigSaved(instance);
        }
        catch (IOException e) {
            CommandKeys.LOG.error("Unable to save config.", e);
        }
    }

    public static class Deserializer
    implements JsonDeserializer<Config> {
        public Config deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext ctx) throws JsonParseException {
            int mpDefault;
            int spDefault;
            JsonObject obj = json.getAsJsonObject();
            int version = obj.has("version") ? obj.get("version").getAsInt() : 0;
            Macro.ConflictStrategy defaultConflictStrategy = version >= 4 ? Macro.ConflictStrategy.valueOf(obj.get("defaultConflictStrategy").getAsString()) : Macro.ConflictStrategy.SUBMIT;
            Macro.SendMode defaultSendMode = version >= 4 ? Macro.SendMode.valueOf(obj.get("defaultSendMode").getAsString()) : Macro.SendMode.SEND;
            ArrayList<Profile> profiles = new ArrayList<Profile>();
            for (JsonElement je : obj.getAsJsonArray("profiles")) {
                profiles.add((Profile)ctx.deserialize(je, Profile.class));
            }
            if (version == 1) {
                profiles.addFirst((Profile)ctx.deserialize(obj.get("mpDefaultProfile"), Profile.class));
                profiles.addFirst((Profile)ctx.deserialize(obj.get("spDefaultProfile"), Profile.class));
                if (profiles.size() < 2) {
                    throw new JsonParseException("Expected 2 or more profiles, got " + profiles.size());
                }
                spDefault = 0;
                mpDefault = 1;
            } else {
                spDefault = obj.get("spDefault").getAsInt();
                mpDefault = obj.get("mpDefault").getAsInt();
            }
            if (spDefault < 0 || spDefault >= profiles.size()) {
                throw new JsonParseException("Config #1");
            }
            if (mpDefault < 0 || mpDefault >= profiles.size()) {
                throw new JsonParseException("Config #2");
            }
            return new Config(defaultConflictStrategy, defaultSendMode, profiles, spDefault, mpDefault);
        }
    }
}

