/*
 * Decompiled with CFR 0.152.
 */
package essentialaddons.utils;

import carpet.api.settings.SettingsManager;
import carpet.utils.Translations;
import essentialaddons.EssentialSettings;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EssentialRuleGenerator
implements DedicatedServerModInitializer {
    private static final String START = "# EssentialAddons\n\n[![Discord](https://badgen.net/discord/online-members/gn99m4QRY4?icon=discord&label=Discord&list=what)](https://discord.gg/gn99m4QRY4)\n[![GitHub downloads](https://img.shields.io/github/downloads/super-santa/essentialaddons/total?label=Github%20downloads&logo=github)](https://github.com/Super-Santa/EssentialAddons/releases)\n[![Modrinth downloads](https://img.shields.io/modrinth/dt/EssentialAddons?label=Modrinth%20downloads&logo=modrinth)](https://modrinth.com/mod/essentialaddons)\n\n[Fabric Carpet](https://github.com/gnembon/fabric-carpet) extension that adds things from the Spigot plugin Essentials, or other features I think are needed for Minecraft.\n\n## !!! Find Updated Releases on [Modrinth](https://modrinth.com/mod/essentialaddons) !!!\n\nFeatures can be enabled through the `/carpet` command:\n```\n/carpet <rule_name> <rule_value>\n\n# For example:\n/carpet phantomsObeyMobcaps true\n/carpet commandCameraMode ops\n/carpet stackableShulkersInPlayerInventories true\n```\n\n\nPermissions can be customised for commands through a permissions mod such as [LuckPerms](https://luckperms.net/),\nthe name of the permissions are as follows:\n```\nesssentialaddons.command.<command_name>\n\n# For example:\nessentialaddons.command.cs\nessentialaddons.command.hat\nessentialaddons.command.lagspike\n```\n\n";

    public void onInitializeServer() {
        PrintStream outputStream;
        String[] args = (String[])Arrays.stream(FabricLoader.getInstance().getLaunchArguments(true)).filter(opt -> !opt.equals("--")).toArray(String[]::new);
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec pathSpec = parser.accepts("generate").withRequiredArg();
        parser.allowsUnrecognizedOptions();
        OptionSet options = parser.parse(args);
        if (!options.has((OptionSpec)pathSpec)) {
            return;
        }
        Logger logger = LogManager.getLogger((String)"EssentialRuleGenerator");
        try {
            Path path = Path.of((String)options.valueOf((OptionSpec)pathSpec), new String[0]);
            logger.info("Generating Rules for Path: {}", (Object)path.toString());
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            outputStream = new PrintStream(Files.newOutputStream(path, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Translations.updateLanguage();
        SettingsManager manager = new SettingsManager("1.2.0", "carpet", "EssentialAddons");
        manager.parseSettingsClass(EssentialSettings.class);
        logger.info("Rule Count: {}", (Object)manager.getCarpetRules().size());
        outputStream.println(START);
        manager.dumpAllRulesToStream(outputStream, null);
        outputStream.close();
        logger.info("Complete");
        System.exit(0);
    }
}

