/*
 * Decompiled with CFR 0.152.
 */
package essentialaddons.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import essentialaddons.utils.Config;
import essentialaddons.utils.Subscription;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_3222;

public class ConfigSubscribeData
implements Config {
    public static final ConfigSubscribeData INSTANCE = new ConfigSubscribeData();
    private final Map<UUID, Set<Subscription>> subscriptions = new HashMap<UUID, Set<Subscription>>();

    private ConfigSubscribeData() {
    }

    protected void addPlayerSubscription(class_3222 player, Subscription subscription) {
        this.subscriptions.computeIfAbsent(player.method_5667(), id -> EnumSet.noneOf(Subscription.class)).add(subscription);
    }

    protected void removePlayerSubscription(class_3222 player, Subscription subscription) {
        Set<Subscription> subscriptions = this.subscriptions.get(player.method_5667());
        if (subscriptions != null) {
            subscriptions.remove((Object)subscription);
        }
    }

    protected boolean isPlayerSubscribedTo(class_3222 player, Subscription subscription) {
        Set<Subscription> subscriptions = this.subscriptions.get(player.method_5667());
        return subscriptions != null && subscriptions.contains((Object)subscription);
    }

    @Override
    public String getConfigName() {
        return "SubscribeData";
    }

    @Override
    public Path getConfigPath() {
        return this.getConfigRootPath().resolve("subscribedata.json");
    }

    @Override
    public JsonArray getSaveData() {
        JsonArray playerSubscriptions = new JsonArray();
        this.subscriptions.forEach((uuid, subscriptionSet) -> {
            JsonObject playerData = new JsonObject();
            JsonArray array = new JsonArray();
            subscriptionSet.forEach(subscription -> array.add(subscription.getName()));
            playerData.addProperty("uuid", uuid.toString());
            playerData.add("subscriptions", (JsonElement)array);
            playerSubscriptions.add((JsonElement)playerData);
        });
        return playerSubscriptions;
    }

    @Override
    public void readConfig(JsonArray playerSubscriptions) {
        playerSubscriptions.forEach(jsonElement -> {
            JsonObject playerData = jsonElement.getAsJsonObject();
            UUID playerUUID = UUID.fromString(playerData.get("uuid").getAsString());
            JsonArray jsonArray = playerData.getAsJsonArray("subscriptions");
            HashSet subscriptions = new HashSet();
            jsonArray.forEach(element -> {
                Subscription subscription = Subscription.fromString(element.getAsString());
                if (subscription != null) {
                    subscriptions.add(subscription);
                }
            });
            this.subscriptions.put(playerUUID, subscriptions);
        });
    }
}

