/*
 * Decompiled with CFR 0.152.
 */
package essentialaddons.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import essentialaddons.EssentialAddons;
import essentialaddons.EssentialUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public interface Config {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public String getConfigName();

    public Path getConfigPath();

    public JsonArray getSaveData();

    public void readConfig(JsonArray var1);

    default public void readConfig() {
        JsonArray element = this.getConfigData();
        if (element != null) {
            this.readConfig(element);
        }
    }

    default public Path getConfigRootPath() {
        Path root = EssentialUtils.getConfigPath().resolve("EssentialAddons");
        if (!Files.exists(root, new LinkOption[0])) {
            EssentialUtils.throwAsRuntime(() -> Files.createDirectory(root, new FileAttribute[0]));
        }
        return root;
    }

    default public JsonArray getConfigData() {
        Path configPath = this.getConfigPath();
        if (Files.isRegularFile(configPath, new LinkOption[0])) {
            JsonArray jsonArray;
            block9: {
                BufferedReader reader = Files.newBufferedReader(configPath);
                try {
                    jsonArray = (JsonArray)GSON.fromJson((Reader)reader, JsonArray.class);
                    if (reader == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        EssentialAddons.LOGGER.error("Failed to read '{}': {}", (Object)this.getConfigName(), (Object)e);
                    }
                }
                reader.close();
            }
            return jsonArray;
        }
        return new JsonArray();
    }

    default public void saveConfig() {
        Path configPath = this.getConfigPath();
        try (BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);){
            GSON.toJson((JsonElement)this.getSaveData(), (Appendable)writer);
        }
        catch (IOException e) {
            EssentialAddons.LOGGER.error("Failed to save '{}': {}", (Object)this.getConfigName(), (Object)e);
        }
    }
}

