/*
 * Decompiled with CFR 0.152.
 */
package essentialaddons.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import essentialaddons.EssentialSettings;
import essentialaddons.EssentialUtils;
import essentialaddons.mixins.core.MinecraftServerAccessor;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2181;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class CommandBackup {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"backup").requires(EssentialUtils.enabled(() -> EssentialSettings.commandBackup, "essentialaddons.command.backup"))).then(class_2170.method_9244((String)"regionxfrom", (ArgumentType)IntegerArgumentType.integer()).suggests((c, b) -> CommandBackup.getPlayerRegion((CommandContext<class_2168>)c, b, true)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"regionzfrom", (ArgumentType)IntegerArgumentType.integer()).suggests((c, b) -> CommandBackup.getPlayerRegion((CommandContext<class_2168>)c, b, false)).executes(context -> {
            int x = (Integer)context.getArgument("regionxfrom", Integer.class);
            int z = (Integer)context.getArgument("regionzfrom", Integer.class);
            CommandBackup.saveRegions((CommandContext<class_2168>)context, x, z, x, z, ((class_2168)context.getSource()).method_9225(), false);
            return 1;
        })).then(class_2170.method_9244((String)"regionxto", (ArgumentType)IntegerArgumentType.integer()).suggests((c, b) -> CommandBackup.getPlayerRegion((CommandContext<class_2168>)c, b, true)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"regionzto", (ArgumentType)IntegerArgumentType.integer()).suggests((c, b) -> CommandBackup.getPlayerRegion((CommandContext<class_2168>)c, b, false)).executes(context -> {
            int x1 = (Integer)context.getArgument("regionxfrom", Integer.class);
            int z1 = (Integer)context.getArgument("regionzfrom", Integer.class);
            int x2 = (Integer)context.getArgument("regionxto", Integer.class);
            int z2 = (Integer)context.getArgument("regionzto", Integer.class);
            CommandBackup.saveRegions((CommandContext<class_2168>)context, x1, z1, x2, z2, ((class_2168)context.getSource()).method_9225(), false);
            return 1;
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"world", (ArgumentType)class_2181.method_9288()).executes(context -> {
            int x1 = (Integer)context.getArgument("regionxfrom", Integer.class);
            int z1 = (Integer)context.getArgument("regionzfrom", Integer.class);
            int x2 = (Integer)context.getArgument("regionxto", Integer.class);
            int z2 = (Integer)context.getArgument("regionzto", Integer.class);
            class_3218 world = class_2181.method_9289((CommandContext)context, (String)"world");
            CommandBackup.saveRegions((CommandContext<class_2168>)context, x1, z1, x2, z2, world, false);
            return 1;
        })).then(class_2170.method_9244((String)"replace", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            int x1 = (Integer)context.getArgument("regionxfrom", Integer.class);
            int z1 = (Integer)context.getArgument("regionzfrom", Integer.class);
            int x2 = (Integer)context.getArgument("regionxto", Integer.class);
            int z2 = (Integer)context.getArgument("regionzto", Integer.class);
            boolean shouldOverwrite = (Boolean)context.getArgument("replace", Boolean.class);
            class_3218 world = class_2181.method_9289((CommandContext)context, (String)"world");
            CommandBackup.saveRegions((CommandContext<class_2168>)context, x1, z1, x2, z2, world, shouldOverwrite);
            return 1;
        }))))))));
    }

    private static CompletableFuture<Suggestions> getPlayerRegion(CommandContext<class_2168> context, SuggestionsBuilder builder, boolean xAxis) throws CommandSyntaxException {
        class_3222 playerEntity = ((class_2168)context.getSource()).method_9207();
        int position = (int)Math.floor((xAxis ? playerEntity.method_23317() : playerEntity.method_23321()) / 512.0);
        return class_2172.method_9265(List.of(String.valueOf(position)), (SuggestionsBuilder)builder);
    }

    private static void saveRegions(CommandContext<class_2168> context, int fromX, int fromZ, int toX, int toZ, class_3218 world, boolean overwrite) {
        Path fromPath;
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        server.method_3723(true, true, true);
        Path savePath = EssentialUtils.getSavePath().resolve("backups").resolve(LocalDate.now().toString()).resolve(world.method_27983().method_29177().method_12832());
        if (!Files.exists(savePath, new LinkOption[0])) {
            EssentialUtils.throwAsRuntime(() -> Files.createDirectories(savePath, new FileAttribute[0]));
        }
        if (!Files.exists(fromPath = ((MinecraftServerAccessor)server).getSession().method_27424(world.method_27983()).resolve("region"), new LinkOption[0])) {
            EssentialUtils.sendRawFeedback(source, false, "World has no such regions");
            return;
        }
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH.mm.ss");
        boolean successful = false;
        Iterable iterable = class_2338.method_10097((class_2338)new class_2338(fromX, 0, fromZ), (class_2338)new class_2338(toX, 0, toZ));
        for (class_2338 pos : iterable) {
            int x = pos.method_10263();
            int z = pos.method_10260();
            String fileName = "r.%d.%d.mca".formatted(x, z);
            Path region = fromPath.resolve(fileName);
            if (!Files.exists(region, new LinkOption[0])) continue;
            Path savePathRegion = savePath.resolve(fileName);
            EssentialUtils.throwAsRuntime(() -> {
                if (Files.exists(savePathRegion, new LinkOption[0])) {
                    if (overwrite) {
                        Files.deleteIfExists(savePathRegion);
                    } else {
                        Files.move(savePathRegion, savePath.resolve(LocalTime.now().format(timeFormatter) + "_" + fileName), new CopyOption[0]);
                    }
                }
                Files.copy(region, savePath.resolve(fileName), new CopyOption[0]);
            });
            successful = true;
        }
        if (successful) {
            source.method_9226(() -> class_2561.method_43470((String)"Successfully saved regions to: ").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)savePath.toString()).method_27692(class_124.field_1060)), true);
        } else {
            source.method_9226(() -> class_2561.method_43470((String)"Failed to save regions").method_27692(class_124.field_1061), true);
        }
    }
}

