/*
 * Decompiled with CFR 0.152.
 */
package essentialaddons;

import carpet.utils.CommandHelper;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import essentialaddons.EssentialAddons;
import essentialaddons.utils.Subscription;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2480;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_4838;
import net.minecraft.class_5218;
import net.minecraft.class_7265;
import org.apache.commons.io.IOUtils;

public class EssentialUtils {
    public static final Random RANDOM = new Random();

    public static void sendToActionBar(class_3222 playerEntity, String message) {
        playerEntity.method_7353((class_2561)class_2561.method_43470((String)message), true);
    }

    public static void sendRawFeedback(class_2168 source, boolean log, String string) {
        source.method_9226(() -> class_2561.method_43470((String)string), log);
    }

    public static boolean isItemShulkerBox(class_1792 item) {
        class_1747 blockItem;
        return item instanceof class_1747 && (blockItem = (class_1747)item).method_7711() instanceof class_2480;
    }

    public static void breakVehicleStorage(class_7265 inventory, class_1282 source, class_1937 world, class_1297 vehicle) {
        class_1297 entity;
        if (!world.method_8450().method_8355(class_1928.field_19393)) {
            return;
        }
        class_1297 attacker = source.method_5529();
        if (EssentialUtils.hasCareful(attacker, Subscription.ESSENTIAL_CAREFUL_DROP)) {
            class_3222 player = (class_3222)attacker;
            for (int i = 0; i < inventory.method_5439(); ++i) {
                class_1799 stack = inventory.method_5438(i);
                if (EssentialUtils.placeItemInInventory(player, stack)) continue;
                class_1264.method_5449((class_1937)vehicle.method_37908(), (double)vehicle.method_23317(), (double)vehicle.method_23318(), (double)vehicle.method_23321(), (class_1799)stack);
            }
        } else {
            class_1264.method_5452((class_1937)world, (class_1297)vehicle, (class_1263)inventory);
        }
        if (!world.field_9236 && (entity = source.method_5526()) != null && entity.method_5864() == class_1299.field_6097) {
            class_4838.method_24733((class_1657)((class_1657)entity), (boolean)true);
        }
    }

    public static boolean placeItemInInventory(class_3222 player, class_1799 itemStack) {
        class_1792 item = itemStack.method_7909();
        int itemAmount = itemStack.method_7947();
        if (player.method_31548().method_7394(itemStack)) {
            player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15197, class_3419.field_15248, 0.2f, (RANDOM.nextFloat() - RANDOM.nextFloat()) * 1.4f + 2.0f);
            player.method_7342(class_3468.field_15392.method_14956((Object)item), itemAmount);
            return true;
        }
        return false;
    }

    public static boolean hasCareful(class_1297 entity, Subscription subscription) {
        class_3222 player;
        return entity instanceof class_3222 && EssentialUtils.hasCareful(player = (class_3222)entity, subscription);
    }

    public static boolean hasCareful(class_3222 player, Subscription subscription) {
        return subscription.getRequirement().get() != false && (player.method_5715() || Subscription.ALWAYS_CAREFUL.hasPlayer(player)) && subscription.hasPlayer(player);
    }

    public static boolean tryCareful(class_1297 entity, Subscription subscription, class_1799 stack) {
        if (EssentialUtils.hasCareful(entity, subscription)) {
            class_3222 player = (class_3222)entity;
            return EssentialUtils.placeItemInInventory(player, stack);
        }
        return false;
    }

    public static boolean hasPermission(class_2168 source, Supplier<Object> field, String permission) {
        return CommandHelper.canUseCommand((class_2168)source, (Object)field.get()) || Permissions.check((class_2172)source, (String)permission);
    }

    public static Predicate<class_2168> enabled(Supplier<Object> field, String permission) {
        return source -> EssentialUtils.hasPermission(source, field, permission);
    }

    @Deprecated
    public static class_1937 getWorld(class_1297 entity) {
        return entity.method_5770();
    }

    @Deprecated
    public static class_3218 getWorld(class_3222 player) {
        return player.method_51469();
    }

    public static Predicate<class_2168> op(String permission) {
        return source -> Permissions.check((class_2172)source, (String)permission, (int)4);
    }

    public static Path getSavePath() {
        if (EssentialAddons.server == null) {
            return FabricLoader.getInstance().getConfigDir();
        }
        return EssentialAddons.server.method_27050(class_5218.field_24188);
    }

    public static Path getConfigPath() {
        FabricLoader fabricLoader = FabricLoader.getInstance();
        return fabricLoader.getEnvironmentType() == EnvType.SERVER ? fabricLoader.getConfigDir() : EssentialUtils.getSavePath();
    }

    public static Map<String, String> getTranslations(String lang) {
        String jsonData;
        InputStream langFile = EssentialUtils.class.getClassLoader().getResourceAsStream("assets/essentialaddons/lang/%s.json".formatted(lang));
        if (langFile == null) {
            return Map.of();
        }
        try {
            jsonData = IOUtils.toString((InputStream)langFile, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            return Map.of();
        }
        return (Map)new Gson().fromJson(jsonData, new TypeToken<Map<String, String>>(){}.getType());
    }

    public static void throwAsRuntime(ThrowableRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    @FunctionalInterface
    public static interface ThrowableRunnable {
        public void run() throws Throwable;
    }
}

