/*
 * Decompiled with CFR 0.152.
 */
package essentialaddons;

import carpet.CarpetExtension;
import carpet.CarpetServer;
import com.mojang.brigadier.CommandDispatcher;
import essentialaddons.EssentialSettings;
import essentialaddons.EssentialUtils;
import essentialaddons.commands.CommandBackup;
import essentialaddons.commands.CommandCameraMode;
import essentialaddons.commands.CommandConfig;
import essentialaddons.commands.CommandDefuse;
import essentialaddons.commands.CommandDimensions;
import essentialaddons.commands.CommandEnderChest;
import essentialaddons.commands.CommandExtinguish;
import essentialaddons.commands.CommandFly;
import essentialaddons.commands.CommandGM;
import essentialaddons.commands.CommandGhostPlayer;
import essentialaddons.commands.CommandGod;
import essentialaddons.commands.CommandHat;
import essentialaddons.commands.CommandHeal;
import essentialaddons.commands.CommandLagSpike;
import essentialaddons.commands.CommandMods;
import essentialaddons.commands.CommandMore;
import essentialaddons.commands.CommandNear;
import essentialaddons.commands.CommandNightVision;
import essentialaddons.commands.CommandPublicViewDistance;
import essentialaddons.commands.CommandRename;
import essentialaddons.commands.CommandRepair;
import essentialaddons.commands.CommandStrength;
import essentialaddons.commands.CommandSubscribe;
import essentialaddons.commands.CommandSwitchDimensions;
import essentialaddons.commands.CommandTeamTeleportBlacklist;
import essentialaddons.commands.CommandTop;
import essentialaddons.commands.CommandWarp;
import essentialaddons.commands.CommandWorkbench;
import essentialaddons.feature.GameRuleNetworkHandler;
import essentialaddons.feature.ReloadFakePlayers;
import essentialaddons.logging.EssentialAddonsLoggerRegistry;
import essentialaddons.utils.Config;
import essentialaddons.utils.ConfigCamera;
import essentialaddons.utils.ConfigCameraData;
import essentialaddons.utils.ConfigFakePlayerData;
import essentialaddons.utils.ConfigSubscribeData;
import essentialaddons.utils.ConfigTeamTeleportBlacklist;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EssentialAddons
implements CarpetExtension,
ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger((String)"EssentialAddons");
    public static final Set<Config> CONFIG_SET = Set.of(ConfigCameraData.INSTANCE, ConfigSubscribeData.INSTANCE, ConfigFakePlayerData.INSTANCE, ConfigTeamTeleportBlacklist.INSTANCE);
    public static MinecraftServer server;

    public void onInitialize() {
        CarpetServer.manageExtension((CarpetExtension)this);
        ConfigCamera.INSTANCE.readConfig();
        GameRuleNetworkHandler.INSTANCE.registerGameRulePayloads();
    }

    public String version() {
        return "essentialaddons";
    }

    public void onGameStarted() {
        CarpetServer.settingsManager.parseSettingsClass(EssentialSettings.class);
    }

    public void registerLoggers() {
        EssentialAddonsLoggerRegistry.registerLoggers();
    }

    public void onServerLoaded(MinecraftServer server) {
        EssentialAddons.server = server;
        for (Config config : CONFIG_SET) {
            config.readConfig();
        }
    }

    public void onServerLoadedWorlds(MinecraftServer server) {
        if (EssentialSettings.reloadFakePlayers) {
            ReloadFakePlayers.loadFakePlayers(server);
        }
    }

    public void onServerClosed(MinecraftServer server) {
        for (Config config : CONFIG_SET) {
            config.saveConfig();
        }
    }

    public void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 access) {
        CommandFly.register(dispatcher);
        CommandHat.register(dispatcher);
        CommandRepair.register(dispatcher);
        CommandGM.register(dispatcher);
        CommandHeal.register(dispatcher);
        CommandExtinguish.register(dispatcher);
        CommandGod.register(dispatcher);
        CommandDefuse.register(dispatcher);
        CommandMore.register(dispatcher);
        CommandStrength.register(dispatcher);
        CommandNightVision.register(dispatcher);
        CommandDimensions.register(dispatcher);
        CommandWarp.register(dispatcher);
        CommandCameraMode.register(dispatcher);
        CommandBackup.register(dispatcher);
        CommandSwitchDimensions.register(dispatcher);
        CommandEnderChest.register(dispatcher);
        CommandWorkbench.register(dispatcher);
        CommandPublicViewDistance.register(dispatcher);
        CommandSubscribe.register(dispatcher);
        CommandTop.register(dispatcher);
        CommandNear.register(dispatcher);
        CommandLagSpike.register(dispatcher);
        CommandRename.register(dispatcher, access);
        CommandMods.register(dispatcher);
        CommandGhostPlayer.register(dispatcher);
        CommandConfig.register(dispatcher);
        CommandTeamTeleportBlacklist.register(dispatcher);
    }

    public void onPlayerLoggedIn(class_3222 player) {
        GameRuleNetworkHandler.INSTANCE.sayHello(player);
    }

    public Map<String, String> canHasTranslations(String lang) {
        return EssentialUtils.getTranslations(lang);
    }
}

