/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.util;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Either;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2561;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public final class CUtil {
    private static final DynamicCommandExceptionType REGEX_TOO_SLOW_EXCEPTION = new DynamicCommandExceptionType(arg -> class_2561.method_43469((String)"commands.client.regexTooSlow", (Object[])new Object[]{arg}));

    private CUtil() {
    }

    public static boolean regexFindSafe(Pattern regex, CharSequence input) throws CommandSyntaxException {
        return regex.matcher(new FusedRegexInput(regex, input)).find();
    }

    @NotNull
    public static RuntimeException sneakyThrow(Throwable e) {
        CUtil.sneakyThrowHelper(e);
        return null;
    }

    private static <T extends Throwable> void sneakyThrowHelper(Throwable e) throws T {
        throw e;
    }

    public static <L, R> void forEither(Either<L, R> either, Consumer<? super L> left, Consumer<? super R> right) {
        either.map(l -> {
            left.accept((Object)l);
            return null;
        }, r -> {
            right.accept((Object)r);
            return null;
        });
    }

    public static int getEnchantmentLevel(class_5455 registryAccess, class_5321<class_1887> enchantment, class_1799 stack) {
        Optional enchHolder = registryAccess.method_30530(class_7924.field_41265).method_40264(enchantment);
        return enchHolder.isPresent() ? class_1890.method_8225((class_6880)((class_6880)enchHolder.get()), (class_1799)stack) : 0;
    }

    public static int getEnchantmentLevel(class_5321<class_1887> enchantment, class_1309 entity) {
        Optional enchHolder = entity.method_56673().method_30530(class_7924.field_41265).method_40264(enchantment);
        if (enchHolder.isEmpty()) {
            return 0;
        }
        return Arrays.stream(class_1304.values()).mapToInt(slot -> entity.method_6118(slot).method_58657().method_57536((class_6880)enchHolder.get())).max().orElse(0);
    }

    private static class FusedRegexInput
    implements CharSequence {
        private static final long FUSE_LENGTH = 50000000L;
        private final long startTime;
        private final Pattern regex;
        private final CharSequence delegate;

        private FusedRegexInput(long startTime, Pattern regex, CharSequence delegate) {
            this.startTime = startTime;
            this.regex = regex;
            this.delegate = delegate;
        }

        private FusedRegexInput(Pattern regex, CharSequence delegate) throws CommandSyntaxException {
            this(System.nanoTime(), regex, delegate);
        }

        @Override
        public int length() {
            return this.delegate.length();
        }

        @Override
        public char charAt(int i) {
            this.checkFuse();
            return this.delegate.charAt(i);
        }

        @Override
        @NotNull
        public CharSequence subSequence(int start, int end) {
            return new FusedRegexInput(this.startTime, this.regex, this.delegate.subSequence(start, end));
        }

        private void checkFuse() {
            if (System.nanoTime() - this.startTime > 50000000L) {
                throw CUtil.sneakyThrow(REGEX_TOO_SLOW_EXCEPTION.create((Object)this.regex.pattern()));
            }
        }

        @Override
        @NotNull
        public String toString() {
            return this.delegate.toString();
        }
    }
}

