/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.util;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.lang.reflect.Field;
import java.util.Map;

public final class BrigadierRemover<S> {
    private static final Field CHILDREN_FIELD;
    private static final Field LITERALS_FIELD;
    private static final Field ARGUMENTS_FIELD;
    private static final BrigadierRemover<?> NULL;
    private final CommandNode<S> parentNode;
    private final CommandNode<S> thisNode;

    private BrigadierRemover(CommandNode<S> parentNode, CommandNode<S> thisNode) {
        this.parentNode = parentNode;
        this.thisNode = thisNode;
    }

    public static <S> BrigadierRemover<S> of(CommandDispatcher<S> dispatcher) {
        return new BrigadierRemover<S>(null, dispatcher.getRoot());
    }

    public BrigadierRemover<S> get(String child) {
        if (this.thisNode == null) {
            return NULL;
        }
        return new BrigadierRemover<S>(this.thisNode, this.thisNode.getChild(child));
    }

    public boolean remove() {
        Map parentArguments;
        Map parentLiterals;
        Map parentChildren;
        if (this.thisNode == null || this.parentNode == null) {
            return false;
        }
        try {
            parentChildren = (Map)CHILDREN_FIELD.get(this.parentNode);
            parentLiterals = this.thisNode instanceof LiteralCommandNode ? (Map)LITERALS_FIELD.get(this.parentNode) : null;
            parentArguments = this.thisNode instanceof ArgumentCommandNode ? (Map)ARGUMENTS_FIELD.get(this.parentNode) : null;
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
        parentChildren.remove(this.thisNode.getName());
        if (this.thisNode instanceof LiteralCommandNode) {
            parentLiterals.remove(this.thisNode.getName());
        } else if (this.thisNode instanceof ArgumentCommandNode) {
            parentArguments.remove(this.thisNode.getName());
        }
        return true;
    }

    static {
        try {
            CHILDREN_FIELD = CommandNode.class.getDeclaredField("children");
            LITERALS_FIELD = CommandNode.class.getDeclaredField("literals");
            ARGUMENTS_FIELD = CommandNode.class.getDeclaredField("arguments");
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
        CHILDREN_FIELD.setAccessible(true);
        LITERALS_FIELD.setAccessible(true);
        ARGUMENTS_FIELD.setAccessible(true);
        NULL = new BrigadierRemover(null, null);
    }
}

