/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.render;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalDouble;
import net.earthcomputer.clientcommands.render.Cuboid;
import net.earthcomputer.clientcommands.render.Line;
import net.earthcomputer.clientcommands.render.Shape;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4668;

public class RenderQueue {
    private static int tickCounter = 0;
    private static final List<AddQueueEntry> addQueue = new ArrayList<AddQueueEntry>();
    private static final List<RemoveQueueEntry> removeQueue = new ArrayList<RemoveQueueEntry>();
    private static final EnumMap<Layer, Map<Object, Shape>> queue = new EnumMap(Layer.class);
    public static class_1921 NO_DEPTH_LAYER;

    public static void add(Layer layer, Object key, Shape shape, int life) {
        addQueue.add(new AddQueueEntry(layer, key, shape, life));
    }

    public static void addCuboid(Layer layer, Object key, class_243 from, class_243 to, int color, int life) {
        RenderQueue.add(layer, key, new Cuboid(from, to, color), life);
    }

    public static void addCuboid(Layer layer, Object key, class_238 cuboid, int color, int life) {
        RenderQueue.add(layer, key, new Cuboid(cuboid, color), life);
    }

    public static void addLine(Layer layer, Object key, class_243 from, class_243 to, int color, int life) {
        RenderQueue.add(layer, key, new Line(from, to, color), life);
    }

    public static void remove(Layer layer, Object key) {
        removeQueue.add(new RemoveQueueEntry(layer, key));
    }

    private static void doAdd(AddQueueEntry entry) {
        Map shapes = queue.computeIfAbsent(entry.layer(), k -> new LinkedHashMap());
        Shape oldShape = (Shape)shapes.get(entry.key());
        entry.shape().prevPos = oldShape != null ? oldShape.prevPos : entry.shape().getPos();
        entry.shape().deathTime = tickCounter + entry.life();
        shapes.put(entry.key(), entry.shape());
    }

    private static void tick(class_310 mc) {
        for (RemoveQueueEntry removeQueueEntry : removeQueue) {
            Map<Object, Shape> shapes2 = queue.get((Object)removeQueueEntry.layer());
            if (shapes2 == null) continue;
            shapes2.remove(removeQueueEntry.key());
        }
        removeQueue.clear();
        queue.values().forEach(shapes -> shapes.values().forEach(shape -> {
            shape.prevPos = shape.getPos();
        }));
        ++tickCounter;
        for (AddQueueEntry addQueueEntry : addQueue) {
            RenderQueue.doAdd(addQueueEntry);
        }
        addQueue.clear();
        for (Map map : queue.values()) {
            Iterator itr = map.values().iterator();
            while (itr.hasNext()) {
                Shape shape = (Shape)itr.next();
                if (tickCounter == shape.deathTime) {
                    itr.remove();
                }
                shape.tick();
            }
        }
    }

    public static void render(Layer layer, class_4588 vertexConsumer, class_4587 poseStack, float delta) {
        if (!queue.containsKey((Object)layer)) {
            return;
        }
        queue.get((Object)layer).values().forEach(shape -> shape.render(poseStack, vertexConsumer, delta));
    }

    static {
        ClientTickEvents.START_CLIENT_TICK.register(RenderQueue::tick);
        WorldRenderEvents.AFTER_ENTITIES.register(context -> {
            context.matrixStack().method_22903();
            class_243 cameraPos = context.camera().method_19326();
            context.matrixStack().method_22904(-cameraPos.field_1352, -cameraPos.field_1351, -cameraPos.field_1350);
            RenderQueue.render(Layer.ON_TOP, Objects.requireNonNull(context.consumers()).getBuffer(NO_DEPTH_LAYER), context.matrixStack(), context.tickCounter().method_60638());
            context.matrixStack().method_22909();
        });
        NO_DEPTH_LAYER = class_1921.method_24049((String)"clientcommands_no_depth", (class_293)class_290.field_29337, (class_293.class_5596)class_293.class_5596.field_27377, (int)256, (boolean)true, (boolean)true, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(class_1921.field_29433).method_23616(class_1921.field_21350).method_23603(class_1921.field_21345).method_23604(class_1921.field_21346).method_23607(class_1921.field_22241).method_23609(new class_4668.class_4677(OptionalDouble.of(2.0))).method_23617(true));
    }

    private record AddQueueEntry(Layer layer, Object key, Shape shape, int life) {
    }

    public static enum Layer {
        ON_TOP;

    }

    private record RemoveQueueEntry(Layer layer, Object key) {
    }
}

