/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.features;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.logging.LogUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntConsumer;
import java.util.stream.Stream;
import net.earthcomputer.clientcommands.ClientCommands;
import net.earthcomputer.clientcommands.Configs;
import net.earthcomputer.clientcommands.command.VarCommand;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1132;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4239;
import net.minecraft.class_5218;
import net.minecraft.class_634;
import net.minecraft.class_642;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ClientCommandFunctions {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Path FUNCTION_DIR = ClientCommands.configDir.resolve("functions");
    private static final DynamicCommandExceptionType NO_SUCH_FUNCTION_EXCEPTION = new DynamicCommandExceptionType(id -> class_2561.method_43469((String)"arguments.function.unknown", (Object[])new Object[]{id}));
    private static final DynamicCommandExceptionType COMMAND_LIMIT_REACHED_EXCEPTION = new DynamicCommandExceptionType(limit -> class_2561.method_43469((String)"commands.cfunction.limitReached", (Object[])new Object[]{limit}));
    @Nullable
    private static ExecutionContext currentContext = null;

    @Nullable
    public static Path getLocalStartupFunction() {
        return CommandFunction.getPath(ClientCommandFunctions.getLocalStartupFunctionStr());
    }

    private static String getLocalStartupFunctionStr() {
        class_1132 server;
        class_310 mc = class_310.method_1551();
        class_642 mpServer = mc.method_1558();
        Object startupFunction = mpServer != null ? "startup_multiplayer_" + mpServer.field_3761.replace(':', '_') : ((server = mc.method_1576()) != null ? "startup_singleplayer_" + String.valueOf(server.method_27050(class_5218.field_24188).normalize().getFileName()) : "startup");
        return startupFunction;
    }

    public static boolean ensureLocalStartupFunctionExists() throws IOException {
        Path file = ClientCommandFunctions.getLocalStartupFunction();
        if (file == null) {
            return false;
        }
        if (Files.exists(file, new LinkOption[0])) {
            return true;
        }
        ClientCommandFunctions.ensureGlobalStartupFunctionExists();
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            writer.append("# This file contains commands to be run when joining this world/server.");
            writer.newLine();
            writer.newLine();
            writer.append("# Run the default startup commands.");
            writer.newLine();
            writer.append("cfunction startup");
            writer.newLine();
        }
        return true;
    }

    public static Path getGlobalStartupFunction() {
        return FUNCTION_DIR.resolve("startup.mcfunction");
    }

    public static void ensureGlobalStartupFunctionExists() throws IOException {
        Path file = ClientCommandFunctions.getGlobalStartupFunction();
        if (Files.exists(file, new LinkOption[0])) {
            return;
        }
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            writer.append("# This file contains commands to be run when joining any world/server.");
            writer.newLine();
        }
    }

    public static void runStartup() {
        String startupFunction = ClientCommandFunctions.getLocalStartupFunctionStr();
        Path path = CommandFunction.getPath(startupFunction);
        if (!(path != null && Files.exists(path, new LinkOption[0]) || (path = CommandFunction.getPath(startupFunction = "startup")) != null && Files.exists(path, new LinkOption[0]))) {
            return;
        }
        LOGGER.info("Running startup function {}", (Object)startupFunction);
        try {
            CommandDispatcher dispatcher = ClientCommandManager.getActiveDispatcher();
            class_634 packetListener = class_310.method_1551().method_1562();
            assert (packetListener != null) : "Network handler should not be null while calling ClientCommandFunctions.runStartup()";
            FabricClientCommandSource source = (FabricClientCommandSource)packetListener.method_2875();
            int result = ClientCommandFunctions.executeFunction((CommandDispatcher<FabricClientCommandSource>)dispatcher, source, startupFunction, res -> {});
            LOGGER.info("Ran {} commands from startup function {}", (Object)result, (Object)startupFunction);
        }
        catch (CommandSyntaxException e) {
            LOGGER.error("Error running startup function {}: {}", (Object)startupFunction, (Object)e.getMessage());
        }
    }

    public static List<String> allFunctions() {
        List<String> list;
        block8: {
            Stream<Path> paths = Files.walk(FUNCTION_DIR, new FileVisitOption[0]);
            try {
                list = paths.filter(path -> !Files.isDirectory(path, new LinkOption[0]) && path.getFileName().toString().endsWith(".mcfunction")).map(path -> {
                    String name = FUNCTION_DIR.relativize((Path)path).toString();
                    return name.substring(0, name.length() - ".mcfunction".length()).replace(File.separator, "/");
                }).toList();
                if (paths == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return Collections.emptyList();
                }
            }
            paths.close();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeFunction(CommandDispatcher<FabricClientCommandSource> dispatcher, FabricClientCommandSource source, String function, IntConsumer successMessageSender) throws CommandSyntaxException {
        if (currentContext != null) {
            CommandFunction func = ClientCommandFunctions.currentContext.functions.get(function);
            if (func == null) {
                func = CommandFunction.load(ClientCommandFunctions.currentContext.dispatcher, ClientCommandFunctions.currentContext.source, function);
                ClientCommandFunctions.currentContext.functions.put(function, func);
            }
            for (int i = func.entries.size() - 1; i >= 0; --i) {
                ClientCommandFunctions.currentContext.entries.addFirst((Entry)func.entries.get(i));
            }
            return 1;
        }
        CommandFunction func = CommandFunction.load(dispatcher, source, function);
        HashMap<String, CommandFunction> functions = new HashMap<String, CommandFunction>();
        functions.put(function, func);
        ArrayDeque<Entry> entries = new ArrayDeque<Entry>((Collection<Entry>)func.entries);
        currentContext = new ExecutionContext(dispatcher, source, entries, functions);
        try {
            int count = 0;
            while (!entries.isEmpty()) {
                if (count++ >= Configs.commandExecutionLimit) {
                    throw COMMAND_LIMIT_REACHED_EXCEPTION.create((Object)Configs.commandExecutionLimit);
                }
                ((Entry)entries.remove()).execute(dispatcher, source);
            }
            successMessageSender.accept(count);
            int n = count;
            return n;
        }
        finally {
            currentContext = null;
        }
    }

    private record CommandFunction(ImmutableList<Entry> entries) {
        @Nullable
        static Path getPath(String function) {
            Path path;
            if (!"/".equals(File.separator)) {
                if (function.contains(File.separator)) {
                    return null;
                }
                function = function.replace("/", File.separator);
            }
            try {
                path = FUNCTION_DIR.resolve(function + ".mcfunction");
            }
            catch (InvalidPathException e) {
                return null;
            }
            if (!class_4239.method_20200((Path)path) || !class_4239.method_20201((Path)path)) {
                return null;
            }
            return path;
        }

        static CommandFunction load(CommandDispatcher<FabricClientCommandSource> dispatcher, FabricClientCommandSource source, String function) throws CommandSyntaxException {
            Path path = CommandFunction.getPath(function);
            if (path == null || !Files.exists(path, new LinkOption[0])) {
                throw NO_SUCH_FUNCTION_EXCEPTION.create((Object)function);
            }
            ImmutableList.Builder entries = ImmutableList.builder();
            try (Stream<String> lines = Files.lines(path);){
                for (String line : lines::iterator) {
                    if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                    if (VarCommand.containsVars(line)) {
                        entries.add((Object)new LazyEntry(line));
                        continue;
                    }
                    ParseResults command = dispatcher.parse(line, (Object)source);
                    if (command.getReader().canRead()) {
                        throw class_2170.method_23917((ParseResults)command);
                    }
                    entries.add((Object)new ParsedEntry(line, (ParseResults<FabricClientCommandSource>)command));
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to read function file {}", (Object)path, (Object)e);
                throw NO_SUCH_FUNCTION_EXCEPTION.create((Object)function);
            }
            return new CommandFunction((ImmutableList<Entry>)entries.build());
        }
    }

    private record ExecutionContext(CommandDispatcher<FabricClientCommandSource> dispatcher, FabricClientCommandSource source, Deque<Entry> entries, Map<String, CommandFunction> functions) {
    }

    private static interface Entry {
        public void execute(CommandDispatcher<FabricClientCommandSource> var1, FabricClientCommandSource var2) throws CommandSyntaxException;
    }

    private record LazyEntry(String command) implements Entry
    {
        @Override
        public void execute(CommandDispatcher<FabricClientCommandSource> dispatcher, FabricClientCommandSource source) throws CommandSyntaxException {
            String replacedCommand = VarCommand.replaceVariables(this.command);
            ClientCommands.sendCommandExecutionToServer(replacedCommand);
            dispatcher.execute(replacedCommand, (Object)source);
        }
    }

    private record ParsedEntry(String commandString, ParseResults<FabricClientCommandSource> command) implements Entry
    {
        @Override
        public void execute(CommandDispatcher<FabricClientCommandSource> dispatcher, FabricClientCommandSource source) throws CommandSyntaxException {
            ClientCommands.sendCommandExecutionToServer(this.commandString);
            dispatcher.execute(this.command);
        }
    }
}

