/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.event;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_638;

public final class ClientLevelEvents {
    public static final Event<LoadLevel> LOAD_LEVEL = EventFactory.createArrayBacked(LoadLevel.class, listeners -> level -> {
        for (LoadLevel listener : listeners) {
            listener.onLoadLevel(level);
        }
    });
    public static final Event<UnloadLevel> UNLOAD_LEVEL = EventFactory.createArrayBacked(UnloadLevel.class, listeners -> isDisconnect -> {
        for (UnloadLevel listener : listeners) {
            listener.onUnloadLevel(isDisconnect);
        }
    });
    public static final Event<ChunkUpdate> CHUNK_UPDATE = EventFactory.createArrayBacked(ChunkUpdate.class, listeners -> (level, pos, oldState, newState) -> {
        for (ChunkUpdate listener : listeners) {
            listener.onBlockStateUpdate(level, pos, oldState, newState);
        }
    });
    public static final Event<LoadChunk> LOAD_CHUNK = EventFactory.createArrayBacked(LoadChunk.class, listeners -> (level, pos) -> {
        for (LoadChunk listener : listeners) {
            listener.onLoadChunk(level, pos);
        }
    });
    public static final Event<UnloadChunk> UNLOAD_CHUNK = EventFactory.createArrayBacked(UnloadChunk.class, listeners -> (level, pos) -> {
        for (UnloadChunk listener : listeners) {
            listener.onUnloadChunk(level, pos);
        }
    });

    @FunctionalInterface
    public static interface UnloadChunk {
        public void onUnloadChunk(class_638 var1, class_1923 var2);
    }

    @FunctionalInterface
    public static interface LoadChunk {
        public void onLoadChunk(class_638 var1, class_1923 var2);
    }

    @FunctionalInterface
    public static interface ChunkUpdate {
        public void onBlockStateUpdate(class_638 var1, class_2338 var2, class_2680 var3, class_2680 var4);
    }

    @FunctionalInterface
    public static interface UnloadLevel {
        public void onUnloadLevel(boolean var1);
    }

    @FunctionalInterface
    public static interface LoadLevel {
        public void onLoadLevel(class_638 var1);
    }
}

