/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command.arguments;

import com.google.common.collect.Iterables;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.xpple.clientarguments.arguments.CEntityArgument;
import dev.xpple.clientarguments.arguments.CEntitySelector;
import dev.xpple.clientarguments.arguments.CEntitySelectorReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2172;
import net.minecraft.class_640;

public class EntityUUIDArgument
implements ArgumentType<Result> {
    private static final Collection<String> EXAMPLES = Arrays.asList("Player", "0123", "dd12be42-52a9-4a91-a8a1-11c01849e498", "@e");

    public static EntityUUIDArgument entityUuid() {
        return new EntityUUIDArgument();
    }

    public static UUID getEntityUuid(CommandContext<FabricClientCommandSource> context, String name) throws CommandSyntaxException {
        return ((Result)context.getArgument(name, Result.class)).getUUID((FabricClientCommandSource)context.getSource());
    }

    public Result parse(StringReader reader) throws CommandSyntaxException {
        if (reader.canRead() && reader.peek() == '@') {
            CEntitySelectorReader selectorReader = new CEntitySelectorReader(reader);
            CEntitySelector selector = selectorReader.read();
            return new SelectorBacked(selector);
        }
        int start = reader.getCursor();
        while (reader.canRead() && reader.peek() != ' ') {
            reader.skip();
        }
        String argument = reader.getString().substring(start, reader.getCursor());
        try {
            UUID uuid = UUID.fromString(argument);
            return new UuidBacked(uuid);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new NameBacked(argument);
        }
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        Object object = context.getSource();
        if (object instanceof class_2172) {
            class_2172 commandSource = (class_2172)object;
            StringReader stringReader = new StringReader(builder.getInput());
            stringReader.setCursor(builder.getStart());
            CEntitySelectorReader entitySelectorReader = new CEntitySelectorReader(stringReader, true);
            try {
                entitySelectorReader.read();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            return entitySelectorReader.listSuggestions(builder, builderx -> {
                Collection collection = commandSource.method_9262();
                Iterable iterable = Iterables.concat((Iterable)collection, (Iterable)commandSource.method_9269());
                class_2172.method_9265((Iterable)iterable, (SuggestionsBuilder)builderx);
            });
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    static sealed interface Result
    permits NameBacked, UuidBacked, SelectorBacked {
        public UUID getUUID(FabricClientCommandSource var1) throws CommandSyntaxException;
    }

    private record SelectorBacked(CEntitySelector selector) implements Result
    {
        @Override
        public UUID getUUID(FabricClientCommandSource source) throws CommandSyntaxException {
            return this.selector.getEntity(source).method_5667();
        }
    }

    private record UuidBacked(UUID uuid) implements Result
    {
        @Override
        public UUID getUUID(FabricClientCommandSource source) {
            return this.uuid;
        }
    }

    private record NameBacked(String name) implements Result
    {
        @Override
        public UUID getUUID(FabricClientCommandSource source) throws CommandSyntaxException {
            class_640 entry = source.getClient().method_1562().method_2874(this.name);
            if (entry == null) {
                throw CEntityArgument.ENTITY_NOT_FOUND_EXCEPTION.create();
            }
            return entry.method_2966().getId();
        }
    }
}

