/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import com.google.common.cache.CacheBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.xpple.clientarguments.arguments.CGameProfileArgument;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.earthcomputer.clientcommands.c2c.C2CPacketHandler;
import net.earthcomputer.clientcommands.c2c.packets.PutTicTacToeMarkC2CPacket;
import net.earthcomputer.clientcommands.c2c.packets.StartTicTacToeGameC2CPacket;
import net.earthcomputer.clientcommands.command.ClientCommandHelper;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2172;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_640;

public class TicTacToeCommand {
    private static final SimpleCommandExceptionType PLAYER_NOT_FOUND_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.ctictactoe.playerNotFound"));
    private static final SimpleCommandExceptionType NO_GAME_WITH_PLAYER_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.ctictactoe.noGameWithPlayer"));
    private static final Map<String, TicTacToeGame> activeGames = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMinutes(15L)).build().asMap();
    private static final Set<String> pendingInvites = Collections.newSetFromMap(CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMinutes(5L)).build().asMap());

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"ctictactoe").then(ClientCommandManager.literal((String)"start").then(ClientCommandManager.argument((String)"opponent", (ArgumentType)CGameProfileArgument.gameProfile((boolean)true)).executes(ctx -> TicTacToeCommand.start((FabricClientCommandSource)ctx.getSource(), CGameProfileArgument.getSingleProfileArgument((CommandContext)ctx, (String)"opponent")))))).then(ClientCommandManager.literal((String)"open").then(ClientCommandManager.argument((String)"opponent", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> class_2172.method_9265(activeGames.keySet(), (SuggestionsBuilder)builder)).executes(ctx -> TicTacToeCommand.open((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"opponent"))))));
    }

    private static int start(FabricClientCommandSource source, GameProfile player) throws CommandSyntaxException {
        class_640 recipient = source.getClient().method_1562().method_2871(player.getId());
        if (recipient == null) {
            throw PLAYER_NOT_FOUND_EXCEPTION.create();
        }
        StartTicTacToeGameC2CPacket packet = new StartTicTacToeGameC2CPacket(source.getClient().method_1562().method_2879().getName(), false);
        C2CPacketHandler.getInstance().sendPacket(packet, recipient);
        pendingInvites.add(recipient.method_2966().getName());
        source.sendFeedback((class_2561)class_2561.method_43469((String)"c2cpacket.startTicTacToeGameC2CPacket.outgoing.invited", (Object[])new Object[]{recipient.method_2966().getName()}));
        return 1;
    }

    public static void onStartTicTacToeGameC2CPacket(StartTicTacToeGameC2CPacket packet) {
        String sender = packet.sender();
        class_640 opponent = class_310.method_1551().method_1562().method_2874(sender);
        if (opponent == null) {
            return;
        }
        if (packet.accept() && pendingInvites.remove(sender)) {
            TicTacToeGame game = new TicTacToeGame(opponent, TicTacToeGame.Mark.CROSS);
            activeGames.put(sender, game);
            class_5250 component = class_2561.method_43469((String)"c2cpacket.startTicTacToeGameC2CPacket.incoming.accepted", (Object[])new Object[]{sender});
            component.method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/ctictactoe open " + sender)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)("/ctictactoe open " + sender)))));
            class_310.method_1551().field_1705.method_1743().method_1812((class_2561)component);
            return;
        }
        class_5250 component = class_2561.method_43469((String)"c2cpacket.startTicTacToeGameC2CPacket.incoming", (Object[])new Object[]{sender});
        component.method_27693(" [").method_10852((class_2561)class_2561.method_43471((String)"c2cpacket.startTicTacToeGameC2CPacket.incoming.accept").method_27694(style -> style.method_10977(class_124.field_1060).method_10958(new class_2558(class_2558.class_2559.field_11748, ClientCommandHelper.registerCode(() -> {
            TicTacToeGame game = new TicTacToeGame(opponent, TicTacToeGame.Mark.NOUGHT);
            activeGames.put(sender, game);
            StartTicTacToeGameC2CPacket acceptPacket = new StartTicTacToeGameC2CPacket(class_310.method_1551().method_1562().method_2879().getName(), true);
            try {
                C2CPacketHandler.getInstance().sendPacket(acceptPacket, opponent);
            }
            catch (CommandSyntaxException e) {
                class_310.method_1551().field_1705.method_1743().method_1812(class_2561.method_54155((Message)e.getRawMessage()));
            }
            class_310.method_1551().field_1705.method_1743().method_1812((class_2561)class_2561.method_43471((String)"c2cpacket.startTicTacToeGameC2CPacket.outgoing.accept"));
        }))).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"c2cpacket.startTicTacToeGameC2CPacket.incoming.accept.hover"))))).method_27693("]");
        class_310.method_1551().field_1705.method_1743().method_1812((class_2561)component);
    }

    private static int open(FabricClientCommandSource source, String name) throws CommandSyntaxException {
        TicTacToeGame game = activeGames.get(name);
        if (game == null) {
            throw NO_GAME_WITH_PLAYER_EXCEPTION.create();
        }
        source.getClient().method_18858(() -> source.getClient().method_1507((class_437)new TicTacToeGameScreen(game)));
        return 1;
    }

    public static void onPutTicTacToeMarkC2CPacket(PutTicTacToeMarkC2CPacket packet) {
        String sender = packet.sender();
        TicTacToeGame game = activeGames.get(sender);
        if (game == null) {
            return;
        }
        if (game.putMark(packet.x(), packet.y(), game.yourMarks.opposite())) {
            if (game.getWinner() == game.yourMarks.opposite()) {
                class_310.method_1551().field_1705.method_1743().method_1812((class_2561)class_2561.method_43469((String)"c2cpacket.putTicTacToeMarkC2CPacket.incoming.lost", (Object[])new Object[]{sender}));
                activeGames.remove(sender);
                return;
            }
            class_5250 component = class_2561.method_43469((String)"c2cpacket.putTicTacToeMarkC2CPacket.incoming", (Object[])new Object[]{sender});
            component.method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/ctictactoe open " + sender)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)("/ctictactoe open " + sender)))));
            class_310.method_1551().field_1705.method_1743().method_1812((class_2561)component);
        }
    }

    private static class TicTacToeGame {
        public final class_640 opponent;
        private final Mark[][] board = new Mark[3][3];
        private final Mark yourMarks;
        private boolean yourTurn;

        public TicTacToeGame(class_640 opponent, Mark yourMarks) {
            this.opponent = opponent;
            this.yourMarks = yourMarks;
            this.yourTurn = yourMarks == Mark.CROSS;
        }

        public boolean putMark(byte x, byte y, Mark mark) {
            if (this.yourMarks == mark == this.yourTurn && this.board[x][y] == null) {
                this.board[x][y] = mark;
                this.yourTurn = !this.yourTurn;
                return true;
            }
            return false;
        }

        public Mark getWinner() {
            for (int x = 0; x < 3; x = (int)((byte)(x + 1))) {
                if (this.board[x][0] == this.board[x][1] && this.board[x][1] == this.board[x][2] && this.board[x][0] != null) {
                    return this.board[x][0];
                }
                if (this.board[0][x] != this.board[1][x] || this.board[1][x] != this.board[2][x] || this.board[0][x] == null) continue;
                return this.board[0][x];
            }
            if (this.board[0][0] == this.board[1][1] && this.board[1][1] == this.board[2][2] && this.board[0][0] != null) {
                return this.board[0][0];
            }
            if (this.board[0][2] == this.board[1][1] && this.board[1][1] == this.board[2][0] && this.board[0][2] != null) {
                return this.board[0][2];
            }
            return null;
        }

        private static enum Mark {
            NOUGHT((class_2561)class_2561.method_43471((String)"ticTacToeGame.noughts")),
            CROSS((class_2561)class_2561.method_43471((String)"ticTacToeGame.crosses"));

            private final class_2561 name;

            private Mark(class_2561 name) {
                this.name = name;
            }

            public Mark opposite() {
                return this == NOUGHT ? CROSS : NOUGHT;
            }
        }
    }

    private static class TicTacToeGameScreen
    extends class_437 {
        private final TicTacToeGame game;
        private static final class_2960 GRID_TEXTURE = class_2960.method_60655((String)"clientcommands", (String)"textures/tic_tac_toe/grid.png");
        private static final class_2960 MARKS_TEXTURE = class_2960.method_60655((String)"clientcommands", (String)"textures/tic_tac_toe/marks.png");
        private static final int GRID_SIZE_TEXTURE = 512;
        private static final int MARK_SIZE_TEXTURE = 152;
        private static final int GRID_SIZE = 256;
        private static final int CELL_SIZE = 80;
        private static final int BORDER_SIZE = 8;
        private static final int MARK_SIZE = 76;
        private static final int PADDING = 2;

        private TicTacToeGameScreen(TicTacToeGame game) {
            super((class_2561)class_2561.method_43469((String)"ticTacToeGame.title", (Object[])new Object[]{game.opponent.method_2966().getName()}));
            this.game = game;
        }

        public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            super.method_25420(guiGraphics, mouseX, mouseY, partialTick);
            int startX = (this.field_22789 - 256) / 2;
            int startY = (this.field_22790 - 256) / 2;
            guiGraphics.method_27535(this.field_22793, this.field_22785, startX, startY - 20, -1);
            guiGraphics.method_27535(this.field_22793, (class_2561)class_2561.method_43469((String)"ticTacToeGame.playingWith", (Object[])new Object[]{this.game.yourMarks.name}), startX, startY - 10, -1);
            guiGraphics.method_25293(GRID_TEXTURE, startX, startY, 256, 256, 0.0f, 0.0f, 512, 512, 512, 512);
            TicTacToeGame.Mark[][] board = this.game.board;
            for (int x = 0; x < 3; x = (int)((byte)(x + 1))) {
                for (int y = 0; y < 3; y = (int)((byte)(y + 1))) {
                    TicTacToeGame.Mark mark = board[x][y];
                    if (mark == null) continue;
                    int offset = switch (mark.ordinal()) {
                        default -> throw new MatchException(null, null);
                        case 0 -> 0;
                        case 1 -> 152;
                    };
                    guiGraphics.method_25293(MARKS_TEXTURE, startX + 88 * x + 2, startY + 88 * y + 2, 76, 76, (float)offset, 0.0f, 152, 152, 304, 152);
                }
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            int startX = (this.field_22789 - 256) / 2;
            int startY = (this.field_22790 - 256) / 2;
            if (mouseX < (double)startX || mouseX > (double)(startX + 256) || mouseY < (double)startY || mouseY > (double)(startY + 256)) {
                return super.method_25402(mouseX, mouseY, button);
            }
            if (button != 0) {
                return false;
            }
            double relativeX = mouseX - (double)startX;
            byte x = (byte)(relativeX / 88.0);
            if (relativeX > (double)(88 * (x + 1) - 8)) {
                return false;
            }
            double relativeY = mouseY - (double)startY;
            byte y = (byte)(relativeY / 88.0);
            if (relativeY > (double)(88 * (y + 1) - 8)) {
                return false;
            }
            if (this.game.putMark(x, y, this.game.yourMarks)) {
                try {
                    PutTicTacToeMarkC2CPacket packet = new PutTicTacToeMarkC2CPacket(class_310.method_1551().method_1562().method_2879().getName(), x, y);
                    C2CPacketHandler.getInstance().sendPacket(packet, this.game.opponent);
                }
                catch (CommandSyntaxException e) {
                    class_310.method_1551().field_1705.method_1743().method_1812(class_2561.method_54155((Message)e.getRawMessage()));
                }
                if (this.game.getWinner() == this.game.yourMarks) {
                    activeGames.remove(this.game.opponent.method_2966().getName());
                }
                return true;
            }
            return false;
        }
    }
}

