/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.regex.Pattern;
import net.earthcomputer.clientcommands.command.FindBlockCommand;
import net.earthcomputer.clientcommands.command.arguments.ClientBlockPredicateArgument;
import net.earthcomputer.clientcommands.command.arguments.RegexArgument;
import net.earthcomputer.clientcommands.util.CUtil;
import net.earthcomputer.clientcommands.util.ThrowingPredicate;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2478;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_7225;
import net.minecraft.class_8242;

public class SignSearchCommand {
    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        LiteralCommandNode csignsearch = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"csignsearch").then(ClientCommandManager.literal((String)"text").then(ClientCommandManager.argument((String)"query", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> FindBlockCommand.findBlock((CommandContext<FabricClientCommandSource>)ctx, (class_2561)class_2561.method_43471((String)"commands.csignsearch.starting"), SignSearchCommand.predicate(StringArgumentType.getString((CommandContext)ctx, (String)"query"))))))).then(ClientCommandManager.literal((String)"regex").then(ClientCommandManager.argument((String)"query", (ArgumentType)RegexArgument.greedyRegex()).executes(ctx -> FindBlockCommand.findBlock((CommandContext<FabricClientCommandSource>)ctx, (class_2561)class_2561.method_43471((String)"commands.csignsearch.starting"), SignSearchCommand.predicate(RegexArgument.getRegex(ctx, "query")))))));
        FindBlockCommand.FLAG_KEEP_SEARCHING.addToCommand(dispatcher, (LiteralCommandNode<FabricClientCommandSource>)csignsearch, ctx -> true);
    }

    private static ClientBlockPredicateArgument.ClientBlockPredicate predicate(String query) {
        return SignSearchCommand.signPredicateFromLinePredicate(line -> line.contains(query));
    }

    private static ClientBlockPredicateArgument.ClientBlockPredicate predicate(Pattern query) {
        return SignSearchCommand.signPredicateFromLinePredicate(line -> CUtil.regexFindSafe(query, line));
    }

    private static ClientBlockPredicateArgument.ClientBlockPredicate signPredicateFromLinePredicate(final ThrowingPredicate<String> linePredicate) {
        return new ClientBlockPredicateArgument.ClientBlockPredicate(){

            @Override
            public boolean test(class_7225.class_7874 holderLookupProvider, class_1922 blockGetter, class_2338 pos) throws CommandSyntaxException {
                if (!(blockGetter.method_8320(pos).method_26204() instanceof class_2478)) {
                    return false;
                }
                class_2586 be = blockGetter.method_8321(pos);
                if (!(be instanceof class_2625)) {
                    return false;
                }
                class_2625 sign = (class_2625)be;
                class_8242 frontText = sign.method_49853();
                class_8242 backText = sign.method_49854();
                for (int i = 0; i < 4; ++i) {
                    String line = frontText.method_49859(i, class_310.method_1551().method_33883()).getString();
                    if (linePredicate.test(line)) {
                        return true;
                    }
                    line = backText.method_49859(i, class_310.method_1551().method_33883()).getString();
                    if (!linePredicate.test(line)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean canEverMatch(class_2680 state) {
                return state.method_26204() instanceof class_2478;
            }
        };
    }
}

