/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Random;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public class MinesweeperCommand {
    private static final SimpleCommandExceptionType TOO_MANY_MINES_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.cminesweeper.tooManyMines"));

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cminesweeper").executes(ctx -> MinesweeperCommand.minesweeper((FabricClientCommandSource)ctx.getSource(), 9, 9, 10))).then(ClientCommandManager.literal((String)"beginner").executes(ctx -> MinesweeperCommand.minesweeper((FabricClientCommandSource)ctx.getSource(), 9, 9, 10)))).then(ClientCommandManager.literal((String)"intermediate").executes(ctx -> MinesweeperCommand.minesweeper((FabricClientCommandSource)ctx.getSource(), 16, 16, 40)))).then(ClientCommandManager.literal((String)"expert").executes(ctx -> MinesweeperCommand.minesweeper((FabricClientCommandSource)ctx.getSource(), 32, 16, 99)))).then(ClientCommandManager.literal((String)"custom").then(ClientCommandManager.argument((String)"width", (ArgumentType)IntegerArgumentType.integer((int)3, (int)128)).then(ClientCommandManager.argument((String)"height", (ArgumentType)IntegerArgumentType.integer((int)3, (int)128)).then(ClientCommandManager.argument((String)"mines", (ArgumentType)IntegerArgumentType.integer((int)0, (int)16375)).executes(ctx -> MinesweeperCommand.minesweeper((FabricClientCommandSource)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"width"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"height"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"mines"))))))));
    }

    private static int minesweeper(FabricClientCommandSource source, int width, int height, int mines) throws CommandSyntaxException {
        if (mines > width * height - 9) {
            throw TOO_MANY_MINES_EXCEPTION.create();
        }
        source.getClient().method_18858(() -> source.getClient().method_1507((class_437)new MinesweeperGameScreen(width, height, mines)));
        return 1;
    }

    private static class MinesweeperGameScreen
    extends class_437 {
        private static final class_2960 MINESWEEPER_ATLAS = class_2960.method_60655((String)"clientcommands", (String)"textures/minesweeper_atlas.png");
        private static final int MINESWEEPER_ATLAS_WIDTH = 128;
        private static final int MINESWEEPER_ATLAS_HEIGHT = 64;
        private static final Vector2i TOP_LEFT_UV = new Vector2i(0, 0);
        private static final Vector2i TOP_UV = new Vector2i(12, 0);
        private static final Vector2i TOP_RIGHT_UV = new Vector2i(28, 0);
        private static final Vector2i LEFT_UV = new Vector2i(0, 12);
        private static final Vector2i RIGHT_UV = new Vector2i(28, 12);
        private static final Vector2i BOTTOM_LEFT_UV = new Vector2i(0, 28);
        private static final Vector2i BOTTOM_UV = new Vector2i(12, 28);
        private static final Vector2i BOTTOM_RIGHT_UV = new Vector2i(28, 28);
        private static final Vector2i NOT_A_MINE_TILE_UV = new Vector2i(68, 32);
        private static final Vector2i MINE_TILE_UV = new Vector2i(52, 32);
        private static final Vector2i RED_MINE_TILE_UV = new Vector2i(84, 16);
        private static final Vector2i EMPTY_TILE_UV = new Vector2i(12, 12);
        private static final Vector2i HOVERED_TILE_UV = new Vector2i(100, 16);
        private static final Vector2i HOVERED_FLAGGED_TILE_UV = new Vector2i(36, 32);
        private static final Vector2i FLAGGED_TILE_UV = new Vector2i(100, 32);
        private static final Vector2i TILE_UV = new Vector2i(84, 32);
        private static final Vector2i ONE_TILE_UV = new Vector2i(36, 0);
        private static final Vector2i TWO_TILE_UV = new Vector2i(52, 0);
        private static final Vector2i THREE_TILE_UV = new Vector2i(68, 0);
        private static final Vector2i FOUR_TILE_UV = new Vector2i(84, 0);
        private static final Vector2i FIVE_TILE_UV = new Vector2i(100, 0);
        private static final Vector2i SIX_TILE_UV = new Vector2i(36, 16);
        private static final Vector2i SEVEN_TILE_UV = new Vector2i(52, 16);
        private static final Vector2i EIGHT_TILE_UV = new Vector2i(68, 16);
        private static final Vector2i[] WARNING_TILE_UV = new Vector2i[]{ONE_TILE_UV, TWO_TILE_UV, THREE_TILE_UV, FOUR_TILE_UV, FIVE_TILE_UV, SIX_TILE_UV, SEVEN_TILE_UV, EIGHT_TILE_UV};
        private static final byte EMPTY_TILE_TYPE = 0;
        private static final byte WARNING_TILE_TYPE = 1;
        private static final byte MINE_TILE_TYPE = 2;
        private static final Random random = new Random();
        private final int boardWidth;
        private final int boardHeight;
        private final int mines;
        private int ticksPlaying;
        private final byte[] board;
        private final int gameWidth;
        private final int gameHeight;
        private int topLeftX;
        private int topLeftY;
        @Nullable
        private Vector2i deathCoords;
        private int minesLeft;
        private int emptyTilesRemaining;

        MinesweeperGameScreen(int width, int height, int mines) {
            super((class_2561)class_2561.method_43471((String)"minesweeperGame.title"));
            this.boardWidth = width;
            this.boardHeight = height;
            this.mines = mines;
            this.ticksPlaying = 0;
            this.board = new byte[this.boardWidth * this.boardHeight];
            this.gameWidth = this.boardWidth * 16 + 20;
            this.gameHeight = this.boardHeight * 16 + 20;
            this.deathCoords = null;
            this.minesLeft = mines;
            this.emptyTilesRemaining = width * height - mines;
        }

        protected void method_25426() {
            this.topLeftX = (this.field_22789 - this.gameWidth) / 2;
            this.topLeftY = (this.field_22790 - this.gameHeight) / 2;
        }

        public void method_25394(class_332 graphics, int mouseX, int mouseY, float tickDelta) {
            int i;
            this.method_25420(graphics, mouseX, mouseY, tickDelta);
            graphics.method_25303(this.field_22787.field_1772, class_1074.method_4662((String)"minesweeperGame.minesLeft", (Object[])new Object[]{this.minesLeft}), this.topLeftX, this.topLeftY - 10, 0xFFFFFF);
            graphics.method_25300(this.field_22787.field_1772, this.field_22785.getString(), this.topLeftX + this.gameWidth / 2, this.topLeftY - 20, 0xFFFFFF);
            String str = class_1074.method_4662((String)"minesweeperGame.timePlayed", (Object[])new Object[]{Math.ceilDiv(this.ticksPlaying, 20)});
            int color = this.deathCoords != null ? 0xFF5555 : (this.emptyTilesRemaining <= 0 ? 0x55FF55 : 0xFFFFFF);
            graphics.method_25303(this.field_22787.field_1772, str, this.topLeftX + this.gameWidth - this.field_22787.field_1772.method_1727(str), this.topLeftY - 10, color);
            this.blitSprite(graphics, TOP_LEFT_UV, 0, 0, 12, 12);
            for (i = 0; i < this.boardWidth; ++i) {
                this.blitSprite(graphics, TOP_UV, 12 + i * 16, 0, 16, 12);
            }
            this.blitSprite(graphics, TOP_RIGHT_UV, 12 + this.boardWidth * 16, 0, 8, 12);
            for (i = 0; i < this.boardHeight; ++i) {
                this.blitSprite(graphics, LEFT_UV, 0, 12 + i * 16, 12, 16);
                this.blitSprite(graphics, RIGHT_UV, 12 + this.boardWidth * 16, 12 + i * 16, 8, 16);
            }
            this.blitSprite(graphics, BOTTOM_LEFT_UV, 0, 12 + this.boardHeight * 16, 12, 8);
            for (i = 0; i < this.boardWidth; ++i) {
                this.blitSprite(graphics, BOTTOM_UV, 12 + i * 16, 12 + this.boardHeight * 16, 16, 8);
            }
            this.blitSprite(graphics, BOTTOM_RIGHT_UV, 12 + this.boardWidth * 16, 12 + this.boardHeight * 16, 8, 8);
            for (int x = 0; x < this.boardWidth; ++x) {
                for (int y = 0; y < this.boardHeight; ++y) {
                    boolean hovered = class_3532.method_48116((int)(mouseX - this.topLeftX - 12), (int)16) == x && class_3532.method_48116((int)(mouseY - this.topLeftY - 12), (int)16) == y;
                    this.blitSprite(graphics, this.getTileSprite(x, y, hovered), x * 16 + 12, y * 16 + 12, 16, 16);
                }
            }
        }

        public void blitSprite(class_332 graphics, Vector2i uv, int x, int y, int width, int height) {
            graphics.method_25293(MINESWEEPER_ATLAS, this.topLeftX + x, this.topLeftY + y, width, height, (float)uv.x, (float)uv.y, width, height, 128, 64);
        }

        public void method_25393() {
            if (this.ticksPlaying > 0 && this.gameActive()) {
                ++this.ticksPlaying;
            }
        }

        public boolean method_25406(double mouseX, double mouseY, int button) {
            int tileY;
            int tileX = class_3532.method_48116((int)((int)(mouseX - (double)this.topLeftX - 12.0)), (int)16);
            if (this.isWithinBounds(tileX, tileY = class_3532.method_48116((int)((int)(mouseY - (double)this.topLeftY - 12.0)), (int)16)) && this.gameActive()) {
                if (button == 0) {
                    if (this.ticksPlaying == 0) {
                        this.generateMines(tileX, tileY);
                        this.ticksPlaying = 1;
                    }
                    this.click(tileX, tileY);
                    assert (this.field_22787 != null && this.field_22787.field_1724 != null);
                    if (this.emptyTilesRemaining <= 0) {
                        this.field_22787.field_1724.method_17356((class_3414)class_3417.field_14622.comp_349(), class_3419.field_15250, 1.0f, 2.0f);
                    } else if (this.deathCoords != null) {
                        this.field_22787.field_1724.method_17356((class_3414)class_3417.field_14624.comp_349(), class_3419.field_15250, 1.0f, 1.0f);
                    }
                } else if (button == 1) {
                    this.flag(tileX, tileY);
                }
            }
            return true;
        }

        private boolean gameActive() {
            return this.deathCoords == null && this.emptyTilesRemaining > 0;
        }

        private void generateMines(int avoidX, int avoidY) {
            for (int i = 0; i < this.mines; ++i) {
                int x = random.nextInt(this.boardWidth);
                int y = random.nextInt(this.boardHeight);
                if (class_3532.method_15382((int)(avoidX - x)) <= 1 && class_3532.method_15382((int)(avoidY - y)) <= 1) {
                    --i;
                    continue;
                }
                if (this.tileType(this.getTile(x, y)) == 2) {
                    --i;
                    continue;
                }
                this.incrementWarning(x - 1, y - 1);
                this.incrementWarning(x, y - 1);
                this.incrementWarning(x + 1, y - 1);
                this.incrementWarning(x - 1, y);
                this.setTile(x, y, this.createTile(true, false, 2, null));
                this.incrementWarning(x + 1, y);
                this.incrementWarning(x - 1, y + 1);
                this.incrementWarning(x, y + 1);
                this.incrementWarning(x + 1, y + 1);
            }
        }

        private void incrementWarning(int x, int y) {
            if (this.isWithinBounds(x, y)) {
                byte originalTile = this.getTile(x, y);
                if (this.tileType(originalTile) == 1) {
                    this.setTile(x, y, this.createTile(this.isCovered(originalTile), this.isFlagged(originalTile), 1, this.warningQuantity(originalTile) + 1));
                } else if (this.tileType(originalTile) == 0) {
                    this.setTile(x, y, this.createTile(this.isCovered(originalTile), this.isFlagged(originalTile), 1, 1));
                }
            }
        }

        private boolean isWithinBounds(int x, int y) {
            return 0 <= x && x < this.boardWidth && 0 <= y && y < this.boardHeight;
        }

        private void click(int x, int y) {
            byte tile = this.getTile(x, y);
            if (!this.isCovered(tile) || this.isFlagged(tile)) {
                return;
            }
            int type = this.tileType(tile);
            if (type == 1) {
                this.uncover(x, y);
                --this.emptyTilesRemaining;
            } else if (type == 2) {
                this.uncover(x, y);
                this.deathCoords = new Vector2i(x, y);
            } else {
                this.uncover(x, y);
                --this.emptyTilesRemaining;
                int[] queue = new int[this.emptyTilesRemaining + 1];
                int queueIdx = 0;
                queue[0] = y * this.boardWidth + x;
                while (queueIdx >= 0) {
                    int idx = queue[queueIdx--];
                    int xPart = idx % this.boardWidth;
                    int yPart = idx / this.boardWidth;
                    for (Vector2i possibleNeighbour : new Vector2i[]{new Vector2i(xPart - 1, yPart - 1), new Vector2i(xPart, yPart - 1), new Vector2i(xPart + 1, yPart - 1), new Vector2i(xPart - 1, yPart), new Vector2i(xPart + 1, yPart), new Vector2i(xPart - 1, yPart + 1), new Vector2i(xPart, yPart + 1), new Vector2i(xPart + 1, yPart + 1)}) {
                        if (!this.isWithinBounds(possibleNeighbour.x, possibleNeighbour.y)) continue;
                        byte value = this.getTile(possibleNeighbour.x, possibleNeighbour.y);
                        this.uncover(possibleNeighbour.x, possibleNeighbour.y);
                        if (!this.isCovered(value)) continue;
                        --this.emptyTilesRemaining;
                        if (this.tileType(value) != 0) continue;
                        queue[++queueIdx] = possibleNeighbour.y * this.boardWidth + possibleNeighbour.x;
                    }
                }
            }
        }

        private void flag(int x, int y) {
            if (!this.isCovered(this.getTile(x, y))) {
                return;
            }
            int n = y * this.boardWidth + x;
            byte by = (byte)(this.board[n] ^ 2);
            this.board[n] = by;
            this.minesLeft -= (by & 2) > 0 ? 1 : -1;
        }

        private Vector2i getTileSprite(int x, int y, boolean hovered) {
            byte tile = this.getTile(x, y);
            boolean flagged = this.isFlagged(tile);
            boolean covered = this.isCovered(tile);
            int type = this.tileType(tile);
            int warningQuantity = this.warningQuantity(tile);
            if (this.deathCoords != null && type == 2 && !flagged) {
                return new Vector2i(x, y).equals((Object)this.deathCoords) ? RED_MINE_TILE_UV : MINE_TILE_UV;
            }
            if (flagged) {
                return hovered && this.deathCoords == null ? HOVERED_FLAGGED_TILE_UV : (this.deathCoords != null && type != 2 ? NOT_A_MINE_TILE_UV : FLAGGED_TILE_UV);
            }
            if (covered) {
                return hovered && this.deathCoords == null ? (this.method_25397() ? EMPTY_TILE_UV : HOVERED_TILE_UV) : TILE_UV;
            }
            if (type == 0) {
                return EMPTY_TILE_UV;
            }
            return WARNING_TILE_UV[warningQuantity - 1];
        }

        private byte getTile(int x, int y) {
            return this.board[y * this.boardWidth + x];
        }

        private void setTile(int x, int y, byte value) {
            this.board[y * this.boardWidth + x] = value;
        }

        private int tileType(byte tile) {
            return (tile & 0xC) >>> 2;
        }

        private int warningQuantity(byte tile) {
            return ((tile & 0x70) >>> 4) + 1;
        }

        private boolean isCovered(byte tile) {
            return (tile & 1) == 0;
        }

        private void uncover(int x, int y) {
            int n = y * this.boardWidth + x;
            this.board[n] = (byte)(this.board[n] | 1);
        }

        private boolean isFlagged(byte tile) {
            return (tile & 2) > 0;
        }

        private byte createTile(boolean covered, boolean flagged, int type, @Nullable Integer warningQuantity) {
            if (!covered && flagged) {
                throw new IllegalArgumentException("Tile cannot be uncovered and flagged at once");
            }
            if (type == 1 && (warningQuantity == null || warningQuantity < 1 || warningQuantity > 8)) {
                throw new IllegalArgumentException("Warning tiles must have a warning quantity between 1 and 8");
            }
            if (type != 1 && warningQuantity != null) {
                throw new IllegalArgumentException("Non-Warning tiles must have a null warning quantity");
            }
            if (type != 0 && type != 1 && type != 2) {
                throw new IllegalArgumentException("Tile type must be empty, warning, or mine");
            }
            return (byte)((covered ? 0 : 1) | (flagged ? 1 : 0) << 1 | type << 2 | (warningQuantity == null ? 0 : warningQuantity - 1) << 4);
        }
    }
}

