/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import com.google.gson.stream.JsonWriter;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Array;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.Modifier;
import java.lang.runtime.SwitchBootstraps;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.earthcomputer.clientcommands.Configs;
import net.earthcomputer.clientcommands.command.arguments.PacketTypeArgument;
import net.earthcomputer.clientcommands.features.PacketDumper;
import net.earthcomputer.clientcommands.util.MappingsHelper;
import net.earthcomputer.clientcommands.util.ReflectionUtils;
import net.earthcomputer.clientcommands.util.UnsafeUtils;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_1923;
import net.minecraft.class_2378;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.slf4j.Logger;

public class ListenCommand {
    private static volatile boolean isEnabled = true;
    private static final SimpleCommandExceptionType COMMAND_DISABLED_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.clisten.commandDisabled"));
    private static final SimpleCommandExceptionType ALREADY_LISTENING_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.clisten.add.failed"));
    private static final SimpleCommandExceptionType NOT_LISTENING_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.clisten.remove.failed"));
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Set<class_2960> packets = new HashSet<class_2960>();
    private static PacketCallback callback;

    public static void disable() {
        isEnabled = false;
    }

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"clisten").then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"packet", (ArgumentType)PacketTypeArgument.packet()).executes(ctx -> ListenCommand.add((FabricClientCommandSource)ctx.getSource(), PacketTypeArgument.getPacket((CommandContext<FabricClientCommandSource>)ctx, "packet")))))).then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"packet", (ArgumentType)PacketTypeArgument.packet()).executes(ctx -> ListenCommand.remove((FabricClientCommandSource)ctx.getSource(), PacketTypeArgument.getPacket((CommandContext<FabricClientCommandSource>)ctx, "packet")))))).then(ClientCommandManager.literal((String)"list").executes(ctx -> ListenCommand.list((FabricClientCommandSource)ctx.getSource())))).then(ClientCommandManager.literal((String)"clear").executes(ctx -> ListenCommand.clear((FabricClientCommandSource)ctx.getSource()))));
    }

    private static int add(FabricClientCommandSource source, class_2960 packetType) throws CommandSyntaxException {
        ListenCommand.checkEnabled();
        if (!packets.add(packetType)) {
            throw ALREADY_LISTENING_EXCEPTION.create();
        }
        source.sendFeedback((class_2561)class_2561.method_43471((String)"commands.clisten.add.success"));
        if (callback == null) {
            callback = (packet, side) -> {
                class_2561 packetDataPreview;
                String packetData;
                if (Configs.packetDumpMethod == Configs.PacketDumpMethod.BYTE_BUF) {
                    StringWriter writer = new StringWriter();
                    try {
                        PacketDumper.dumpPacket(packet, new JsonWriter((Writer)writer));
                    }
                    catch (IOException e) {
                        LOGGER.error("Could not dump packet", (Throwable)e);
                        return;
                    }
                    packetData = writer.toString();
                    packetDataPreview = class_2561.method_43470((String)packetData.replace("\u00a7", "\\u00a7"));
                } else {
                    try {
                        packetDataPreview = ListenCommand.serialize(packet, (Set<Object>)new ReferenceOpenHashSet(), 0);
                        packetData = packetDataPreview.getString();
                    }
                    catch (StackOverflowError e) {
                        LOGGER.error("Could not serialize packet into a Component", (Throwable)e);
                        return;
                    }
                }
                String packetClassName = packet.getClass().getName().replace('.', '/');
                String mojmapPacketName = Objects.requireNonNullElse(MappingsHelper.namedOrIntermediaryToMojmap_class(packetClassName), packetClassName);
                mojmapPacketName = mojmapPacketName.substring(mojmapPacketName.lastIndexOf(47) + 1);
                class_5250 packetComponent = class_2561.method_43470((String)mojmapPacketName).method_27694(s -> s.method_30938(Boolean.valueOf(true)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)packetDataPreview)).method_10958(new class_2558(class_2558.class_2559.field_21462, packetData)));
                switch (side.ordinal()) {
                    case 0: {
                        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.clisten.sentPacket", (Object[])new Object[]{packetComponent}));
                        break;
                    }
                    case 1: {
                        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.clisten.receivedPacket", (Object[])new Object[]{packetComponent}));
                        break;
                    }
                    case 2: {
                        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.clisten.sentC2CPacket", (Object[])new Object[]{packetComponent}));
                        break;
                    }
                    case 3: {
                        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.clisten.receivedC2CPacket", (Object[])new Object[]{packetComponent}));
                    }
                }
            };
        }
        return 1;
    }

    private static int remove(FabricClientCommandSource source, class_2960 packetType) throws CommandSyntaxException {
        ListenCommand.checkEnabled();
        if (!packets.remove(packetType)) {
            throw NOT_LISTENING_EXCEPTION.create();
        }
        source.sendFeedback((class_2561)class_2561.method_43471((String)"commands.clisten.remove.success"));
        return 1;
    }

    private static int list(FabricClientCommandSource source) throws CommandSyntaxException {
        ListenCommand.checkEnabled();
        int amount = packets.size();
        if (amount == 0) {
            source.sendFeedback((class_2561)class_2561.method_43471((String)"commands.clisten.list.none"));
        } else {
            source.sendFeedback((class_2561)class_2561.method_43471((String)"commands.clisten.list"));
            for (class_2960 packetType : packets) {
                source.sendFeedback((class_2561)class_2561.method_43470((String)packetType.toString()));
            }
        }
        return amount;
    }

    private static int clear(FabricClientCommandSource source) throws CommandSyntaxException {
        ListenCommand.checkEnabled();
        int amount = packets.size();
        packets.clear();
        source.sendFeedback((class_2561)class_2561.method_43471((String)"commands.clisten.clear"));
        return amount;
    }

    private static void checkEnabled() throws CommandSyntaxException {
        if (!isEnabled) {
            throw COMMAND_DISABLED_EXCEPTION.create();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static class_2561 serialize(Object object, Set<Object> seen, int depth) {
        try {
            if (depth <= Configs.maximumPacketFieldDepth && seen.add(object)) {
                class_2561 class_25612 = ListenCommand.serializeInner(object, seen, depth);
                return class_25612;
            }
            class_5250 class_52502 = class_2561.method_43473();
            return class_52502;
        }
        finally {
            seen.remove(object);
        }
    }

    private static class_2561 serializeInner(Object object, Set<Object> seen, int depth) {
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_2561.class, String.class, Number.class, Boolean.class, Optional.class, Date.class, Instant.class, UUID.class, class_1923.class, class_2960.class, Message.class, Collection.class, Map.class, class_2378.class, class_5321.class, class_6880.class}, (Object)object2, n)) {
            case -1 -> class_2561.method_43470((String)"null");
            case 0 -> {
                class_2561 component = (class_2561)object2;
                yield component;
            }
            case 1 -> {
                String string = (String)object2;
                yield class_2561.method_43470((String)string);
            }
            case 2 -> {
                Number number = (Number)object2;
                yield class_2561.method_43470((String)number.toString());
            }
            case 3 -> {
                Boolean bool = (Boolean)object2;
                yield class_2561.method_43470((String)bool.toString());
            }
            case 4 -> {
                Optional optional = (Optional)object2;
                if (optional.isPresent()) {
                    yield ListenCommand.serialize(optional.get(), seen, depth + 1);
                }
                yield class_2561.method_43470((String)"empty");
            }
            case 5 -> {
                Date date = (Date)object2;
                yield class_2561.method_54157((Date)date);
            }
            case 6 -> {
                Instant instant = (Instant)object2;
                yield class_2561.method_54157((Date)Date.from(instant));
            }
            case 7 -> {
                UUID uuid = (UUID)object2;
                yield class_2561.method_54158((UUID)uuid);
            }
            case 8 -> {
                class_1923 chunkPos = (class_1923)object2;
                yield class_2561.method_54156((class_1923)chunkPos);
            }
            case 9 -> {
                class_2960 resourceLocation = (class_2960)object2;
                yield class_2561.method_54154((class_2960)resourceLocation);
            }
            case 10 -> {
                Message message = (Message)object2;
                yield class_2561.method_54155((Message)message);
            }
            case 11 -> {
                Collection collection = (Collection)object2;
                class_5250 component = class_2561.method_43470((String)"[");
                component.method_10852((class_2561)collection.stream().map(e -> ListenCommand.serialize(e, seen, depth + 1).method_27661()).reduce((l, r) -> l.method_27693(", ").method_10852((class_2561)r)).orElse(class_2561.method_43473()));
                yield component.method_27693("]");
            }
            case 12 -> {
                Map map = (Map)object2;
                class_5250 component = class_2561.method_43470((String)"{");
                component.method_10852((class_2561)map.entrySet().stream().map(e -> ListenCommand.serialize(e.getKey(), seen, depth + 1).method_27661().method_27693("=").method_10852(ListenCommand.serialize(e.getValue(), seen, depth + 1))).reduce((l, r) -> l.method_27693(", ").method_10852((class_2561)r)).orElse(class_2561.method_43473()));
                yield component.method_27693("}");
            }
            case 13 -> {
                class_2378 registry = (class_2378)object2;
                yield class_2561.method_54154((class_2960)registry.method_30517().method_29177());
            }
            case 14 -> {
                class_5321 resourceKey = (class_5321)object2;
                class_5250 component = class_2561.method_43470((String)"{");
                component.method_27693("registry=").method_10852(ListenCommand.serialize(resourceKey.method_41185(), seen, depth + 1)).method_27693(", ");
                component.method_27693("location=").method_10852(ListenCommand.serialize(resourceKey.method_29177(), seen, depth + 1));
                yield component.method_27693("}");
            }
            case 15 -> {
                class_6880 holder = (class_6880)object2;
                class_5250 component = class_2561.method_43470((String)"{");
                component.method_27693("kind=").method_10852(ListenCommand.serialize(holder.method_40231().name(), seen, depth + 1)).method_27693(", ");
                component.method_27693("value=").method_10852(ListenCommand.serialize(holder.comp_349(), seen, depth + 1));
                yield component.method_27693("}");
            }
            default -> {
                if (object.getClass().isArray()) {
                    class_5250 component = class_2561.method_43470((String)"[");
                    int lengthMinusOne = Array.getLength(object) - 1;
                    if (lengthMinusOne < 0) {
                        yield component.method_27693("]");
                    }
                    for (int i = 0; i < lengthMinusOne; ++i) {
                        component.method_10852(ListenCommand.serialize(Array.get(object, i), seen, depth + 1)).method_27693(", ");
                    }
                    yield component.method_10852(ListenCommand.serialize(Array.get(object, lengthMinusOne), seen, depth + 1)).method_27693("]");
                }
                String className = object.getClass().getName().replace(".", "/");
                String mojmapClassName = Objects.requireNonNullElse(MappingsHelper.namedOrIntermediaryToMojmap_class(className), className);
                mojmapClassName = mojmapClassName.substring(mojmapClassName.lastIndexOf(47) + 1);
                class_5250 component = class_2561.method_43470((String)(mojmapClassName + "{"));
                component.method_10852((class_2561)ReflectionUtils.getAllFields(object.getClass()).filter(field -> !Modifier.isStatic(field.getModifiers())).map(field -> {
                    String fieldName = field.getName();
                    String mojmapFieldName = Objects.requireNonNullElse(MappingsHelper.namedOrIntermediaryToMojmap_field(className, fieldName), fieldName);
                    try {
                        field.setAccessible(true);
                        return class_2561.method_43470((String)(mojmapFieldName + "=")).method_10852(ListenCommand.serialize(field.get(object), seen, depth + 1));
                    }
                    catch (ReflectiveOperationException | InaccessibleObjectException e) {
                        try {
                            MethodHandles.Lookup implLookup = UnsafeUtils.getImplLookup();
                            if (implLookup == null) {
                                return class_2561.method_43470((String)(mojmapFieldName + "=")).method_10852((class_2561)class_2561.method_43471((String)"commands.clisten.packetError").method_27692(class_124.field_1079));
                            }
                            VarHandle varHandle = implLookup.findVarHandle(object.getClass(), fieldName, field.getType());
                            return class_2561.method_43470((String)(mojmapFieldName + "=")).method_10852(ListenCommand.serialize(varHandle.get(object), seen, depth + 1));
                        }
                        catch (ReflectiveOperationException ex) {
                            return class_2561.method_43470((String)(mojmapFieldName + "=")).method_10852((class_2561)class_2561.method_43471((String)"commands.clisten.packetError").method_27692(class_124.field_1079));
                        }
                    }
                }).reduce((l, r) -> l.method_27693(", ").method_10852((class_2561)r)).orElse(class_2561.method_43473()));
                yield component.method_27693("}");
            }
        };
    }

    public static void onPacket(class_2596<?> packet, PacketFlow side) {
        if (!packets.contains(packet.method_55846().comp_2231())) {
            return;
        }
        callback.apply(packet, side);
    }

    @FunctionalInterface
    private static interface PacketCallback {
        public void apply(class_2596<?> var1, PacketFlow var2);
    }

    public static enum PacketFlow {
        SERVERBOUND,
        CLIENTBOUND,
        C2C_OUTBOUND,
        C2C_INBOUND;

    }
}

