/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.c2c;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.logging.LogUtils;
import io.netty.buffer.Unpooled;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Optional;
import net.earthcomputer.clientcommands.c2c.C2CPacket;
import net.earthcomputer.clientcommands.c2c.C2CPacketListener;
import net.earthcomputer.clientcommands.c2c.ConversionHelper;
import net.earthcomputer.clientcommands.c2c.OutgoingPacketFilter;
import net.earthcomputer.clientcommands.c2c.packets.MessageC2CPacket;
import net.earthcomputer.clientcommands.c2c.packets.PutTicTacToeMarkC2CPacket;
import net.earthcomputer.clientcommands.c2c.packets.StartTicTacToeGameC2CPacket;
import net.earthcomputer.clientcommands.command.ListenCommand;
import net.earthcomputer.clientcommands.command.TicTacToeCommand;
import net.earthcomputer.clientcommands.interfaces.IClientPacketListener_C2C;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_124;
import net.minecraft.class_2539;
import net.minecraft.class_2540;
import net.minecraft.class_2547;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_634;
import net.minecraft.class_640;
import net.minecraft.class_7427;
import net.minecraft.class_7428;
import net.minecraft.class_7434;
import net.minecraft.class_7822;
import net.minecraft.class_7853;
import net.minecraft.class_9127;
import net.minecraft.class_9129;
import net.minecraft.class_9147;
import net.minecraft.class_9812;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class C2CPacketHandler
implements C2CPacketListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final DynamicCommandExceptionType MESSAGE_TOO_LONG_EXCEPTION = new DynamicCommandExceptionType(d -> class_2561.method_43469((String)"c2cpacket.messageTooLong", (Object[])new Object[]{d}));
    private static final SimpleCommandExceptionType PUBLIC_KEY_NOT_FOUND_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"c2cpacket.publicKeyNotFound"));
    private static final SimpleCommandExceptionType ENCRYPTION_FAILED_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"c2cpacket.encryptionFailed"));
    public static final class_9127.class_9128<C2CPacketListener, class_9129> PROTOCOL_UNBOUND = class_9147.method_56455((class_2539)class_2539.field_20591, builder -> builder.method_56454(MessageC2CPacket.ID, MessageC2CPacket.CODEC).method_56454(StartTicTacToeGameC2CPacket.ID, StartTicTacToeGameC2CPacket.CODEC).method_56454(PutTicTacToeMarkC2CPacket.ID, PutTicTacToeMarkC2CPacket.CODEC));
    public static final String C2C_PACKET_HEADER = "CC\u0395NC:";
    private static final C2CPacketHandler instance = new C2CPacketHandler();

    private C2CPacketHandler() {
    }

    public static C2CPacketHandler getInstance() {
        return instance;
    }

    public void sendPacket(class_2596<C2CPacketListener> packet, class_640 recipient) throws CommandSyntaxException {
        class_7822 session = recipient.method_45741();
        if (session == null) {
            throw PUBLIC_KEY_NOT_FOUND_EXCEPTION.create();
        }
        class_7428 ppk = session.comp_1086();
        if (ppk == null) {
            throw PUBLIC_KEY_NOT_FOUND_EXCEPTION.create();
        }
        PublicKey key = ppk.comp_767().comp_770();
        class_2540 buf = PacketByteBufs.create();
        class_9127<C2CPacketListener> protocolInfo = C2CPacketHandler.getCurrentProtocolInfo();
        if (protocolInfo == null) {
            return;
        }
        protocolInfo.comp_2236().encode((Object)buf, packet);
        byte[] uncompressed = new byte[buf.readableBytes()];
        buf.method_52952(0, uncompressed);
        byte[] compressed = ConversionHelper.Gzip.compress(uncompressed);
        if (compressed == null) {
            return;
        }
        int chunks = (compressed.length + 244) / 245;
        byte[][] chunked = new byte[chunks][];
        for (int i = 0; i < chunks; ++i) {
            int start = i * 245;
            int end = Math.min(start + 245, compressed.length);
            chunked[i] = new byte[end - start];
            System.arraycopy(compressed, start, chunked[i], 0, end - start);
        }
        byte[][] encrypted = new byte[chunks][];
        for (int i = 0; i < chunks; ++i) {
            encrypted[i] = ConversionHelper.RsaEcb.encrypt(chunked[i], key);
            if (encrypted[i] != null && encrypted[i].length != 0) continue;
            throw ENCRYPTION_FAILED_EXCEPTION.create();
        }
        byte[] joined = new byte[encrypted.length * 256];
        for (int i = 0; i < encrypted.length; ++i) {
            System.arraycopy(encrypted[i], 0, joined, i * 256, 256);
        }
        String packetString = ConversionHelper.BaseUTF8.toUnicode(joined);
        String commandString = "w " + recipient.method_2966().getName() + " CC\u0395NC:" + packetString;
        if (commandString.length() >= 256) {
            throw MESSAGE_TOO_LONG_EXCEPTION.create((Object)commandString.length());
        }
        ListenCommand.onPacket(packet, ListenCommand.PacketFlow.C2C_OUTBOUND);
        class_310.method_1551().method_1562().method_45730(commandString);
        OutgoingPacketFilter.addPacket(packetString);
    }

    public static boolean handleC2CPacket(String content, String sender) {
        C2CPacket packet;
        byte[] encrypted = ConversionHelper.BaseUTF8.fromUnicode(content);
        int length = encrypted.length & 0xFFFFFF00;
        byte[][] encryptedArrays = new byte[length / 256][];
        for (int i = 0; i < length; i += 256) {
            encryptedArrays[i / 256] = Arrays.copyOfRange(encrypted, i, i + 256);
        }
        class_7853 class_78532 = class_310.method_1551().method_43590();
        if (!(class_78532 instanceof class_7434)) {
            return false;
        }
        class_7434 profileKeyPairManager = (class_7434)class_78532;
        Optional keyPair = (Optional)profileKeyPairManager.field_39959.join();
        if (keyPair.isEmpty()) {
            return false;
        }
        int len = 0;
        byte[][] decryptedArrays = new byte[encryptedArrays.length][];
        for (int i = 0; i < encryptedArrays.length; ++i) {
            decryptedArrays[i] = ConversionHelper.RsaEcb.decrypt(encryptedArrays[i], ((class_7427)keyPair.get()).comp_741());
            if (decryptedArrays[i] == null) {
                return false;
            }
            len += decryptedArrays[i].length;
        }
        byte[] decrypted = new byte[len];
        int pos = 0;
        for (byte[] decryptedArray : decryptedArrays) {
            System.arraycopy(decryptedArray, 0, decrypted, pos, decryptedArray.length);
            pos += decryptedArray.length;
        }
        byte[] uncompressed = ConversionHelper.Gzip.decompress(decrypted);
        if (uncompressed == null) {
            return false;
        }
        class_9127<C2CPacketListener> protocolInfo = C2CPacketHandler.getCurrentProtocolInfo();
        if (protocolInfo == null) {
            return false;
        }
        class_2540 buf = new class_2540(Unpooled.wrappedBuffer((byte[])uncompressed));
        try {
            packet = (C2CPacket)protocolInfo.comp_2236().decode((Object)buf);
        }
        catch (Throwable e) {
            LOGGER.error("Error decoding C2C packet", e);
            return false;
        }
        if (buf.readableBytes() > 0) {
            LOGGER.error("Found extra bytes while reading C2C packet {}", (Object)packet.method_55846());
            return false;
        }
        if (!packet.sender().equals(sender)) {
            LOGGER.error("Detected mismatching packet sender. Expected {}, got {}", (Object)sender, (Object)packet.sender());
            return false;
        }
        ListenCommand.onPacket(packet, ListenCommand.PacketFlow.C2C_INBOUND);
        try {
            packet.method_11054((class_2547)C2CPacketHandler.getInstance());
        }
        catch (Throwable e) {
            class_310.method_1551().field_1705.method_1743().method_1812(class_2561.method_30163((String)e.getMessage()));
            LOGGER.error("Error handling C2C packet", e);
        }
        return true;
    }

    @Override
    public void onMessageC2CPacket(MessageC2CPacket packet) {
        String sender = packet.sender();
        String message = packet.message();
        class_5250 prefix = class_2561.method_43473();
        prefix.method_10852((class_2561)class_2561.method_43470((String)"[").method_27692(class_124.field_1063));
        prefix.method_10852((class_2561)class_2561.method_43470((String)"/cwe").method_27692(class_124.field_1075));
        prefix.method_10852((class_2561)class_2561.method_43470((String)"]").method_27692(class_124.field_1063));
        prefix.method_10852((class_2561)class_2561.method_43470((String)" "));
        class_5250 component = prefix.method_10852((class_2561)class_2561.method_43469((String)"c2cpacket.messageC2CPacket.incoming", (Object[])new Object[]{sender, message}).method_27692(class_124.field_1080));
        class_310.method_1551().field_1705.method_1743().method_1812((class_2561)component);
    }

    @Override
    public void onStartTicTacToeGameC2CPacket(StartTicTacToeGameC2CPacket packet) {
        TicTacToeCommand.onStartTicTacToeGameC2CPacket(packet);
    }

    @Override
    public void onPutTicTacToeMarkC2CPacket(PutTicTacToeMarkC2CPacket packet) {
        TicTacToeCommand.onPutTicTacToeMarkC2CPacket(packet);
    }

    @Nullable
    public static class_9127<C2CPacketListener> getCurrentProtocolInfo() {
        class_634 connection = class_310.method_1551().method_1562();
        if (connection == null) {
            return null;
        }
        return ((IClientPacketListener_C2C)connection).clientcommands_getC2CProtocolInfo();
    }

    @NotNull
    public class_2539 method_52280() {
        return class_2539.field_20591;
    }

    public void method_10839(class_9812 details) {
    }

    public boolean method_48106() {
        return true;
    }
}

