/*
 * Decompiled with CFR 0.152.
 */
package com.seedfinding.mcfeature.structure.generator.piece.stronghold;

import com.seedfinding.mccore.util.block.BlockBox;
import com.seedfinding.mccore.util.block.BlockDirection;
import com.seedfinding.mccore.util.pos.BPos;
import com.seedfinding.mcfeature.structure.Stronghold;
import com.seedfinding.mcfeature.structure.generator.piece.stronghold.FiveWayCrossing;
import com.seedfinding.mcfeature.structure.generator.piece.stronghold.Start;
import com.seedfinding.mcfeature.structure.generator.structure.StrongholdGenerator;
import com.seedfinding.mcseed.rand.JRand;
import java.util.List;

public class SpiralStaircase
extends Stronghold.Piece {
    private final boolean isStructureStart;

    public SpiralStaircase(int pieceType, JRand rand, int x, int z) {
        super(pieceType);
        this.isStructureStart = true;
        this.setOrientation(BlockDirection.randomHorizontal(rand));
        this.boundingBox = new BlockBox(x, 64, z, x + 5 - 1, 74, z + 5 - 1);
    }

    public SpiralStaircase(int pieceId, JRand rand, BlockBox boundingBox, BlockDirection facing) {
        super(pieceId);
        this.isStructureStart = false;
        this.setOrientation(facing);
        rand.nextInt(5);
        this.boundingBox = boundingBox;
    }

    public static SpiralStaircase createPiece(List<Stronghold.Piece> pieces, JRand rand, int x, int y, int z, BlockDirection facing, int pieceId) {
        BlockBox box = BlockBox.rotated(x, y, z, -1, -7, 0, 5, 11, 5, facing.getRotation());
        return Stronghold.Piece.isHighEnough(box) && Stronghold.Piece.getNextIntersectingPiece(pieces, box) == null ? new SpiralStaircase(pieceId, rand, box, facing) : null;
    }

    @Override
    public void populatePieces(StrongholdGenerator gen, Start start, List<Stronghold.Piece> pieces, JRand rand) {
        if (this.isStructureStart) {
            gen.currentPiece = FiveWayCrossing.class;
        }
        this.generateSmallDoorChildrenForward(gen, start, pieces, rand, 1, 1);
    }

    @Override
    public boolean process(JRand rand, BPos pos) {
        this.skipWithRandomized(rand, 0, 0, 0, 4, 10, 4, true);
        return true;
    }
}

