/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.nvidium;

import me.cortex.nvidium.config.NvidiumConfig;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_156;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Nvidium {
    public static final String MOD_VERSION;
    public static final Logger LOGGER;
    public static boolean IS_COMPATIBLE;
    public static boolean IS_ENABLED;
    public static boolean IS_DEBUG;
    public static boolean SUPPORTS_PERSISTENT_SPARSE_ADDRESSABLE_BUFFER;
    public static boolean FORCE_DISABLE;
    public static NvidiumConfig config;

    public static void checkSystemIsCapable() {
        GLCapabilities cap = GL.getCapabilities();
        boolean supported = cap.GL_NV_mesh_shader && cap.GL_NV_uniform_buffer_unified_memory && cap.GL_NV_vertex_buffer_unified_memory && cap.GL_NV_representative_fragment_test && cap.GL_ARB_sparse_buffer && cap.GL_NV_bindless_multi_draw_indirect;
        IS_COMPATIBLE = supported;
        if (IS_COMPATIBLE) {
            LOGGER.info("All capabilities met");
        } else {
            LOGGER.warn("Not all requirements met, disabling nvidium");
        }
        if (IS_COMPATIBLE && class_156.method_668() == class_156.class_158.field_1135) {
            LOGGER.warn("Linux currently uses fallback terrain buffer due to driver inconsistencies, expect increase vram usage");
            SUPPORTS_PERSISTENT_SPARSE_ADDRESSABLE_BUFFER = false;
        }
        if (IS_COMPATIBLE) {
            LOGGER.info("Enabling Nvidium");
        }
        IS_ENABLED = IS_COMPATIBLE;
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)"Nvidium");
        IS_COMPATIBLE = false;
        IS_ENABLED = false;
        IS_DEBUG = System.getProperty("nvidium.isDebug", "false").equals("TRUE");
        SUPPORTS_PERSISTENT_SPARSE_ADDRESSABLE_BUFFER = true;
        FORCE_DISABLE = false;
        config = NvidiumConfig.loadOrCreate();
        ModContainer mod = (ModContainer)FabricLoader.getInstance().getModContainer("nvidium").orElseThrow(NullPointerException::new);
        String version = mod.getMetadata().getVersion().getFriendlyString();
        String commit = mod.getMetadata().getCustomValue("commit").getAsString();
        MOD_VERSION = version + "-" + commit;
    }
}

