/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.task;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import net.earthcomputer.clientcommands.EventManager;
import net.earthcomputer.clientcommands.task.GuiBlocker;
import net.earthcomputer.clientcommands.task.LongTask;
import net.minecraft.command.CommandException;

public class TaskManager {
    private static List<GuiBlocker> guiBlockers = new ArrayList<GuiBlocker>();
    private static Queue<LongTask> longTaskQueue = new ArrayDeque<LongTask>();
    private static LongTask currentLongTask;

    private TaskManager() {
    }

    public static void addGuiBlocker(GuiBlocker blocker) {
        guiBlockers.add(blocker);
    }

    public static void ensureNoTasks() throws CommandException {
        if (currentLongTask != null || !longTaskQueue.isEmpty()) {
            throw new CommandException("clientcommands.task.alreadyRunning", new Object[0]);
        }
    }

    public static boolean abortTasks() {
        boolean result = !longTaskQueue.isEmpty() || currentLongTask != null;
        longTaskQueue.clear();
        if (currentLongTask != null) {
            currentLongTask.cleanup();
            currentLongTask = null;
        }
        return result;
    }

    public static void addLongTask(LongTask task) {
        longTaskQueue.add(task);
    }

    static {
        EventManager.addDisconnectListener(e -> {
            TaskManager.abortTasks();
            guiBlockers.clear();
        });
        EventManager.addGuiOpenListener(e -> {
            Iterator<GuiBlocker> guiBlockerItr = guiBlockers.iterator();
            while (guiBlockerItr.hasNext()) {
                GuiBlocker guiBlocker = guiBlockerItr.next();
                if (guiBlocker.isFinished()) {
                    guiBlockerItr.remove();
                    continue;
                }
                if (!guiBlocker.processGui(e.getGui())) {
                    e.setCanceled(true);
                }
                if (!guiBlocker.isFinished()) continue;
                guiBlockerItr.remove();
            }
        });
        EventManager.addTickListener(e -> {
            while (true) {
                if (currentLongTask == null) {
                    if (longTaskQueue.isEmpty()) break;
                    currentLongTask = longTaskQueue.remove();
                    currentLongTask.start();
                }
                if (currentLongTask.isFinished()) {
                    currentLongTask.cleanup();
                    currentLongTask = null;
                    continue;
                }
                currentLongTask.tick();
                if (currentLongTask == null || !currentLongTask.isFinished()) break;
                currentLongTask.cleanup();
                currentLongTask = null;
            }
        });
    }
}

