/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.render;

import com.google.common.collect.Sets;
import java.util.Set;
import net.earthcomputer.clientcommands.EventManager;
import net.minecraft.entity.Entity;

public class RenderSettings {
    private static Set<Class<? extends Entity>> entitiesDisabled = Sets.newIdentityHashSet();

    public static void registerEvents() {
        EventManager.addDisconnectExceptRelogListener(e -> entitiesDisabled.clear());
    }

    public static boolean isEntityRenderingDisabled(Class<? extends Entity> clazz) {
        return entitiesDisabled.contains(clazz);
    }

    public static void enableEntityRendering(Class<? extends Entity> clazz) {
        entitiesDisabled.remove(clazz);
    }

    public static void disableEntityRendering(Class<? extends Entity> clazz) {
        entitiesDisabled.add(clazz);
    }
}

