/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.debug;

import java.util.Arrays;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TraceRandom
extends Random {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger((String)"clientcommands");
    private int nextCalls = 0;
    private String name;

    public TraceRandom(String name) {
        super(0L);
        this.name = name;
    }

    private int nextCalls() {
        int calls = this.nextCalls;
        this.nextCalls = 0;
        return calls;
    }

    private void logNextCalls(String methodName, Object returned) {
        LOGGER.info("{}.{}: {} next calls, {} returned", (Object)this.name, (Object)methodName, (Object)this.nextCalls(), returned);
    }

    @Override
    protected int next(int bits) {
        ++this.nextCalls;
        return super.next(bits);
    }

    @Override
    public boolean nextBoolean() {
        boolean b = super.nextBoolean();
        this.logNextCalls("nextBoolean()", b);
        return b;
    }

    @Override
    public void nextBytes(byte[] arr) {
        super.nextBytes(arr);
        this.logNextCalls("nextBytes(byte[" + arr.length + "])", Arrays.toString(arr));
    }

    @Override
    public double nextDouble() {
        double d = super.nextDouble();
        this.logNextCalls("nextDouble()", d);
        return d;
    }

    @Override
    public float nextFloat() {
        float f = super.nextFloat();
        this.logNextCalls("nextFloat()", Float.valueOf(f));
        return f;
    }

    @Override
    public synchronized double nextGaussian() {
        double d = super.nextGaussian();
        this.logNextCalls("nextGaussian()", d);
        return d;
    }

    @Override
    public int nextInt() {
        int i = super.nextInt();
        this.logNextCalls("nextInt()", i);
        return i;
    }

    @Override
    public int nextInt(int bound) {
        int i = super.nextInt(bound);
        this.logNextCalls("nextInt(" + bound + ")", i);
        return i;
    }

    @Override
    public long nextLong() {
        long l = super.nextLong();
        this.logNextCalls("nextLong()", l);
        return l;
    }

    @Override
    public synchronized void setSeed(long seed) {
        super.setSeed(seed);
        LOGGER.info("{}: Set the seed to {}", (Object)this.name, (Object)seed);
    }
}

