/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.cvw;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.io.File;
import java.net.SocketAddress;
import java.util.UUID;
import net.earthcomputer.clientcommands.cvw.ClientVirtualServer;
import net.earthcomputer.clientcommands.cvw.ServerConnector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenWorking;
import net.minecraft.client.network.NetHandlerLoginClient;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.EnumConnectionState;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.handshake.client.C00Handshake;
import net.minecraft.network.login.client.CPacketLoginStart;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.world.GameType;
import net.minecraftforge.fml.common.StartupQuery;

public class ServerConnectorCVW
extends ServerConnector {
    private int dimensionId;
    private GameType gameType;
    private ServerConnector previousServer;
    private Long2ObjectMap<NBTTagCompound> chunks;
    private NBTTagCompound playerTag;

    public ServerConnectorCVW(int dimensionId, GameType gameType, ServerConnector previousServer, Long2ObjectMap<NBTTagCompound> chunks, NBTTagCompound playerTag) {
        this.dimensionId = dimensionId;
        this.gameType = gameType;
        this.previousServer = previousServer;
        this.chunks = chunks;
        this.playerTag = playerTag;
    }

    @Override
    public void connect() {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_71403_a(null);
        System.gc();
        YggdrasilAuthenticationService authService = new YggdrasilAuthenticationService(mc.func_110437_J(), UUID.randomUUID().toString());
        MinecraftSessionService sessionService = authService.createMinecraftSessionService();
        GameProfileRepository profileRepo = authService.createProfileRepository();
        PlayerProfileCache profileCache = new PlayerProfileCache(profileRepo, new File(mc.field_71412_D, MinecraftServer.field_152367_a.getName()));
        TileEntitySkull.func_184293_a((PlayerProfileCache)profileCache);
        TileEntitySkull.func_184294_a((MinecraftSessionService)sessionService);
        PlayerProfileCache.func_187320_a((boolean)false);
        mc.field_71437_Z = new ClientVirtualServer(mc, this.dimensionId, this.gameType, this.previousServer, this.chunks, this.playerTag, authService, sessionService, profileRepo, profileCache);
        mc.func_71401_C().func_71256_s();
        mc.field_71455_al = true;
        mc.field_71461_s.func_73720_a(I18n.func_135052_a((String)"menu.loadingLevel", (Object[])new Object[0]));
        while (!mc.func_71401_C().func_71200_ad()) {
            if (!StartupQuery.check()) {
                mc.func_71403_a(null);
                mc.func_147108_a(null);
                return;
            }
            String message = mc.func_71401_C().func_71195_b_();
            if (message != null) {
                mc.field_71461_s.func_73719_c(I18n.func_135052_a((String)message, (Object[])new Object[0]));
            } else {
                mc.field_71461_s.func_73719_c("");
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        mc.func_147108_a((GuiScreen)new GuiScreenWorking());
        SocketAddress socketAddress = mc.func_71401_C().func_147137_ag().func_151270_a();
        NetworkManager netManager = NetworkManager.func_150722_a((SocketAddress)socketAddress);
        netManager.func_150719_a((INetHandler)new NetHandlerLoginClient(netManager, mc, null));
        netManager.func_179290_a((Packet)new C00Handshake(socketAddress.toString(), 0, EnumConnectionState.LOGIN, true));
        GameProfile gameProfile = mc.func_110432_I().func_148256_e();
        if (!mc.func_110432_I().hasCachedProperties()) {
            gameProfile = mc.func_152347_ac().fillProfileProperties(gameProfile, true);
            mc.func_110432_I().setProperties(gameProfile.getProperties());
        }
        netManager.func_179290_a((Packet)new CPacketLoginStart(gameProfile));
        mc.field_71453_ak = netManager;
    }

    @Override
    public void disconnect() {
        ServerConnectorCVW.genericDisconnect();
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiMainMenu());
    }

    @Override
    public void onDisconnectButtonPressed() {
        this.disconnect();
        this.previousServer.connect();
    }

    @Override
    public String getDisconnectButtonText() {
        return "cvw.toPreviousServer";
    }
}

