/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.cvw;

import net.earthcomputer.clientcommands.EventManager;
import net.earthcomputer.clientcommands.cvw.ClientVirtualServer;
import net.earthcomputer.clientcommands.cvw.ServerConnectorCVW;
import net.earthcomputer.clientcommands.cvw.ServerConnectorLocal;
import net.earthcomputer.clientcommands.cvw.ServerConnectorRealms;
import net.earthcomputer.clientcommands.cvw.ServerConnectorRemote;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.gui.GuiScreenRealmsProxy;
import net.minecraft.client.resources.I18n;
import net.minecraft.server.integrated.IntegratedServer;

public abstract class ServerConnector {
    public static void registerEvents() {
        EventManager.addInitGuiListener(e -> {
            if (e.getGui() instanceof GuiIngameMenu) {
                ServerConnector connector = ServerConnector.forCurrentServer();
                ((GuiButton)e.getButtonList().get((int)0)).field_146126_j = I18n.func_135052_a((String)connector.getDisconnectButtonText(), (Object[])new Object[0]);
                ((GuiButton)e.getButtonList().get((int)4)).field_146124_l = connector.canOpenToLan();
            }
        });
        EventManager.addGuiActionPerformedListener(e -> {
            if (e.getGui() instanceof GuiIngameMenu) {
                if (e.getButton().field_146127_k == 1) {
                    e.getButton().func_146113_a(Minecraft.func_71410_x().func_147118_V());
                    e.getButton().field_146124_l = false;
                    ServerConnector.forCurrentServer().onDisconnectButtonPressed();
                    e.setCanceled(true);
                }
            } else if (e.getGui() instanceof GuiScreenRealmsProxy) {
                ServerConnectorRealms.setLastRealmsServer((GuiScreenRealmsProxy)e.getGui(), e.getButton().field_146127_k);
            }
        });
    }

    public abstract void connect();

    public abstract void disconnect();

    protected static void genericDisconnect() {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71441_e.func_72882_A();
        mc.func_71403_a(null);
    }

    public void onDisconnectButtonPressed() {
        this.disconnect();
    }

    public String getDisconnectButtonText() {
        return "menu.disconnect";
    }

    public boolean canOpenToLan() {
        return false;
    }

    public static ServerConnector forCurrentServer() {
        if (Minecraft.func_71410_x().func_71387_A()) {
            IntegratedServer server = Minecraft.func_71410_x().func_71401_C();
            if (server instanceof ClientVirtualServer) {
                ClientVirtualServer cvs = (ClientVirtualServer)server;
                return new ServerConnectorCVW(cvs.getDimensionId(), cvs.func_71265_f(), cvs.getPreviousServer(), cvs.getChunks(), cvs.getPlayerTag());
            }
            return new ServerConnectorLocal(server.func_71270_I(), server.func_71221_J());
        }
        if (Minecraft.func_71410_x().func_181540_al()) {
            return ServerConnectorRealms.forCurrentServer();
        }
        return new ServerConnectorRemote(Minecraft.func_71410_x().func_147104_D());
    }
}

