/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.cvw;

import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import it.unimi.dsi.fastutil.longs.Long2ObjectArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import net.earthcomputer.clientcommands.cvw.ClientVirtualSaveHandler;
import net.earthcomputer.clientcommands.cvw.ClientVirtualWorld;
import net.earthcomputer.clientcommands.cvw.ClientVirtualWorldMulti;
import net.earthcomputer.clientcommands.cvw.ServerConnector;
import net.minecraft.client.Minecraft;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.world.GameType;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.ServerWorldEventHandler;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.storage.AnvilSaveConverter;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ClientVirtualServer
extends IntegratedServer {
    private int dimensionId;
    private GameType gameType;
    private ServerConnector previousServer;
    private Long2ObjectMap<NBTTagCompound> chunks;
    private NBTTagCompound playerTag;
    private ISaveFormat activeAnvilConverter;

    public ClientVirtualServer(Minecraft mc, int dimensionId, GameType gameType, ServerConnector previousServer, Long2ObjectMap<NBTTagCompound> chunks, NBTTagCompound playerTag, YggdrasilAuthenticationService authService, MinecraftSessionService sessionService, GameProfileRepository profileRepo, PlayerProfileCache profileCache) {
        super(mc, "CVW", "CVW", new WorldSettings(0L, gameType, false, false, WorldType.field_77138_c).func_77166_b(), authService, sessionService, profileRepo, profileCache);
        this.previousServer = previousServer;
        this.dimensionId = dimensionId;
        this.gameType = gameType;
        this.chunks = chunks;
        this.playerTag = playerTag;
        this.activeAnvilConverter = new AnvilSaveConverter(ClientVirtualSaveHandler.DUMMY_DIR, Minecraft.func_71410_x().func_184126_aj());
    }

    public int getDimensionId() {
        return this.dimensionId;
    }

    public ServerConnector getPreviousServer() {
        return this.previousServer;
    }

    public Long2ObjectMap<NBTTagCompound> getChunks() {
        return this.chunks;
    }

    public NBTTagCompound getPlayerTag() {
        return this.playerTag;
    }

    public void func_71247_a(String saveName, String worldNameIn, long seed, WorldType type, String generatorOptions) {
        ClientVirtualWorld overworld = new ClientVirtualWorld(this, 0, this.field_71350_m, (Long2ObjectMap<NBTTagCompound>)(this.dimensionId == 0 ? this.chunks : new Long2ObjectArrayMap(0)), this.playerTag);
        overworld.func_175643_b();
        overworld.func_72963_a(this.field_71350_m);
        Integer[] integerArray = DimensionManager.getStaticDimensionIDs();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            ClientVirtualWorld world;
            int dim = integerArray[i];
            if (dim == 0) {
                world = overworld;
            } else {
                world = new ClientVirtualWorldMulti(this, dim, this.field_71350_m, (Long2ObjectMap<NBTTagCompound>)(this.dimensionId == dim ? this.chunks : new Long2ObjectArrayMap(0)), this.playerTag, overworld);
                world.func_175643_b();
            }
            world.func_72954_a((IWorldEventListener)new ServerWorldEventHandler((MinecraftServer)this, (WorldServer)world));
            MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Load((World)world));
        }
        this.func_184103_al().func_72364_a(new WorldServer[]{overworld});
        this.func_147139_a(Minecraft.func_71410_x().field_71474_y.field_74318_M);
        this.func_71222_d();
    }

    public void func_71267_a(boolean isSilent) {
    }

    public void func_71237_c(String worldName) {
    }

    public CrashReport func_71230_b(CrashReport report) {
        report = super.func_71230_b(report);
        CrashReportCategory category = report.func_85058_a("CVW");
        category.func_189529_a("Dimension ID", () -> String.valueOf(this.dimensionId));
        category.func_189529_a("Gamemode", () -> this.gameType.func_77149_b());
        return report;
    }

    public String func_71206_a(GameType type, boolean allowCheats) {
        return null;
    }

    public ISaveFormat func_71254_M() {
        return this.activeAnvilConverter;
    }
}

