/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.cvw;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.IOException;
import java.lang.reflect.Method;
import net.minecraft.client.multiplayer.ChunkProviderClient;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ClientVirtualChunkLoader
implements IChunkLoader {
    private static final AnvilChunkLoader ANVIL_CHUNK_LOADER = new AnvilChunkLoader(null, null);
    private static final Method READ_FROM_NBT_METHOD = ReflectionHelper.findMethod(AnvilChunkLoader.class, (String)"checkedReadChunkFromNBT__Async", (String)"checkedReadChunkFromNBT__Async", (Class[])new Class[]{World.class, Integer.TYPE, Integer.TYPE, NBTTagCompound.class});
    private Long2ObjectMap<NBTTagCompound> chunks;

    public ClientVirtualChunkLoader(Long2ObjectMap<NBTTagCompound> chunks) {
        this.chunks = chunks;
    }

    public static Long2ObjectMap<NBTTagCompound> generateChunkMap(WorldClient world, ChunkProviderClient chunkProvider) {
        Long2ObjectOpenHashMap chunkMap = new Long2ObjectOpenHashMap();
        chunkProvider.field_73236_b.forEach((arg_0, arg_1) -> ClientVirtualChunkLoader.lambda$generateChunkMap$0(world, (Long2ObjectMap)chunkMap, arg_0, arg_1));
        return chunkMap;
    }

    public Chunk func_75815_a(World world, int x, int z) throws IOException {
        Object[] ret;
        NBTTagCompound nbt = (NBTTagCompound)this.chunks.get(ChunkPos.func_77272_a((int)x, (int)z));
        if (nbt == null) {
            return null;
        }
        try {
            ret = (Object[])READ_FROM_NBT_METHOD.invoke((Object)ANVIL_CHUNK_LOADER, world, x, z, nbt);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (ret != null) {
            Chunk chunk = (Chunk)ret[0];
            nbt = (NBTTagCompound)ret[1];
            ANVIL_CHUNK_LOADER.loadEntities(world, nbt.func_74775_l("Level"), chunk);
            return chunk;
        }
        return null;
    }

    public void func_75816_a(World worldIn, Chunk chunkIn) throws MinecraftException, IOException {
    }

    public void func_75819_b(World worldIn, Chunk chunkIn) throws IOException {
    }

    public void func_75817_a() {
    }

    public void func_75818_b() {
    }

    public boolean func_191063_a(int x, int z) {
        return this.chunks.containsKey(ChunkPos.func_77272_a((int)x, (int)z));
    }

    private static /* synthetic */ void lambda$generateChunkMap$0(WorldClient world, Long2ObjectMap chunkMap, Long pos, Chunk chunk) {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagCompound levelTag = new NBTTagCompound();
        nbt.func_74782_a("Level", (NBTBase)levelTag);
        nbt.func_74768_a("DataVersion", 1343);
        FMLCommonHandler.instance().getDataFixer().writeVersionData(nbt);
        ANVIL_CHUNK_LOADER.func_75820_a(chunk, (World)world, levelTag);
        ForgeChunkManager.storeChunkNBT((Chunk)chunk, (NBTTagCompound)levelTag);
        MinecraftForge.EVENT_BUS.post((Event)new ChunkDataEvent.Save(chunk, nbt));
        chunkMap.put((Object)pos, (Object)nbt);
    }
}

