/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.core;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ProxyTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        Class proxyTypeClass;
        if (basicClass == null) {
            return null;
        }
        String internalName = transformedName.replace('.', '/');
        ClassReader reader = new ClassReader(basicClass);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        FieldNode proxyField = null;
        if (node.fields != null) {
            block9: for (FieldNode field : node.fields) {
                if (field.visibleAnnotations == null) continue;
                for (AnnotationNode ann : field.visibleAnnotations) {
                    if (!"Lnet/earthcomputer/clientcommands/util/Proxy;".equals(ann.desc)) continue;
                    if (proxyField != null) {
                        throw new AssertionError((Object)"There should not be more than one proxy field");
                    }
                    proxyField = field;
                    continue block9;
                }
            }
        }
        if (proxyField == null) {
            return basicClass;
        }
        Type proxyType = Type.getType((String)proxyField.desc);
        if (proxyType.getSort() != 10) {
            throw new AssertionError((Object)"The proxy type should be an object");
        }
        try {
            proxyTypeClass = Launch.classLoader.loadClass(proxyType.getInternalName().replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)"Proxy class doesn't exist");
        }
        for (Method method : proxyTypeClass.getMethods()) {
            int opcode;
            String methodDesc;
            String methodName;
            if (Modifier.isStatic(method.getModifiers()) || Modifier.isFinal(method.getModifiers()) || !Modifier.isPublic(method.getModifiers()) && !Modifier.isProtected(method.getModifiers()) || this.isPresent(node, methodName = method.getName(), methodDesc = Type.getMethodDescriptor((Method)method))) continue;
            MethodNode delegateMethod = new MethodNode(method.getModifiers() & 0xFFFFFAFF, methodName, methodDesc, null, (String[])Arrays.stream(method.getExceptionTypes()).map(Type::getInternalName).toArray(String[]::new));
            InsnList insns = new InsnList();
            int varIndex = 0;
            if ((proxyField.access & 8) == 0) {
                insns.add((AbstractInsnNode)new VarInsnNode(25, 0));
                varIndex = 1;
            }
            insns.add((AbstractInsnNode)new FieldInsnNode((proxyField.access & 8) != 0 ? 178 : 180, internalName, proxyField.name, proxyField.desc));
            for (Class<?> paramType : method.getParameterTypes()) {
                int opcode2;
                int slots = 1;
                if (!paramType.isPrimitive()) {
                    opcode2 = 25;
                } else if (paramType == Long.TYPE) {
                    opcode2 = 22;
                    slots = 2;
                } else if (paramType == Float.TYPE) {
                    opcode2 = 23;
                } else if (paramType == Double.TYPE) {
                    opcode2 = 24;
                    slots = 2;
                } else {
                    opcode2 = 21;
                }
                insns.add((AbstractInsnNode)new VarInsnNode(opcode2, varIndex));
                varIndex += slots;
            }
            boolean itf = proxyTypeClass.isInterface();
            insns.add((AbstractInsnNode)new MethodInsnNode(itf ? 185 : 182, proxyType.getInternalName(), methodName, methodDesc, itf));
            Type returnType = Type.getReturnType((String)methodDesc);
            switch (returnType.getSort()) {
                case 9: 
                case 10: {
                    opcode = 176;
                    break;
                }
                case 0: {
                    opcode = 177;
                    break;
                }
                case 7: {
                    opcode = 173;
                    break;
                }
                case 6: {
                    opcode = 174;
                    break;
                }
                case 8: {
                    opcode = 175;
                    break;
                }
                default: {
                    opcode = 172;
                }
            }
            insns.add((AbstractInsnNode)new InsnNode(opcode));
            delegateMethod.instructions = insns;
            node.methods.add(delegateMethod);
        }
        ClassWriter writer = new ClassWriter(1);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private boolean isPresent(ClassNode clazz, String methodName, String methodDesc) {
        if (clazz.methods != null) {
            for (MethodNode method : clazz.methods) {
                if (!methodName.equals(method.name) || !methodDesc.equals(method.desc)) continue;
                return true;
            }
        }
        return false;
    }
}

