/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.core;

import net.earthcomputer.clientcommands.core.ClientCommandsLoadingPlugin;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class NetHandlerTransformer
implements IClassTransformer {
    private static final String OBJECT_DESC = "Ljava/lang/Object;";
    private static final String MINECRAFT_NAME = "net/minecraft/client/Minecraft";
    private static final String MINECRAFT_DESC = "Lnet/minecraft/client/Minecraft;";
    private static final String NETWORK_MANAGER_NAME = "net/minecraft/network/NetworkManager";
    private static final String NETWORK_MANAGER_DESC = "Lnet/minecraft/network/NetworkManager;";
    private static final String PACKET_NAME = "net/minecraft/network/Packet";
    private static final String PACKET_MCP_DESC = "Lnet/minecraft/network/Packet;";
    private static final String PACKET_NOTCH_DESC = "Lht;";
    private static final String CHANNEL_NAME = "io/netty/channel/Channel";
    private static final String CHANNEL_DESC = "Lio/netty/channel/Channel;";
    private static final String GENERIC_FUTURE_LISTENER_DESC = "Lio/netty/util/concurrent/GenericFutureListener;";
    private static final String CHANNEL_HANDLER_CONTEXT_DESC = "Lio/netty/channel/ChannelHandlerContext;";
    private static final String GETMINECRAFT_MCP_NAME = "getMinecraft";
    private static final String GETMINECRAFT_SRG_NAME = "func_71410_x";
    private static final String ISCALLINGFROMMINECRAFTTHREAD_MCP_NAME = "isCallingFromMinecraftThread";
    private static final String ISCALLINGFROMMINECRAFTTHREAD_SRG_NAME = "func_152345_ab";
    private static final String CHANNEL_MCP_NAME = "channel";
    private static final String CHANNEL_SRG_NAME = "field_150746_k";
    private static final String SENDPACKET_MCP_NAME = "sendPacket";
    private static final String SENDPACKET_SRG_NAME = "func_179290_a";
    private static final String SENDPACKET_NOTCH_NAME = "a";
    private static final String SENDPACKET_MCP_DESC = "(Lnet/minecraft/network/Packet;)V";
    private static final String SENDPACKET_NOTCH_DESC = "(Lht;)V";
    private static final String SENDPACKET1_MCP_NAME = "sendPacket";
    private static final String SENDPACKET1_SRG_NAME = "func_179288_a";
    private static final String SENDPACKET1_NOTCH_NAME = "a";
    private static final String SENDPACKET1_MCP_DESC = "(Lnet/minecraft/network/Packet;Lio/netty/util/concurrent/GenericFutureListener;[Lio/netty/util/concurrent/GenericFutureListener;)V";
    private static final String SENDPACKET1_NOTCH_DESC = "(Lht;Lio/netty/util/concurrent/GenericFutureListener;[Lio/netty/util/concurrent/GenericFutureListener;)V";
    private static final String CHANNELREAD0_NAME = "channelRead0";
    private static final String CHANNELREAD0_DESC = "(Lio/netty/channel/ChannelHandlerContext;Ljava/lang/Object;)V";
    private static final String EVENT_MANAGER_NAME = "net/earthcomputer/clientcommands/EventManager";
    private static final String EVENT_MANAGER_PRE_METHODS_DESC = "(Lnet/minecraft/network/NetworkManager;Lnet/minecraft/network/Packet;)Lnet/minecraft/network/Packet;";
    private static final String EVENT_MANAGER_POST_METHODS_DESC = "(Lnet/minecraft/network/NetworkManager;Lnet/minecraft/network/Packet;)V";

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        if ("net.minecraft.network.NetworkManager".equals(transformedName)) {
            ClassReader reader = new ClassReader(basicClass);
            ClassNode clazz = new ClassNode();
            reader.accept((ClassVisitor)clazz, 0);
            this.transformNetworkManager(clazz);
            ClassWriter writer = new ClassWriter(0);
            clazz.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        if ("net.minecraft.network.PacketThreadUtil$1".equals(transformedName)) {
            ClassReader reader = new ClassReader(basicClass);
            ClassNode clazz = new ClassNode();
            reader.accept((ClassVisitor)clazz, 0);
            this.transformPacketThreadUtil_1(clazz);
            ClassWriter writer = new ClassWriter(0);
            clazz.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return basicClass;
    }

    private void transformNetworkManager(ClassNode clazz) {
        for (MethodNode method : clazz.methods) {
            if ((method.name.equals("sendPacket") || method.name.equals(SENDPACKET_SRG_NAME) || method.name.equals("a")) && (method.desc.equals(SENDPACKET_MCP_DESC) || method.desc.equals(SENDPACKET_NOTCH_DESC))) {
                this.transformSendPacketMethod(method);
                ClientCommandsLoadingPlugin.EXPECTED_TASKS.remove("tfSendPacket1");
            }
            if ((method.name.equals("sendPacket") || method.name.equals(SENDPACKET1_SRG_NAME) || method.name.equals("a")) && (method.desc.equals(SENDPACKET1_MCP_DESC) || method.desc.equals(SENDPACKET1_NOTCH_DESC))) {
                this.transformSendPacketMethod(method);
                ClientCommandsLoadingPlugin.EXPECTED_TASKS.remove("tfSendPacket2");
            }
            if (!method.name.equals(CHANNELREAD0_NAME) || !method.desc.equals(CHANNELREAD0_DESC)) continue;
            this.transformChannelRead0(method);
            ClientCommandsLoadingPlugin.EXPECTED_TASKS.remove("tfChannelRead0");
        }
    }

    private void transformSendPacketMethod(MethodNode method) {
        InsnList insns = new InsnList();
        insns.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insns.add((AbstractInsnNode)new VarInsnNode(25, 1));
        insns.add((AbstractInsnNode)new MethodInsnNode(184, EVENT_MANAGER_NAME, "firePacketOutboundPre", EVENT_MANAGER_PRE_METHODS_DESC, false));
        insns.add((AbstractInsnNode)new VarInsnNode(58, 1));
        insns.add((AbstractInsnNode)new VarInsnNode(25, 1));
        LabelNode l = new LabelNode();
        insns.add((AbstractInsnNode)new JumpInsnNode(199, l));
        insns.add((AbstractInsnNode)new InsnNode(177));
        insns.add((AbstractInsnNode)l);
        insns.add((AbstractInsnNode)new FrameNode(3, 0, new Object[0], 0, new Object[0]));
        method.instructions.insertBefore(method.instructions.getFirst(), insns);
        AbstractInsnNode returnInsn = method.instructions.getLast();
        while (returnInsn.getOpcode() != 177) {
            returnInsn = returnInsn.getPrevious();
        }
        insns = new InsnList();
        insns.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insns.add((AbstractInsnNode)new VarInsnNode(25, 1));
        insns.add((AbstractInsnNode)new MethodInsnNode(184, EVENT_MANAGER_NAME, "firePacketOutboundPost", EVENT_MANAGER_POST_METHODS_DESC, false));
        method.instructions.insertBefore(returnInsn, insns);
    }

    private void transformChannelRead0(MethodNode method) {
        boolean isDevEnv = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        InsnList insns = new InsnList();
        LabelNode endLabel = new LabelNode();
        this.addChannelOpenAndMinecraftThreadTest(insns, endLabel, isDevEnv);
        insns.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insns.add((AbstractInsnNode)new VarInsnNode(25, 2));
        insns.add((AbstractInsnNode)new TypeInsnNode(192, PACKET_NAME));
        insns.add((AbstractInsnNode)new MethodInsnNode(184, EVENT_MANAGER_NAME, "fireInboundPacketPre", EVENT_MANAGER_PRE_METHODS_DESC, false));
        insns.add((AbstractInsnNode)new VarInsnNode(58, 2));
        insns.add((AbstractInsnNode)new VarInsnNode(25, 2));
        insns.add((AbstractInsnNode)new JumpInsnNode(199, endLabel));
        insns.add((AbstractInsnNode)new InsnNode(177));
        insns.add((AbstractInsnNode)endLabel);
        insns.add((AbstractInsnNode)new FrameNode(3, 0, new Object[0], 0, new Object[0]));
        method.instructions.insertBefore(method.instructions.getFirst(), insns);
        AbstractInsnNode returnInsn = method.instructions.getLast();
        while (returnInsn.getOpcode() != 177) {
            returnInsn = returnInsn.getPrevious();
        }
        insns = new InsnList();
        endLabel = new LabelNode();
        this.addChannelOpenAndMinecraftThreadTest(insns, endLabel, isDevEnv);
        insns.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insns.add((AbstractInsnNode)new VarInsnNode(25, 2));
        insns.add((AbstractInsnNode)new TypeInsnNode(192, PACKET_NAME));
        insns.add((AbstractInsnNode)new MethodInsnNode(184, EVENT_MANAGER_NAME, "fireInboundPacketPost", EVENT_MANAGER_POST_METHODS_DESC, false));
        insns.add((AbstractInsnNode)endLabel);
        insns.add((AbstractInsnNode)new FrameNode(3, 0, new Object[0], 0, new Object[0]));
        method.instructions.insertBefore(returnInsn, insns);
    }

    private void addChannelOpenAndMinecraftThreadTest(InsnList insns, LabelNode endLabel, boolean isDevEnv) {
        insns.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insns.add((AbstractInsnNode)new FieldInsnNode(180, NETWORK_MANAGER_NAME, isDevEnv ? CHANNEL_MCP_NAME : CHANNEL_SRG_NAME, CHANNEL_DESC));
        insns.add((AbstractInsnNode)new MethodInsnNode(185, CHANNEL_NAME, "isOpen", "()Z", true));
        insns.add((AbstractInsnNode)new JumpInsnNode(153, endLabel));
        insns.add((AbstractInsnNode)new MethodInsnNode(184, MINECRAFT_NAME, isDevEnv ? GETMINECRAFT_MCP_NAME : GETMINECRAFT_SRG_NAME, "()Lnet/minecraft/client/Minecraft;", false));
        insns.add((AbstractInsnNode)new MethodInsnNode(182, MINECRAFT_NAME, isDevEnv ? ISCALLINGFROMMINECRAFTTHREAD_MCP_NAME : ISCALLINGFROMMINECRAFTTHREAD_SRG_NAME, "()Z", false));
        insns.add((AbstractInsnNode)new JumpInsnNode(153, endLabel));
    }

    private void transformPacketThreadUtil_1(ClassNode clazz) {
        FieldNode packetField = null;
        for (FieldNode field : clazz.fields) {
            if (!field.desc.equals(PACKET_MCP_DESC) && !field.desc.equals(PACKET_NOTCH_DESC)) continue;
            packetField = field;
            break;
        }
        packetField.access &= 0xFFFFFFEF;
        for (MethodNode method : clazz.methods) {
            if (!method.name.equals("run") || !method.desc.equals("()V")) continue;
            this.transformPacketThreadUtilRun(clazz.name, method, packetField);
            ClientCommandsLoadingPlugin.EXPECTED_TASKS.remove("tfPacketThreadUtilRun");
        }
    }

    private void transformPacketThreadUtilRun(String className, MethodNode method, FieldNode packetField) {
        InsnList insns = new InsnList();
        insns.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insns.add((AbstractInsnNode)new InsnNode(1));
        insns.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insns.add((AbstractInsnNode)new FieldInsnNode(180, className, packetField.name, packetField.desc));
        insns.add((AbstractInsnNode)new MethodInsnNode(184, EVENT_MANAGER_NAME, "firePacketInboundPre", EVENT_MANAGER_PRE_METHODS_DESC, false));
        insns.add((AbstractInsnNode)new FieldInsnNode(181, className, packetField.name, packetField.desc));
        insns.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insns.add((AbstractInsnNode)new FieldInsnNode(180, className, packetField.name, packetField.desc));
        LabelNode l = new LabelNode();
        insns.add((AbstractInsnNode)new JumpInsnNode(199, l));
        insns.add((AbstractInsnNode)new InsnNode(177));
        insns.add((AbstractInsnNode)l);
        insns.add((AbstractInsnNode)new FrameNode(3, 0, new Object[0], 0, new Object[0]));
        method.instructions.insertBefore(method.instructions.getFirst(), insns);
        AbstractInsnNode returnInsn = method.instructions.getLast();
        while (returnInsn.getOpcode() != 177) {
            returnInsn = returnInsn.getPrevious();
        }
        insns = new InsnList();
        insns.add((AbstractInsnNode)new InsnNode(1));
        insns.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insns.add((AbstractInsnNode)new FieldInsnNode(180, className, packetField.name, packetField.desc));
        insns.add((AbstractInsnNode)new MethodInsnNode(184, EVENT_MANAGER_NAME, "firePacketInboundPost", EVENT_MANAGER_POST_METHODS_DESC, false));
        method.instructions.insertBefore(returnInsn, insns);
    }

    static {
        ClientCommandsLoadingPlugin.EXPECTED_TASKS.add("tfSendPacket1");
        ClientCommandsLoadingPlugin.EXPECTED_TASKS.add("tfSendPacket2");
        ClientCommandsLoadingPlugin.EXPECTED_TASKS.add("tfChannelRead0");
        ClientCommandsLoadingPlugin.EXPECTED_TASKS.add("tfPacketThreadUtilRun");
    }
}

