/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import java.text.DecimalFormat;
import java.util.Collections;
import java.util.List;
import net.earthcomputer.clientcommands.EventManager;
import net.earthcomputer.clientcommands.command.ClientCommandBase;
import net.earthcomputer.clientcommands.network.PacketEvent;
import net.earthcomputer.clientcommands.task.LongTask;
import net.earthcomputer.clientcommands.task.TaskManager;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.network.play.server.SPacketTimeUpdate;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class CommandTick
extends ClientCommandBase {
    private static final DecimalFormat DEC_FMT = new DecimalFormat("0.00");

    public String func_71517_b() {
        return "ctick";
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.ctick.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 2) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        switch (args[0]) {
            case "client": {
                this.ctickClient(sender, args);
                break;
            }
            case "server": {
                if (Minecraft.func_71410_x().func_71387_A()) {
                    this.ctickIntegratedServer(sender, args);
                    break;
                }
                this.ctickServer(sender, args);
                break;
            }
            default: {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
        }
    }

    private void ctickClient(ICommandSender sender, String[] args) throws CommandException {
        switch (args[1]) {
            case "tps": 
            case "mspt": {
                TaskManager.ensureNoTasks();
                final TickMeasuringTask measurer = new TickMeasuringTask(sender, "tps".equals(args[1]), false);
                TaskManager.addLongTask(measurer);
                EventManager.addTickListener(new EventManager.Listener<TickEvent.ClientTickEvent>(){

                    @Override
                    public void accept(TickEvent.ClientTickEvent e) {
                        measurer.startTick();
                    }

                    @Override
                    public boolean wasFinalAction() {
                        return measurer.isFinished();
                    }
                });
                EventManager.addEndTickListener(new EventManager.Listener<TickEvent.ClientTickEvent>(){

                    @Override
                    public void accept(TickEvent.ClientTickEvent e) {
                        measurer.endTick();
                    }

                    @Override
                    public boolean wasFinalAction() {
                        return measurer.isFinished();
                    }
                });
                break;
            }
            default: {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
        }
    }

    private void ctickIntegratedServer(ICommandSender sender, String[] args) throws CommandException {
        switch (args[1]) {
            case "tps": 
            case "mspt": {
                TaskManager.ensureNoTasks();
                final TickMeasuringTask measurer = new TickMeasuringTask(sender, "tps".equals(args[1]), false);
                TaskManager.addLongTask(measurer);
                EventManager.addServerTickListener(new EventManager.Listener<TickEvent.ServerTickEvent>(){

                    @Override
                    public void accept(TickEvent.ServerTickEvent e) {
                        measurer.startTick();
                    }

                    @Override
                    public boolean wasFinalAction() {
                        return measurer.isFinished();
                    }
                });
                EventManager.addServerEndTickListener(new EventManager.Listener<TickEvent.ServerTickEvent>(){

                    @Override
                    public void accept(TickEvent.ServerTickEvent e) {
                        measurer.endTick();
                    }

                    @Override
                    public boolean wasFinalAction() {
                        return measurer.isFinished();
                    }
                });
                break;
            }
            default: {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
        }
    }

    private void ctickServer(ICommandSender sender, String[] args) throws CommandException {
        switch (args[1]) {
            case "tps": 
            case "mspt": {
                TaskManager.ensureNoTasks();
                final TickMeasuringTask measurer = new TickMeasuringTask(sender, "tps".equals(args[1]), true);
                TaskManager.addLongTask(measurer);
                EventManager.addInboundPacketPreListener(new EventManager.Listener<PacketEvent.Inbound.Pre>(){
                    long lastTick = -1L;

                    @Override
                    public void accept(PacketEvent.Inbound.Pre e) {
                        if (e.getPacket() instanceof SPacketTimeUpdate) {
                            long tick = ((SPacketTimeUpdate)e.getPacket()).func_149366_c();
                            if (this.lastTick != -1L) {
                                int deltaTick = (int)(tick - this.lastTick);
                                measurer.incrTickCount(deltaTick);
                            }
                            this.lastTick = tick;
                        }
                    }

                    @Override
                    public boolean wasFinalAction() {
                        return measurer.isFinished();
                    }
                });
                break;
            }
            default: {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 0) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            return CommandTick.func_71530_a((String[])args, (String[])new String[]{"client", "server"});
        }
        if (args.length == 2) {
            return CommandTick.func_71530_a((String[])args, (String[])new String[]{"tps", "mspt"});
        }
        return Collections.emptyList();
    }

    private static class TickMeasuringTask
    extends LongTask {
        private static final int PERIOD = 100;
        private int tickCount = 0;
        private long totalTickTime = 0L;
        private long startTickTime;
        private boolean hadFirstTick = false;
        private long firstTickStart;
        private long lastTickStart;
        private ICommandSender sender;
        private boolean tps;
        private boolean forceInaccurate;

        public TickMeasuringTask(ICommandSender sender, boolean tps, boolean forceInaccurate) {
            this.sender = sender;
            this.tps = tps;
            this.forceInaccurate = forceInaccurate;
        }

        public void incrTickCount(int count) {
            if (!this.hadFirstTick) {
                this.firstTickStart = System.nanoTime();
                this.hadFirstTick = true;
            } else {
                this.tickCount += count;
            }
        }

        public void startTick() {
            this.startTickTime = System.nanoTime();
            if (!this.hadFirstTick) {
                this.firstTickStart = this.startTickTime;
                this.hadFirstTick = true;
            }
        }

        public void endTick() {
            if (this.hadFirstTick) {
                this.totalTickTime += System.nanoTime() - this.startTickTime;
                ++this.tickCount;
            }
        }

        @Override
        protected void taskTick() {
            if (this.tickCount >= 100) {
                this.lastTickStart = System.nanoTime();
                this.setFinished();
            }
        }

        @Override
        public void start() {
            this.sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.ctick.measuring", new Object[0]));
        }

        @Override
        public void cleanup() {
            if (this.tps) {
                long totalTime = this.lastTickStart - this.firstTickStart;
                double tps = 1.0E9 * (double)this.tickCount / (double)totalTime;
                this.sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.ctick.tps", new Object[]{totalTime == 0L ? "Immeasurable" : DEC_FMT.format(tps)}));
            } else if (this.forceInaccurate) {
                long totalTime = this.lastTickStart - this.firstTickStart;
                double mspt = (double)totalTime / (1000000.0 * (double)this.tickCount);
                this.sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.ctick.mspt", new Object[]{DEC_FMT.format(mspt)}));
                this.sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.ctick.mspt.inaccurate", new Object[0]));
            } else {
                double mspt = (double)this.totalTickTime / (1000000.0 * (double)this.tickCount);
                this.sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.ctick.mspt", new Object[]{DEC_FMT.format(mspt)}));
            }
        }

        @Override
        public int getTimeout() {
            return 1200;
        }
    }
}

