/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.earthcomputer.clientcommands.TempRules;
import net.earthcomputer.clientcommands.command.ClientCommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public class CommandTempRule
extends ClientCommandBase {
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        String mode = args[0];
        if ("list".equals(mode)) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.ctemprule.list.success", new Object[]{TempRules.getRuleNames().size()}));
            TempRules.getRuleNames().forEach(name -> sender.func_145747_a((ITextComponent)new TextComponentString("- " + name)));
        } else {
            if (!("get".equals(mode) || "set".equals(mode) || "reset".equals(mode))) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            if (args.length == 1) {
                if ("set".equals(mode)) {
                    throw new WrongUsageException("commands.ctemprule.set.usage", new Object[0]);
                }
                throw new WrongUsageException("commands.ctemprule." + mode + ".usage", new Object[0]);
            }
            String ruleName = args[1];
            if (!TempRules.hasRule(ruleName)) {
                throw new CommandException("commands.ctemprule.unknownRule", new Object[]{ruleName});
            }
            TempRules.Rule<?> rule = TempRules.getRule(ruleName);
            switch (mode) {
                case "get": {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.ctemprule.get.success", new Object[]{ruleName, CommandTempRule.ruleValToString(rule)}));
                    break;
                }
                case "set": {
                    if (args.length == 2) {
                        throw new WrongUsageException("commands.ctemprule.set.usage", new Object[0]);
                    }
                    if (rule.isReadOnly()) {
                        throw new CommandException("commands.ctemprule.readOnly", new Object[]{ruleName});
                    }
                    String strVal = CommandTempRule.func_180529_a((String[])args, (int)2);
                    CommandTempRule.setRuleVal(rule, strVal);
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.ctemprule.set.success", new Object[]{ruleName, strVal}));
                    break;
                }
                case "reset": {
                    if (rule.isReadOnly()) {
                        throw new CommandException("commands.ctemprule.readOnly", new Object[]{ruleName});
                    }
                    rule.setToDefault();
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.ctemprule.reset.success", new Object[]{ruleName, CommandTempRule.ruleValToString(rule)}));
                }
            }
        }
    }

    private static <T> String ruleValToString(TempRules.Rule<T> rule) {
        return rule.getDataType().toString(rule.getValue());
    }

    private static <T> void setRuleVal(TempRules.Rule<T> rule, String strVal) throws CommandException {
        rule.setValue(rule.getDataType().parse(strVal));
    }

    public String func_71517_b() {
        return "ctemprule";
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.ctemprule.usage";
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        TempRules.Rule<?> rule2;
        if (args.length == 1) {
            return CommandTempRule.func_71530_a((String[])args, (String[])new String[]{"get", "set", "reset", "list"});
        }
        if (args.length == 2 && !"list".equals(args[0])) {
            if ("get".equals(args[0])) {
                return CommandTempRule.func_175762_a((String[])args, (Collection)TempRules.getRules().stream().filter(rule -> !rule.isHidden()).map(TempRules.Rule::getName).sorted().collect(Collectors.toList()));
            }
            return CommandTempRule.func_175762_a((String[])args, (Collection)TempRules.getRules().stream().filter(rule -> !rule.isReadOnly()).filter(rule -> !rule.isHidden()).map(TempRules.Rule::getName).sorted().collect(Collectors.toList()));
        }
        if (args.length == 3 && "set".equals(args[0]) && TempRules.hasRule(args[1]) && !(rule2 = TempRules.getRule(args[1])).isReadOnly()) {
            return CommandTempRule.func_175762_a((String[])args, rule2.getDataType().getTabCompletionOptions());
        }
        return Collections.emptyList();
    }
}

