/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.earthcomputer.clientcommands.command.ClientCommandBase;
import net.earthcomputer.clientcommands.render.RenderSettings;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.EntityList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class CommandRender
extends ClientCommandBase {
    public String func_71517_b() {
        return "crender";
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.crender.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        boolean enable;
        if (args.length < 2) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        switch (args[0]) {
            case "enable": {
                enable = true;
                break;
            }
            case "disable": {
                enable = false;
                break;
            }
            default: {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
        }
        switch (args[1]) {
            case "entities": {
                this.toggleEntities(sender, args, enable);
                break;
            }
            default: {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
        }
    }

    private void toggleEntities(ICommandSender sender, String[] args, boolean enable) throws CommandException {
        HashSet<ResourceLocation> types;
        if (args.length < 3) {
            types = EntityList.func_180124_b();
        } else {
            types = new HashSet<ResourceLocation>();
            for (int i = 2; i < args.length; ++i) {
                ResourceLocation type = new ResourceLocation(args[i]);
                if (!EntityList.func_180125_b((ResourceLocation)type)) {
                    throw new CommandException("commands.crender.entities.unknown", new Object[]{type});
                }
                types.add(type);
            }
        }
        int count = 0;
        for (ResourceLocation type : types) {
            Class clazz = EntityList.getClass((ResourceLocation)type);
            if (RenderSettings.isEntityRenderingDisabled(clazz) != enable) continue;
            ++count;
            if (enable) {
                RenderSettings.enableEntityRendering(clazz);
                continue;
            }
            RenderSettings.disableEntityRendering(clazz);
        }
        if (enable) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.crender.entities.enable.success", new Object[]{count}));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.crender.entities.disable.success", new Object[]{count}));
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 0) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            return CommandRender.func_71530_a((String[])args, (String[])new String[]{"enable", "disable"});
        }
        if (args.length == 2) {
            return CommandRender.func_71530_a((String[])args, (String[])new String[]{"entities"});
        }
        if (args.length == 3) {
            if ("entities".equals(args[1])) {
                return CommandRender.func_175762_a((String[])args, (Collection)EntityList.func_180124_b());
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }
}

