/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import java.util.Collections;
import java.util.List;
import net.earthcomputer.clientcommands.command.ClientCommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class CommandLook
extends ClientCommandBase {
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String mode;
        if (args.length < 1) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        switch (mode = args[0]) {
            case "block": {
                this.lookBlock(sender, args);
                break;
            }
            case "angles": {
                this.lookAngles(sender, args);
                break;
            }
            case "cardinal": {
                this.lookCardinal(sender, args);
                break;
            }
            default: {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
        }
    }

    private void lookBlock(ICommandSender sender, String ... args) throws CommandException {
        if (args.length < 4) {
            throw new WrongUsageException("commands.clook.block.usage", new Object[0]);
        }
        BlockPos pos = CommandLook.func_175757_a((ICommandSender)sender, (String[])args, (int)1, (boolean)true);
        Vec3d entPos = sender.func_174791_d();
        double dx = (double)pos.func_177958_n() + 0.5 - entPos.field_72450_a;
        double dy = (double)pos.func_177956_o() + 0.5 - (entPos.field_72448_b + (double)sender.func_174793_f().func_70047_e());
        double dz = (double)pos.func_177952_p() + 0.5 - entPos.field_72449_c;
        double dh = Math.sqrt(dx * dx + dz * dz);
        float yaw = (float)Math.toDegrees(Math.atan2(dz, dx)) - 90.0f;
        float pitch = (float)(-Math.toDegrees(Math.atan2(dy, dh)));
        this.doLook(sender, yaw, pitch);
    }

    private void lookAngles(ICommandSender sender, String ... args) throws CommandException {
        if (args.length < 3) {
            throw new WrongUsageException("commands.clook.angles.usage", new Object[0]);
        }
        float yaw = (float)CommandLook.func_175770_a((double)sender.func_174793_f().field_70177_z, (String)args[1], (boolean)false).func_179628_a();
        float pitch = (float)CommandLook.func_175770_a((double)sender.func_174793_f().field_70125_A, (String)args[2], (boolean)false).func_179628_a();
        this.doLook(sender, yaw, pitch);
    }

    private void lookCardinal(ICommandSender sender, String ... args) throws CommandException {
        if (args.length < 2) {
            throw new WrongUsageException("commands.clook.cardinal.usage", new Object[0]);
        }
        EnumFacing direction = EnumFacing.func_176739_a((String)args[1]);
        if (direction == null) {
            throw new WrongUsageException("commands.clook.cardinal.usage", new Object[0]);
        }
        switch (direction) {
            case DOWN: {
                this.doLook(sender, sender.func_174793_f().field_70177_z, 90.0f);
                break;
            }
            case EAST: {
                this.doLook(sender, -90.0f, 0.0f);
                break;
            }
            case NORTH: {
                this.doLook(sender, -180.0f, 0.0f);
                break;
            }
            case SOUTH: {
                this.doLook(sender, 0.0f, 0.0f);
                break;
            }
            case UP: {
                this.doLook(sender, sender.func_174793_f().field_70177_z, -90.0f);
                break;
            }
            case WEST: {
                this.doLook(sender, 90.0f, 0.0f);
            }
        }
    }

    private void doLook(ICommandSender sender, float yaw, float pitch) {
        sender.func_174793_f().func_70012_b(sender.func_174793_f().field_70165_t, sender.func_174793_f().field_70163_u, sender.func_174793_f().field_70161_v, MathHelper.func_76142_g((float)yaw), pitch);
    }

    public String func_71517_b() {
        return "clook";
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.clook.usage";
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 0) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            return CommandLook.func_71530_a((String[])args, (String[])new String[]{"block", "angles", "cardinal"});
        }
        if ("cardinal".equals(args[0])) {
            return CommandLook.func_71530_a((String[])args, (String[])new String[]{"west", "east", "down", "up", "north", "south"});
        }
        return Collections.emptyList();
    }
}

