/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import java.util.List;
import net.earthcomputer.clientcommands.command.ClientCommandBase;
import net.earthcomputer.clientcommands.task.GuiBlocker;
import net.earthcomputer.clientcommands.task.LongTask;
import net.earthcomputer.clientcommands.task.TaskManager;
import net.earthcomputer.clientcommands.util.DelegatingContainer;
import net.earthcomputer.clientcommands.util.Ptr;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class CommandFindItem
extends ClientCommandBase {
    public void func_184881_a(MinecraftServer server, final ICommandSender sender, String[] args) throws CommandException {
        TaskManager.ensureNoTasks();
        if (args.length < 1) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        final Item item = CommandFindItem.func_147179_f((ICommandSender)sender, (String)args[0]);
        final int damage = args.length < 2 || "*".equals(args[1]) ? -1 : CommandFindItem.func_175764_a((String)args[1], (int)-1, (int)Short.MAX_VALUE);
        NBTTagCompound nbt = null;
        if (args.length >= 3) {
            try {
                nbt = JsonToNBT.func_180713_a((String)CommandFindItem.func_147178_a((ICommandSender)sender, (String[])args, (int)2).func_150260_c());
            }
            catch (NBTException e) {
                throw new CommandException("commands.give.tagError", new Object[]{e.getMessage()});
            }
        }
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient world = mc.field_71441_e;
        for (int i = 0; i < mc.field_71439_g.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = mc.field_71439_g.field_71071_by.func_70301_a(i);
            if (stack.func_77973_b() != item || damage != -1 && stack.func_77952_i() != damage || nbt != null && !NBTUtil.func_181123_a((NBTBase)nbt, (NBTBase)stack.func_77978_p(), (boolean)true)) continue;
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.cfinditem.alreadyPresent", new Object[0]));
            return;
        }
        if (mc.field_71439_g.func_70093_af()) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + I18n.func_135052_a((String)"commands.cfinditem.sneaking", (Object[])new Object[0])));
            return;
        }
        float radius = mc.field_71442_b.func_78757_d() + 0.5f;
        double playerx = sender.func_174791_d().field_72450_a;
        double playery = sender.func_174791_d().field_72448_b + (double)sender.func_174793_f().func_70047_e();
        double playerz = sender.func_174791_d().field_72449_c;
        final Ptr<Integer> itemsFound = new Ptr<Integer>(0);
        int x = (int)(playerx - (double)radius);
        while ((double)x <= playerx + (double)radius) {
            int z = (int)(playerz - (double)radius);
            while ((double)z <= playerz + (double)radius) {
                int y = (int)(playery - (double)radius);
                while ((double)y <= playery + (double)radius) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (CommandFindItem.shouldSearch((World)world, pos)) {
                        TaskManager.addLongTask(new WaitForGuiTask(mc, item, damage, nbt, sender, pos, itemsFound));
                    }
                    ++y;
                }
                ++z;
            }
            ++x;
        }
        final NBTTagCompound nbt_f = nbt;
        TaskManager.addLongTask(new LongTask(){

            @Override
            public void start() {
                int noItemsFound = (Integer)itemsFound.get();
                if (noItemsFound == 0) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + I18n.func_135052_a((String)"commands.cfinditem.noMatch", (Object[])new Object[0])));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.cfinditem.success", new Object[]{noItemsFound, new ItemStack(item, 1, damage, nbt_f).func_82833_r()}));
                }
                this.setFinished();
            }

            @Override
            protected void taskTick() {
            }
        });
    }

    public String func_71517_b() {
        return "cfinditem";
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.cfinditem.usage";
    }

    private static boolean shouldSearch(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        TileEntity te = world.func_175625_s(pos);
        if (block == Blocks.field_150477_bB) {
            return true;
        }
        if (block instanceof BlockChest) {
            if (!(te instanceof TileEntityChest)) {
                return false;
            }
            TileEntityChest chest = (TileEntityChest)te;
            if (!chest.field_145984_a) {
                chest.func_145979_i();
            }
            return chest.field_145991_k == null && chest.field_145992_i == null;
        }
        return te instanceof IInventory;
    }

    private static class WaitForGuiTask
    extends LongTask {
        private Minecraft mc;
        private Item item;
        private int damage;
        private NBTTagCompound nbt;
        private ICommandSender sender;
        private BlockPos pos;
        private Ptr<Integer> itemsFound;

        public WaitForGuiTask(Minecraft mc, Item item, int damage, NBTTagCompound nbt, ICommandSender sender, BlockPos pos, Ptr<Integer> itemsFound) {
            this.mc = mc;
            this.item = item;
            this.damage = damage;
            this.nbt = nbt;
            this.sender = sender;
            this.pos = pos;
            this.itemsFound = itemsFound;
        }

        @Override
        public void start() {
            GuiBlocker blocker = new GuiBlocker(){

                @Override
                public boolean processGui(GuiScreen gui) {
                    if (gui instanceof GuiContainer) {
                        GuiContainer containerGui = (GuiContainer)gui;
                        ((WaitForGuiTask)this).mc.field_71439_g.field_71070_bA = new DelegatingContainer(containerGui.field_147002_h){

                            public void func_190896_a(List<ItemStack> stacks) {
                                for (ItemStack stack : stacks) {
                                    if (stack.func_77973_b() != item || damage != -1 && stack.func_77952_i() != damage || nbt != null && !NBTUtil.func_181123_a((NBTBase)nbt, (NBTBase)stack.func_77978_p(), (boolean)true)) continue;
                                    sender.func_145747_a(new TextComponentTranslation("commands.cfinditem.match.left", new Object[0]).func_150257_a(ClientCommandBase.getCoordsTextComponent(pos)).func_150257_a((ITextComponent)new TextComponentTranslation("commands.cfinditem.match.right", new Object[0])));
                                    itemsFound.set((Integer)itemsFound.get() + stack.func_190916_E());
                                }
                                ((WaitForGuiTask)this).mc.field_71439_g.func_71053_j();
                                this.setFinished();
                            }
                        };
                        this.setFinished();
                        return false;
                    }
                    return true;
                }
            };
            TaskManager.addGuiBlocker(blocker);
            boolean success = false;
            for (EnumHand hand : EnumHand.values()) {
                EnumActionResult result = this.mc.field_71442_b.func_187099_a(this.mc.field_71439_g, this.mc.field_71441_e, this.pos, EnumFacing.DOWN, new Vec3d((Vec3i)this.pos), hand);
                if (result == EnumActionResult.FAIL) {
                    this.sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + I18n.func_135052_a((String)"commands.cfinditem.unableToOpen", (Object[])new Object[0])));
                    break;
                }
                if (result != EnumActionResult.SUCCESS) continue;
                success = true;
                break;
            }
            if (!success) {
                blocker.setFinished();
            }
        }

        @Override
        protected void taskTick() {
        }
    }
}

