/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import net.earthcomputer.clientcommands.command.ClientCommandBase;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.chunk.Chunk;

public class CommandFindBlock
extends ClientCommandBase {
    private static final int MAX_RADIUS = 128;

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        BlockPos closestBlock;
        List<BlockPos> candidates;
        String radiusType;
        if (args.length < 1) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        Block block = CommandFindBlock.func_147180_g((ICommandSender)sender, (String)args[0]);
        com.google.common.base.Predicate blockMatcher = args.length < 2 ? state -> state.func_177230_c() == block : CommandFindBlock.func_190791_b((Block)block, (String)args[1]);
        int radius = args.length < 3 ? 128 : CommandFindBlock.func_175764_a((String)args[2], (int)0, (int)128);
        switch (radiusType = args.length < 4 ? "cartesian" : args[3]) {
            case "cartesian": 
            case "square": {
                candidates = this.findBlockCandidatesInSquareArea(sender, (Predicate<IBlockState>)blockMatcher, radius, radiusType);
                break;
            }
            case "taxicab": {
                candidates = this.findBlockCandidatesInTaxicabArea(sender, (Predicate<IBlockState>)blockMatcher, radius);
                break;
            }
            default: {
                throw new CommandException("commands.cfindblock.unknownRadiusType", new Object[]{radiusType});
            }
        }
        if (candidates.isEmpty()) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + I18n.func_135052_a((String)"commands.cfindblock.notFound", (Object[])new Object[0])));
            return;
        }
        switch (radiusType) {
            case "cartesian": {
                closestBlock = candidates.stream().filter(it -> it.func_177951_i((Vec3i)sender.func_180425_c()) <= (double)(radius * radius)).min(Comparator.comparingDouble(it -> it.func_177951_i((Vec3i)sender.func_180425_c()))).orElse(null);
                break;
            }
            case "square": {
                closestBlock = candidates.stream().filter(it -> Math.max(Math.max(Math.abs(sender.func_180425_c().func_177958_n() - it.func_177958_n()), Math.abs(sender.func_180425_c().func_177952_p() - it.func_177952_p())), Math.abs(sender.func_180425_c().func_177956_o() - it.func_177956_o())) <= radius).min(Comparator.comparingInt(it -> Math.max(Math.max(Math.abs(sender.func_180425_c().func_177958_n() - it.func_177958_n()), Math.abs(sender.func_180425_c().func_177952_p() - it.func_177952_p())), Math.abs(sender.func_180425_c().func_177956_o() - it.func_177956_o())))).orElse(null);
                break;
            }
            case "taxicab": {
                closestBlock = candidates.stream().filter(it -> Math.abs(sender.func_180425_c().func_177958_n() - it.func_177958_n()) + Math.abs(sender.func_180425_c().func_177956_o() - it.func_177956_o()) + Math.abs(sender.func_180425_c().func_177952_p() - it.func_177952_p()) <= radius).min(Comparator.comparingInt(it -> Math.abs(sender.func_180425_c().func_177958_n() - it.func_177958_n()) + Math.abs(sender.func_180425_c().func_177956_o() - it.func_177956_o()) + Math.abs(sender.func_180425_c().func_177952_p() - it.func_177952_p()))).orElse(null);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (closestBlock == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + I18n.func_135052_a((String)"commands.cfindblock.notFound", (Object[])new Object[0])));
        } else {
            float distance;
            switch (radiusType) {
                case "cartesian": {
                    distance = MathHelper.func_76133_a((double)closestBlock.func_177951_i((Vec3i)sender.func_180425_c()));
                    break;
                }
                case "square": {
                    distance = Math.max(Math.max(Math.abs(sender.func_180425_c().func_177958_n() - closestBlock.func_177958_n()), Math.abs(sender.func_180425_c().func_177952_p() - closestBlock.func_177952_p())), Math.abs(sender.func_180425_c().func_177956_o() - closestBlock.func_177956_o()));
                    break;
                }
                case "taxicab": {
                    distance = Math.abs(sender.func_180425_c().func_177958_n() - closestBlock.func_177958_n()) + Math.abs(sender.func_180425_c().func_177956_o() - closestBlock.func_177956_o()) + Math.abs(sender.func_180425_c().func_177952_p() - closestBlock.func_177952_p());
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            sender.func_145747_a(new TextComponentTranslation("commands.cfindblock.success.left", new Object[]{Float.valueOf(distance)}).func_150257_a(CommandFindBlock.getCoordsTextComponent(closestBlock)).func_150257_a((ITextComponent)new TextComponentTranslation("commands.cfindblock.success.right", new Object[]{Float.valueOf(distance)})));
        }
    }

    private List<BlockPos> findBlockCandidatesInSquareArea(ICommandSender sender, Predicate<IBlockState> blockMatcher, int radius, String radiusType) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        BlockPos senderPos = sender.func_180425_c();
        ChunkPos chunkPos = new ChunkPos(senderPos);
        ArrayList<BlockPos> blockCandidates = new ArrayList<BlockPos>();
        int chunkRadius = (radius >> 4) + 1;
        for (int r = 0; r < chunkRadius; ++r) {
            for (int chunkX = chunkPos.field_77276_a - r; chunkX <= chunkPos.field_77276_a + r; ++chunkX) {
                for (int chunkZ = chunkPos.field_77275_b - r; chunkZ <= chunkPos.field_77275_b + r; chunkZ += chunkX == chunkPos.field_77276_a - r || chunkX == chunkPos.field_77276_a + r ? 1 : r + r) {
                    Chunk chunk = world.func_72964_e(chunkX, chunkZ);
                    if (!this.searchChunkForBlockCandidates(chunk, senderPos.func_177956_o(), blockMatcher, blockCandidates)) continue;
                    int dx = chunkPos.field_77276_a - chunkX;
                    int dz = chunkPos.field_77275_b - chunkZ;
                    int newChunkRadius = "cartesian".equals(radiusType) ? MathHelper.func_76123_f((float)(MathHelper.func_76129_c((float)(dx * dx + dz * dz)) + MathHelper.field_180189_a)) : Math.max(Math.abs(chunkPos.field_77276_a - chunkX), Math.abs(chunkPos.field_77275_b - chunkZ)) + 1;
                    if (newChunkRadius >= chunkRadius) continue;
                    chunkRadius = newChunkRadius;
                }
            }
        }
        return blockCandidates;
    }

    private List<BlockPos> findBlockCandidatesInTaxicabArea(ICommandSender sender, Predicate<IBlockState> blockMatcher, int radius) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        BlockPos senderPos = sender.func_180425_c();
        ChunkPos chunkPos = new ChunkPos(senderPos);
        ArrayList<BlockPos> blockCandidates = new ArrayList<BlockPos>();
        int chunkRadius = (radius >> 4) + 1;
        for (int r = 0; r < chunkRadius; ++r) {
            for (int chunkX = chunkPos.field_77276_a - r; chunkX <= chunkPos.field_77276_a + r; ++chunkX) {
                int chunkZ = chunkPos.field_77275_b - (r - Math.abs(chunkPos.field_77276_a - chunkX));
                for (int i = 0; i < 2; ++i) {
                    int newChunkRadius;
                    Chunk chunk = world.func_72964_e(chunkX, chunkZ);
                    if (this.searchChunkForBlockCandidates(chunk, senderPos.func_177956_o(), blockMatcher, blockCandidates) && (newChunkRadius = Math.abs(chunkPos.field_77276_a - chunkX) + Math.abs(chunkPos.field_77275_b - chunkZ) + 1) < chunkRadius) {
                        chunkRadius = newChunkRadius;
                    }
                    chunkZ = chunkPos.field_77275_b + (r - Math.abs(chunkPos.field_77276_a - chunkX));
                }
            }
        }
        return blockCandidates;
    }

    private boolean searchChunkForBlockCandidates(Chunk chunk, int senderY, Predicate<IBlockState> blockMatcher, List<BlockPos> blockCandidates) {
        boolean found = false;
        int maxY = chunk.func_76625_h() + 15;
        for (int x = 0; x < 16; ++x) {
            block1: for (int z = 0; z < 16; ++z) {
                int maxDy = Math.max(senderY, maxY - senderY);
                int dy = 0;
                while (dy <= maxDy) {
                    if (senderY + dy >= 0 && senderY + dy < 256 && blockMatcher.test(chunk.func_186032_a(x, senderY + dy, z))) {
                        blockCandidates.add(new BlockPos((chunk.field_76635_g << 4) + x, senderY + dy, (chunk.field_76647_h << 4) + z));
                        found = true;
                        continue block1;
                    }
                    dy = dy > 0 ? -dy : -dy + 1;
                }
            }
        }
        return found;
    }

    public String func_71517_b() {
        return "cfindblock";
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.cfindblock.usage";
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return CommandFindBlock.func_175762_a((String[])args, (Collection)Block.field_149771_c.func_148742_b());
        }
        if (args.length == 4) {
            return CommandFindBlock.func_71530_a((String[])args, (String[])new String[]{"cartesian", "taxicab", "square"});
        }
        return Collections.emptyList();
    }
}

