/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.earthcomputer.clientcommands.command.ClientCommandBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class CommandFind
extends ClientCommandBase {
    private static final ResourceLocation PLAYER = new ResourceLocation("player");

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length % 2 == 0) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        Stream<Object> entities = world.field_72996_f.stream();
        ResourceLocation type = new ResourceLocation(args[0]);
        Class entityClass = PLAYER.equals((Object)type) ? EntityPlayer.class : EntityList.getClass((ResourceLocation)type);
        if (entityClass == null) {
            throw new CommandException("commands.cfind.unknownEntity", new Object[]{args[0]});
        }
        entities = entities.filter(entityClass::isInstance);
        block24: for (int i = 1; i < args.length; i += 2) {
            String arg = args[i];
            String value = args[i + 1];
            switch (arg) {
                case "rmin": {
                    int rmin = CommandFind.func_175755_a((String)value);
                    entities = entities.filter(arg_0 -> CommandFind.lambda$execute$0((EntityPlayer)player, rmin, arg_0));
                    continue block24;
                }
                case "rmax": {
                    int rmax = CommandFind.func_175755_a((String)value);
                    entities = entities.filter(arg_0 -> CommandFind.lambda$execute$1((EntityPlayer)player, rmax, arg_0));
                    continue block24;
                }
                case "order": {
                    switch (value) {
                        case "nearest": {
                            entities = entities.sorted(Comparator.comparingDouble(arg_0 -> CommandFind.lambda$execute$2((EntityPlayer)player, arg_0)));
                            continue block24;
                        }
                        case "furthest": {
                            entities = entities.sorted(Comparator.comparingDouble(arg_0 -> CommandFind.lambda$execute$3((EntityPlayer)player, arg_0)).reversed());
                            continue block24;
                        }
                        case "random": {
                            int r = ThreadLocalRandom.current().nextInt();
                            Comparator<Entity> randomComparator = Comparator.comparingInt(entity -> entity.func_110124_au().hashCode() ^ r).thenComparing(Entity::func_110124_au);
                            entities = entities.sorted(randomComparator);
                            continue block24;
                        }
                    }
                    throw new CommandException("commands.cfind.order.unknown", new Object[]{value});
                }
                case "limit": {
                    int limit = CommandFind.func_180528_a((String)value, (int)0);
                    entities = entities.limit(limit);
                    continue block24;
                }
                case "name": {
                    entities = entities.filter(entity -> entity.func_70005_c_().equalsIgnoreCase(value));
                    continue block24;
                }
                default: {
                    throw new CommandException("commands.cfind.unknownArg", new Object[]{arg});
                }
            }
        }
        List entityList = entities.collect(Collectors.toList());
        if (entityList.isEmpty()) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + I18n.func_135052_a((String)"commands.cfind.noMatch", (Object[])new Object[0])));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.cfind.success", new Object[]{entityList.size()}));
            for (Entity entity2 : entityList) {
                float distance = player.func_70032_d(entity2);
                sender.func_145747_a(new TextComponentTranslation("commands.cfind.found.left", new Object[]{entity2.func_70005_c_(), Float.valueOf(distance)}).func_150257_a(CommandFind.getCoordsTextComponent(new BlockPos(entity2))).func_150257_a((ITextComponent)new TextComponentTranslation("commands.cfind.found.right", new Object[]{entity2.func_70005_c_(), Float.valueOf(distance)})));
            }
        }
    }

    public String func_71517_b() {
        return "cfind";
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.cfind.usage";
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 0) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
            list.add(PLAYER);
            list.addAll(EntityList.func_180124_b());
            list.sort(Comparator.comparing(ResourceLocation::func_110624_b).thenComparing(ResourceLocation::func_110623_a));
            return CommandFind.func_175762_a((String[])args, list);
        }
        if (args.length % 2 == 0) {
            return CommandFind.func_71530_a((String[])args, (String[])new String[]{"rmin", "rmax", "order", "limit", "name"});
        }
        switch (args[args.length - 2]) {
            case "order": {
                return CommandFind.func_71530_a((String[])args, (String[])new String[]{"nearest", "furthest", "random"});
            }
            case "name": {
                return CommandFind.func_175762_a((String[])args, (Collection)Minecraft.func_71410_x().field_71441_e.field_73010_i.stream().map(Entity::func_70005_c_).sorted().collect(Collectors.toList()));
            }
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ double lambda$execute$3(EntityPlayer player, Entity entity) {
        return player.func_70068_e(entity);
    }

    private static /* synthetic */ double lambda$execute$2(EntityPlayer player, Entity entity) {
        return player.func_70068_e(entity);
    }

    private static /* synthetic */ boolean lambda$execute$1(EntityPlayer player, int rmax, Entity entity) {
        return player.func_70068_e(entity) <= (double)(rmax * rmax);
    }

    private static /* synthetic */ boolean lambda$execute$0(EntityPlayer player, int rmin, Entity entity) {
        return player.func_70068_e(entity) >= (double)(rmin * rmin);
    }
}

