/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleUnaryOperator;
import java.util.function.ToDoubleFunction;
import net.earthcomputer.clientcommands.TempRules;
import net.earthcomputer.clientcommands.command.ClientCommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class CommandCalc
extends ClientCommandBase {
    private static final Map<String, DoubleSupplier> VARIABLES = new HashMap<String, DoubleSupplier>();
    private static final Map<String, ToDoubleFunction<double[]>> FUNCTIONS = new HashMap<String, ToDoubleFunction<double[]>>();

    private static void functionAlias(String old, String _new) {
        SimpleFunction f = FUNCTIONS.get(old);
        if (f instanceof SimpleFunction) {
            f = new SimpleFunction(_new, f.f);
        }
        FUNCTIONS.put(_new, f);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        double ans;
        Expression expr;
        if (args.length == 0) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        String expression = CommandCalc.func_180529_a((String[])args, (int)0);
        try {
            StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(expression));
            tokenizer.parseNumbers();
            tokenizer.ordinaryChar(43);
            tokenizer.ordinaryChar(45);
            tokenizer.ordinaryChar(47);
            expr = Expression.parse(tokenizer);
            if (tokenizer.nextToken() != -1) {
                throw CommandCalc.syntaxError();
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        try {
            ans = expr.evaluate();
        }
        catch (ArithmeticException e) {
            throw new CommandException("commands.ccalc.mathError", new Object[]{e.getMessage()});
        }
        TempRules.CALC_ANSWER.setValue(ans);
        if (ans > 0.0 && ans % 1.0 == 0.0 && Double.isFinite(ans)) {
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format("%s = " + TextFormatting.BOLD + "%d" + TextFormatting.RESET + " = %d * 64 + %d", expression, (long)ans, (long)ans / 64L, (long)ans % 64L)));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString(expression + " = " + TextFormatting.BOLD + CommandCalc.toString(ans) + TextFormatting.RESET));
        }
    }

    public String func_71517_b() {
        return "ccalc";
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.ccalc.usage";
    }

    private static CommandException syntaxError() {
        return new CommandException("commands.ccalc.syntaxError", new Object[0]);
    }

    private static String toString(double val) {
        if (val % 1.0 == 0.0 && Double.isFinite(val)) {
            String str = String.valueOf(val);
            return str.substring(0, str.length() - 2);
        }
        return String.valueOf(val);
    }

    static {
        VARIABLES.put("pi", () -> Math.PI);
        VARIABLES.put("e", () -> Math.E);
        VARIABLES.put("ans", TempRules.CALC_ANSWER::getValue);
        FUNCTIONS.put("sqrt", new SimpleFunction("sqrt", Math::sqrt));
        FUNCTIONS.put("abs", new SimpleFunction("abs", Math::abs));
        FUNCTIONS.put("ln", new SimpleFunction("ln", Math::log));
        FUNCTIONS.put("log", args -> {
            if (((double[])args).length == 1) {
                return Math.log10(args[0]);
            }
            if (((double[])args).length == 2) {
                return Math.log(args[0]) / Math.log(args[1]);
            }
            throw new ArithmeticException("log takes 1 or 2 arguments");
        });
        FUNCTIONS.put("sin", new SimpleFunction("sin", Math::sin));
        FUNCTIONS.put("cos", new SimpleFunction("cos", Math::cos));
        FUNCTIONS.put("tan", new SimpleFunction("tan", Math::tan));
        FUNCTIONS.put("csc", new SimpleFunction("csc", n -> 1.0 / Math.sin(n)));
        CommandCalc.functionAlias("csc", "cosec");
        FUNCTIONS.put("sec", new SimpleFunction("sec", n -> 1.0 / Math.cos(n)));
        FUNCTIONS.put("cot", new SimpleFunction("cot", n -> 1.0 / Math.tan(n)));
        FUNCTIONS.put("asin", new SimpleFunction("asin", Math::asin));
        CommandCalc.functionAlias("asin", "arsin");
        CommandCalc.functionAlias("asin", "arcsin");
        FUNCTIONS.put("acos", new SimpleFunction("acos", Math::acos));
        CommandCalc.functionAlias("acos", "arcos");
        CommandCalc.functionAlias("acos", "arccos");
        FUNCTIONS.put("atan", new SimpleFunction("atan", Math::atan));
        CommandCalc.functionAlias("atan", "artan");
        CommandCalc.functionAlias("atan", "arctan");
        FUNCTIONS.put("atan2", args -> {
            if (((double[])args).length != 2) {
                throw new ArithmeticException("atan2 takes 2 arguments");
            }
            return Math.atan2(args[0], args[1]);
        });
        FUNCTIONS.put("acsc", new SimpleFunction("acsc", n -> Math.asin(1.0 / n)));
        CommandCalc.functionAlias("acsc", "arcsc");
        CommandCalc.functionAlias("acsc", "arccsc");
        CommandCalc.functionAlias("acsc", "acosec");
        CommandCalc.functionAlias("acsc", "arcosec");
        CommandCalc.functionAlias("acsc", "arccosec");
        FUNCTIONS.put("asec", new SimpleFunction("asec", n -> Math.acos(1.0 / n)));
        CommandCalc.functionAlias("asec", "arsec");
        CommandCalc.functionAlias("asec", "arcsec");
        FUNCTIONS.put("acot", new SimpleFunction("acot", n -> Math.atan(1.0 / n)));
        CommandCalc.functionAlias("acot", "arcot");
        CommandCalc.functionAlias("acot", "arccot");
        FUNCTIONS.put("sinh", new SimpleFunction("sinh", Math::sinh));
        FUNCTIONS.put("cosh", new SimpleFunction("cosh", Math::cosh));
        FUNCTIONS.put("tanh", new SimpleFunction("tanh", Math::tanh));
        FUNCTIONS.put("csch", new SimpleFunction("csch", n -> 1.0 / Math.sinh(n)));
        CommandCalc.functionAlias("csch", "cosech");
        FUNCTIONS.put("sech", new SimpleFunction("sech", n -> 1.0 / Math.cosh(n)));
        FUNCTIONS.put("coth", new SimpleFunction("coth", n -> 1.0 / Math.tanh(n)));
        FUNCTIONS.put("asinh", new SimpleFunction("asinh", n -> Math.log(n + Math.sqrt(1.0 + n * n))));
        CommandCalc.functionAlias("asinh", "arsinh");
        CommandCalc.functionAlias("asinh", "arcsinh");
        FUNCTIONS.put("acosh", new SimpleFunction("acosh", n -> Math.log(n + Math.sqrt(n * n - 1.0))));
        CommandCalc.functionAlias("acosh", "arcosh");
        CommandCalc.functionAlias("acosh", "arccosh");
        FUNCTIONS.put("atanh", new SimpleFunction("atanh", n -> 0.5 * Math.log((1.0 + n) / (1.0 - n))));
        CommandCalc.functionAlias("atanh", "artanh");
        CommandCalc.functionAlias("atanh", "arctanh");
        FUNCTIONS.put("acsch", new SimpleFunction("acsch", n -> {
            if (n < 0.0) {
                return Math.log((1.0 - Math.sqrt(1.0 + n * n)) / n);
            }
            if (n > 0.0) {
                return Math.log((1.0 + Math.sqrt(1.0 + n * n)) / n);
            }
            return Double.NaN;
        }));
        CommandCalc.functionAlias("acsch", "arcsch");
        CommandCalc.functionAlias("acsch", "arccsch");
        CommandCalc.functionAlias("acsch", "acosech");
        CommandCalc.functionAlias("acsch", "arcosech");
        CommandCalc.functionAlias("acsch", "arccosech");
        FUNCTIONS.put("asech", new SimpleFunction("asech", n -> {
            if (n < -1.0) {
                return Math.log((1.0 - Math.sqrt(1.0 - n * n)) / n);
            }
            if (n > 0.0) {
                return Math.log((1.0 + Math.sqrt(1.0 - n * n)) / n);
            }
            return Double.NaN;
        }));
        CommandCalc.functionAlias("asech", "arsech");
        CommandCalc.functionAlias("asech", "arcsech");
        FUNCTIONS.put("acoth", new SimpleFunction("acoth", n -> 0.5 * Math.log((n + 1.0) / (n - 1.0))));
        CommandCalc.functionAlias("acoth", "arcoth");
        CommandCalc.functionAlias("acoth", "arccoth");
    }

    private static class SimpleFunction
    implements ToDoubleFunction<double[]> {
        private String name;
        private DoubleUnaryOperator f;

        public SimpleFunction(String name, DoubleUnaryOperator f) {
            this.name = name;
            this.f = f;
        }

        @Override
        public double applyAsDouble(double[] args) {
            if (args.length != 1) {
                throw new ArithmeticException(this.name + " takes 1 argument");
            }
            return this.f.applyAsDouble(args[0]);
        }
    }

    private static enum MultSign {
        MULTIPLY,
        DIVIDE;

    }

    private static enum Sign {
        PLUS,
        MINUS;

    }

    private static class FunctionTerm
    implements Term {
        private ToDoubleFunction<double[]> f;
        private List<Expression> arguments;

        private FunctionTerm(ToDoubleFunction<double[]> f, List<Expression> arguments) {
            this.f = f;
            this.arguments = arguments;
        }

        public static FunctionTerm parse(StreamTokenizer tokenizer) throws CommandException, IOException {
            if (tokenizer.nextToken() != -3) {
                throw CommandCalc.syntaxError();
            }
            ToDoubleFunction f = (ToDoubleFunction)FUNCTIONS.get(tokenizer.sval.toLowerCase(Locale.ENGLISH));
            if (f == null) {
                throw CommandCalc.syntaxError();
            }
            if (tokenizer.nextToken() != 40) {
                throw CommandCalc.syntaxError();
            }
            ArrayList<Expression> args = new ArrayList<Expression>();
            args.add(Expression.parse(tokenizer));
            block4: while (true) {
                switch (tokenizer.nextToken()) {
                    case 44: {
                        args.add(Expression.parse(tokenizer));
                        continue block4;
                    }
                    case 41: {
                        return new FunctionTerm(f, args);
                    }
                }
                break;
            }
            throw CommandCalc.syntaxError();
        }

        @Override
        public double evaluate() {
            return this.f.applyAsDouble(this.arguments.stream().mapToDouble(Expression::evaluate).toArray());
        }
    }

    private static class ExponentialTerm
    implements Term {
        private Term base;
        private Term exponent;

        public ExponentialTerm(Term base, Term exponent) {
            this.base = base;
            this.exponent = exponent;
        }

        @Override
        public double evaluate() {
            return Math.pow(this.base.evaluate(), this.exponent.evaluate());
        }
    }

    private static class NegateTerm
    implements Term {
        private Term child;

        public NegateTerm(Term child) {
            this.child = child;
        }

        @Override
        public double evaluate() {
            return -this.child.evaluate();
        }
    }

    private static class ParenthesesTerm
    implements Term {
        private Expression expr;

        private ParenthesesTerm(Expression expr) {
            this.expr = expr;
        }

        public static ParenthesesTerm parse(StreamTokenizer tokenizer) throws CommandException, IOException {
            if (tokenizer.nextToken() != 40) {
                throw CommandCalc.syntaxError();
            }
            Expression expr = Expression.parse(tokenizer);
            if (tokenizer.nextToken() != 41) {
                throw CommandCalc.syntaxError();
            }
            return new ParenthesesTerm(expr);
        }

        @Override
        public double evaluate() {
            return this.expr.evaluate();
        }
    }

    private static class NumberTerm
    implements Term {
        private double number;

        public NumberTerm(double number) {
            this.number = number;
        }

        @Override
        public double evaluate() {
            return this.number;
        }
    }

    private static interface Term {
        public static Term parse(StreamTokenizer tokenizer) throws CommandException, IOException {
            boolean negative = false;
            do {
                if (tokenizer.nextToken() != 45) continue;
                boolean bl = negative = !negative;
            } while (tokenizer.ttype == 43 || tokenizer.ttype == 45);
            tokenizer.pushBack();
            if (negative) {
                return new NegateTerm(Term.parse(tokenizer));
            }
            switch (tokenizer.nextToken()) {
                case -2: {
                    return new NumberTerm(tokenizer.nval);
                }
                case -3: {
                    DoubleSupplier supplier = (DoubleSupplier)VARIABLES.get(tokenizer.sval.toLowerCase(Locale.ENGLISH));
                    if (supplier == null) {
                        tokenizer.pushBack();
                        return FunctionTerm.parse(tokenizer);
                    }
                    return new NumberTerm(supplier.getAsDouble());
                }
                case 40: {
                    tokenizer.pushBack();
                    return ParenthesesTerm.parse(tokenizer);
                }
            }
            throw CommandCalc.syntaxError();
        }

        public double evaluate();
    }

    private static class Product {
        private List<MultSign> signs;
        private List<Term> terms;

        private Product(List<MultSign> signs, List<Term> terms) {
            this.signs = signs;
            this.terms = terms;
        }

        public static Product parse(StreamTokenizer tokenizer) throws CommandException, IOException {
            ArrayList<Term> terms = new ArrayList<Term>();
            ArrayList<MultSign> signs = new ArrayList<MultSign>();
            terms.add(Term.parse(tokenizer));
            block6: while (true) {
                switch (tokenizer.nextToken()) {
                    case 42: {
                        signs.add(MultSign.MULTIPLY);
                        break;
                    }
                    case 47: {
                        signs.add(MultSign.DIVIDE);
                        break;
                    }
                    case -3: 
                    case 40: {
                        signs.add(MultSign.MULTIPLY);
                        tokenizer.pushBack();
                        break;
                    }
                    case 94: {
                        terms.set(terms.size() - 1, new ExponentialTerm((Term)terms.get(terms.size() - 1), Term.parse(tokenizer)));
                        continue block6;
                    }
                    default: {
                        tokenizer.pushBack();
                        return new Product(signs, terms);
                    }
                }
                terms.add(Term.parse(tokenizer));
            }
        }

        public double evaluate() {
            double val = this.terms.get(0).evaluate();
            block4: for (int i = 0; i < this.signs.size(); ++i) {
                switch (this.signs.get(i)) {
                    case MULTIPLY: {
                        val *= this.terms.get(i + 1).evaluate();
                        continue block4;
                    }
                    case DIVIDE: {
                        val /= this.terms.get(i + 1).evaluate();
                    }
                }
            }
            return val;
        }
    }

    private static class Expression {
        private List<Sign> signs;
        private List<Product> products;

        private Expression(List<Sign> signs, List<Product> products) {
            this.signs = signs;
            this.products = products;
        }

        public static Expression parse(StreamTokenizer tokenizer) throws CommandException, IOException {
            ArrayList<Sign> signs = new ArrayList<Sign>();
            ArrayList<Product> products = new ArrayList<Product>();
            products.add(Product.parse(tokenizer));
            while (true) {
                Sign sign;
                switch (tokenizer.nextToken()) {
                    case 43: {
                        sign = Sign.PLUS;
                        break;
                    }
                    case 45: {
                        sign = Sign.MINUS;
                        break;
                    }
                    default: {
                        tokenizer.pushBack();
                        return new Expression(signs, products);
                    }
                }
                signs.add(sign);
                products.add(Product.parse(tokenizer));
            }
        }

        public double evaluate() {
            double val = this.products.get(0).evaluate();
            block4: for (int i = 0; i < this.signs.size(); ++i) {
                switch (this.signs.get(i)) {
                    case PLUS: {
                        val += this.products.get(i + 1).evaluate();
                        continue block4;
                    }
                    case MINUS: {
                        val -= this.products.get(i + 1).evaluate();
                    }
                }
            }
            return val;
        }
    }
}

