/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import java.util.Collections;
import java.util.List;
import net.earthcomputer.clientcommands.EventManager;
import net.earthcomputer.clientcommands.TempRules;
import net.earthcomputer.clientcommands.command.ClientCommandBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.storage.WorldInfo;

public class CommandCWeather
extends ClientCommandBase {
    private static float mockingRainStrength;
    private static float mockingThunderStrength;
    private static float serverSideRainStrength;
    private static float serverSideThunderStrength;

    public String func_71517_b() {
        return "cweather";
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.cweather.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String subcommand = args.length == 0 ? "info" : args[0];
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        WorldInfo worldInfo = world.func_72912_H();
        switch (subcommand) {
            case "mock": {
                if (args.length < 2) {
                    throw new WrongUsageException("commands.cweather.mock.usage", new Object[0]);
                }
                switch (args[1]) {
                    case "clear": {
                        if (!TempRules.MOCKING_WEATHER.getValue().booleanValue()) {
                            serverSideRainStrength = world.func_72867_j(1.0f);
                            serverSideThunderStrength = world.func_72819_i(1.0f);
                        }
                        world.func_72894_k(0.0f);
                        world.func_147442_i(0.0f);
                        worldInfo.func_76084_b(false);
                        worldInfo.func_76069_a(false);
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.cweather.mock.clear.success", new Object[0]));
                        break;
                    }
                    case "rain": {
                        if (!TempRules.MOCKING_WEATHER.getValue().booleanValue()) {
                            serverSideRainStrength = world.func_72867_j(1.0f);
                            serverSideThunderStrength = world.func_72819_i(1.0f);
                        }
                        float strength = args.length < 3 ? 1.0f : (float)CommandCWeather.func_175756_a((String)args[2], (double)0.0, (double)1.0);
                        world.func_72894_k(strength);
                        world.func_147442_i(0.0f);
                        worldInfo.func_76084_b(true);
                        worldInfo.func_76069_a(false);
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.cweather.mock.rain.success", new Object[0]));
                        break;
                    }
                    case "thunder": {
                        if (!TempRules.MOCKING_WEATHER.getValue().booleanValue()) {
                            serverSideRainStrength = world.func_72867_j(1.0f);
                            serverSideThunderStrength = world.func_72819_i(1.0f);
                        }
                        float strength = args.length < 3 ? 1.0f : (float)CommandCWeather.func_175756_a((String)args[2], (double)0.0, (double)1.0);
                        world.func_72894_k(strength);
                        world.func_147442_i(strength);
                        worldInfo.func_76084_b(true);
                        worldInfo.func_76069_a(true);
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.cweather.mock.thunder.success", new Object[0]));
                        break;
                    }
                    default: {
                        throw new WrongUsageException("commands.cweather.mock.usage", new Object[0]);
                    }
                }
                TempRules.MOCKING_WEATHER.setValue(Boolean.TRUE);
                mockingRainStrength = world.func_72867_j(1.0f);
                mockingThunderStrength = world.func_72819_i(1.0f);
                break;
            }
            case "unmock": {
                TempRules.MOCKING_WEATHER.setValue(Boolean.FALSE);
                world.func_72894_k(serverSideRainStrength);
                world.func_147442_i(serverSideThunderStrength);
                worldInfo.func_76084_b(serverSideRainStrength != 0.0f);
                worldInfo.func_76069_a(serverSideThunderStrength != 0.0f);
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.cweather.unmock.success", new Object[0]));
                break;
            }
            case "info": {
                if (world.func_72819_i(1.0f) != 0.0f) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.cweather.info.thunder", new Object[]{Float.valueOf(world.func_72819_i(1.0f))}));
                    break;
                }
                if (world.func_72867_j(1.0f) != 0.0f) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.cweather.info.rain", new Object[]{Float.valueOf(world.func_72867_j(1.0f))}));
                    break;
                }
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.cweather.info.clear", new Object[0]));
                break;
            }
            default: {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 0) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            return CommandCWeather.func_71530_a((String[])args, (String[])new String[]{"mock", "unmock", "info"});
        }
        if ("mock".equals(args[0]) && args.length == 2) {
            return CommandCWeather.func_71530_a((String[])args, (String[])new String[]{"clear", "rain", "thunder"});
        }
        return Collections.emptyList();
    }

    static {
        EventManager.addInboundPacketPreListener(e -> {
            if (TempRules.MOCKING_WEATHER.getValue().booleanValue() && e.getPacket() instanceof SPacketChangeGameState) {
                SPacketChangeGameState packet = (SPacketChangeGameState)e.getPacket();
                int id = packet.func_149138_c();
                switch (id) {
                    case 1: 
                    case 2: {
                        e.setCanceled(true);
                        break;
                    }
                    case 7: {
                        serverSideRainStrength = packet.func_149137_d();
                        e.setCanceled(true);
                        break;
                    }
                    case 8: {
                        serverSideThunderStrength = packet.func_149137_d();
                        e.setCanceled(true);
                    }
                }
            }
        });
        EventManager.addConnectListener(e -> {
            if (TempRules.MOCKING_WEATHER.getValue().booleanValue()) {
                System.out.println("---------");
                System.out.println(mockingRainStrength);
                System.out.println(mockingThunderStrength);
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                WorldInfo worldInfo = world.func_72912_H();
                world.func_72894_k(mockingRainStrength);
                world.func_147442_i(mockingThunderStrength);
                worldInfo.func_76084_b(mockingRainStrength != 0.0f);
                worldInfo.func_76069_a(mockingThunderStrength != 0.0f);
            }
        });
    }
}

