/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import net.earthcomputer.clientcommands.command.ClientCommandBase;
import net.earthcomputer.clientcommands.cvw.ClientVirtualChunkLoader;
import net.earthcomputer.clientcommands.cvw.ServerConnector;
import net.earthcomputer.clientcommands.cvw.ServerConnectorCVW;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldSettings;

public class CommandCVW
extends ClientCommandBase {
    public String func_71517_b() {
        return "cvw";
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.cvw.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        switch (args[0]) {
            case "stop": {
                ServerConnector connector = ServerConnector.forCurrentServer();
                if (connector instanceof ServerConnectorCVW) {
                    connector.onDisconnectButtonPressed();
                    break;
                }
                throw new CommandException("commands.cvw.stop.notRunning", new Object[0]);
            }
            case "start": {
                GameType gameType;
                if (args.length < 2) {
                    gameType = GameType.CREATIVE;
                } else {
                    gameType = GameType.func_185328_a((String)args[1], (GameType)GameType.NOT_SET);
                    if (gameType == GameType.NOT_SET) {
                        gameType = WorldSettings.func_77161_a((int)CommandCVW.func_175764_a((String)args[1], (int)0, (int)(GameType.values().length - 2)));
                    }
                }
                CommandCVW.startCVW(gameType);
                break;
            }
            default: {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
        }
    }

    private static void startCVW(GameType gameType) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Long2ObjectMap<NBTTagCompound> chunks = ClientVirtualChunkLoader.generateChunkMap(world, world.func_72863_F());
        NBTTagCompound playerTag = Minecraft.func_71410_x().field_71439_g.func_189511_e(new NBTTagCompound());
        ServerConnector oldServer = ServerConnector.forCurrentServer();
        oldServer.disconnect();
        ServerConnectorCVW newServer = new ServerConnectorCVW(world.field_73011_w.getDimension(), gameType, oldServer, chunks, playerTag);
        newServer.connect();
    }
}

