/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.earthcomputer.clientcommands.EventManager;
import net.earthcomputer.clientcommands.TempRules;
import net.earthcomputer.clientcommands.command.ClientCommandBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketTimeUpdate;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class CommandCTime
extends ClientCommandBase {
    private static long lastMockedTime;
    private static boolean lastMockedDoDaylightCycle;

    public String func_71517_b() {
        return "ctime";
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.ctime.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            args = new String[]{"daytime"};
        }
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        ArrayList<String> lines = new ArrayList<String>();
        switch (args[0]) {
            case "daytime": {
                int daytime = (int)(world.func_72820_D() % 24000L);
                lines.add(I18n.func_135052_a((String)"commands.ctime.daytime", (Object[])new Object[]{daytime, LocalTime.of(daytime / 1000, daytime % 1000 * 60 / 1000).format(DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT))}));
                break;
            }
            case "day": {
                int day = (int)(world.func_72820_D() / 24000L % Integer.MAX_VALUE);
                lines.add(I18n.func_135052_a((String)"commands.ctime.day", (Object[])new Object[]{day}));
                break;
            }
            case "gametime": {
                int gametime = (int)(world.func_82737_E() % Integer.MAX_VALUE);
                lines.add(I18n.func_135052_a((String)"commands.ctime.gametime", (Object[])new Object[]{gametime, StatBase.field_75981_i.func_75843_a(gametime)}));
                break;
            }
            case "info": {
                int day = (int)(world.func_72820_D() / 24000L % Integer.MAX_VALUE);
                int daytime = (int)(world.func_72820_D() % 24000L);
                int gametime = (int)(world.func_82737_E() % Integer.MAX_VALUE);
                int moonPhase = day % 8;
                int skylightSubtracted = world.func_72967_a(1.0f);
                lines.add(I18n.func_135052_a((String)"commands.ctime.infoHeader", (Object[])new Object[0]));
                lines.add(I18n.func_135052_a((String)"commands.ctime.daytime", (Object[])new Object[]{daytime, LocalTime.of((daytime / 1000 + 6) % 24, daytime % 1000 * 60 / 1000).format(DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT))}));
                lines.add(I18n.func_135052_a((String)"commands.ctime.day", (Object[])new Object[]{day}));
                lines.add(I18n.func_135052_a((String)"commands.ctime.gametime", (Object[])new Object[]{gametime, StatBase.field_75981_i.func_75843_a(gametime)}));
                lines.add(I18n.func_135052_a((String)"commands.ctime.moon", (Object[])new Object[]{moonPhase, I18n.func_135052_a((String)("commands.ctime.moon." + moonPhase), (Object[])new Object[0])}));
                lines.add(I18n.func_135052_a((String)"commands.ctime.mobsBurn", (Object[])new Object[]{CommandCTime.formatBoolean(skylightSubtracted < 4)}));
                lines.add(I18n.func_135052_a((String)"commands.ctime.mobsSpawn", (Object[])new Object[]{CommandCTime.formatBoolean(15 - skylightSubtracted <= 7)}));
                lines.add(I18n.func_135052_a((String)"commands.ctime.doDaylightCycle", (Object[])new Object[]{CommandCTime.formatBoolean(world.func_82736_K().func_82766_b("doDaylightCycle"))}));
                break;
            }
            case "mock": {
                boolean doDaylightCycle;
                if (args.length < 2) {
                    throw new WrongUsageException("commands.ctime.mock.usage", new Object[0]);
                }
                int daytime = "day".equals(args[1]) ? 1000 : ("night".equals(args[1]) ? 13000 : ("noon".equals(args[1]) ? 6000 : ("midnight".equals(args[1]) ? 18000 : CommandCTime.func_180528_a((String)args[1], (int)0))));
                lines.add(I18n.func_135052_a((String)"commands.ctime.mock.success", (Object[])new Object[]{daytime}));
                boolean bl = doDaylightCycle = args.length < 3 ? true : Boolean.parseBoolean(args[2]);
                if (!doDaylightCycle && (daytime = -daytime) == 0) {
                    daytime = -1;
                }
                TempRules.MOCKING_TIME.setValue(Boolean.TRUE);
                world.func_72877_b((long)daytime);
                break;
            }
            case "unmock": {
                TempRules.MOCKING_TIME.setValue(Boolean.FALSE);
                lines.add(I18n.func_135052_a((String)"commands.ctime.unmock.success", (Object[])new Object[0]));
                break;
            }
            default: {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
        }
        for (String line : lines) {
            sender.func_145747_a((ITextComponent)new TextComponentString(line));
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 1) {
            return CommandCTime.func_71530_a((String[])args, (String[])new String[]{"daytime", "day", "gametime", "info", "mock", "unmock"});
        }
        if (args.length != 0 && "mock".equals(args[0])) {
            if (args.length == 2) {
                return CommandCTime.func_71530_a((String[])args, (String[])new String[]{"day", "night", "noon", "midnight"});
            }
            if (args.length == 3) {
                return CommandCTime.func_71530_a((String[])args, (String[])new String[]{"false", "true"});
            }
        }
        return Collections.emptyList();
    }

    private static String formatBoolean(boolean b) {
        if (b) {
            return TextFormatting.GREEN + "true";
        }
        return TextFormatting.RED + "false";
    }

    static {
        EventManager.addInboundPacketPreListener(e -> {
            Packet<?> packet = e.getPacket();
            if (packet instanceof SPacketTimeUpdate && TempRules.MOCKING_TIME.getValue().booleanValue()) {
                lastMockedTime = Minecraft.func_71410_x().field_71441_e.func_72820_D();
                lastMockedDoDaylightCycle = Minecraft.func_71410_x().field_71441_e.func_82736_K().func_82766_b("doDaylightCycle");
                e.setCanceled(true);
            }
        });
        EventManager.addConnectListener(e -> {
            if (TempRules.MOCKING_TIME.getValue().booleanValue()) {
                long worldTime = lastMockedTime;
                if (!lastMockedDoDaylightCycle && (worldTime = -worldTime) == 0L) {
                    worldTime = -1L;
                }
                Minecraft.func_71410_x().field_71441_e.func_72877_b(worldTime);
            }
        });
    }
}

