/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.earthcomputer.clientcommands.EnchantmentCracker;
import net.earthcomputer.clientcommands.command.ClientCommandBase;
import net.earthcomputer.clientcommands.task.TaskManager;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class CommandCEnchant
extends ClientCommandBase {
    public String func_71517_b() {
        return "cenchant";
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.cenchant.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 4) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        TaskManager.ensureNoTasks();
        Item item = CommandCEnchant.func_147179_f((ICommandSender)sender, (String)args[0]);
        Predicate<List<EnchantmentData>> enchantmentsPredicate = x -> true;
        for (int i = 1; i <= args.length - 3; i += 3) {
            int maxLevel;
            int minLevel;
            Enchantment en;
            try {
                en = Enchantment.func_185262_c((int)CommandCEnchant.func_180528_a((String)args[i + 1], (int)0));
            }
            catch (NumberInvalidException e) {
                en = Enchantment.func_180305_b((String)args[i + 1]);
            }
            if (en == null) {
                throw new CommandException("commands.cenchant.unknownEnchantment", new Object[]{args[i + 1]});
            }
            Enchantment enchantment = en;
            String strLevel = args[i + 2];
            if (strLevel.contains("..")) {
                String[] parts = strLevel.split("\\.\\.", 2);
                minLevel = CommandCEnchant.func_175764_a((String)parts[0], (int)1, (int)enchantment.func_77325_b());
                maxLevel = CommandCEnchant.func_175764_a((String)parts[1], (int)minLevel, (int)enchantment.func_77325_b());
            } else {
                minLevel = maxLevel = CommandCEnchant.func_175764_a((String)strLevel, (int)1, (int)enchantment.func_77325_b());
            }
            Predicate<EnchantmentData> predicate = ench -> ench.field_76302_b == enchantment && ench.field_76303_c >= minLevel && ench.field_76303_c <= maxLevel;
            if ("with".equals(args[i])) {
                enchantmentsPredicate = enchantmentsPredicate.and(list -> list.stream().anyMatch(predicate));
                continue;
            }
            if ("without".equals(args[i])) {
                enchantmentsPredicate = enchantmentsPredicate.and(list -> list.stream().noneMatch(predicate));
                continue;
            }
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        EnchantmentCracker.EnchantManipulationStatus status = EnchantmentCracker.manipulateEnchantments(item, enchantmentsPredicate);
        if (status != EnchantmentCracker.EnchantManipulationStatus.OK) {
            throw new CommandException(status.getTranslation(), new Object[0]);
        }
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.cenchant.success", new Object[0]));
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 0) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            return CommandCEnchant.func_175762_a((String[])args, (Collection)Item.field_150901_e.func_148742_b());
        }
        switch (args.length % 3) {
            case 2: {
                return CommandCEnchant.func_71530_a((String[])args, (String[])new String[]{"with", "without"});
            }
            case 0: {
                Item item;
                try {
                    item = CommandCEnchant.func_147179_f((ICommandSender)sender, (String)args[0]);
                }
                catch (NumberInvalidException e) {
                    return Collections.emptyList();
                }
                ItemStack stack = new ItemStack(item);
                ArrayList<Enchantment> applicableEnchantments = new ArrayList<Enchantment>();
                for (Enchantment ench : Enchantment.field_185264_b) {
                    if (ench.func_185261_e() || !ench.canApplyAtEnchantingTable(stack) && (item != Items.field_151122_aG || !ench.isAllowedOnBooks())) continue;
                    applicableEnchantments.add(ench);
                }
                return CommandCEnchant.func_175762_a((String[])args, (Collection)applicableEnchantments.stream().map(arg_0 -> ((RegistryNamespaced)Enchantment.field_185264_b).func_177774_c(arg_0)).collect(Collectors.toList()));
            }
        }
        return Collections.emptyList();
    }
}

