/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.earthcomputer.clientcommands.command.ClientCommandBase;
import net.earthcomputer.clientcommands.network.NetUtils;
import net.earthcomputer.clientcommands.util.Box;
import net.minecraft.util.math.BlockPos;
import org.lwjgl.util.Rectangle;

public abstract class CommandAreaExtension
extends ClientCommandBase {
    private static final int CUBE_SIDE = 32;
    private static final int CUBE_VOLUME = 32768;

    protected void areaExecute(BlockPos from, BlockPos to, Object[] extraArgs) {
        int minX = Math.min(from.func_177958_n(), to.func_177958_n());
        int minY = Math.min(from.func_177956_o(), to.func_177956_o());
        int minZ = Math.min(from.func_177952_p(), to.func_177952_p());
        int maxX = Math.max(from.func_177958_n(), to.func_177958_n());
        int maxY = Math.max(from.func_177956_o(), to.func_177956_o());
        int maxZ = Math.max(from.func_177952_p(), to.func_177952_p());
        from = new BlockPos(minX, minY, minZ);
        to = new BlockPos(maxX, maxY, maxZ);
        int xSize = to.func_177958_n() - from.func_177958_n() + 1;
        int ySize = to.func_177956_o() - from.func_177956_o() + 1;
        int zSize = to.func_177952_p() - from.func_177952_p() + 1;
        int cubeXCount = xSize / 32;
        int cubeYCount = ySize / 32;
        int cubeZCount = zSize / 32;
        int remainingXSize = xSize % 32;
        int remainingYSize = ySize % 32;
        int remainingZSize = zSize % 32;
        int remainingXStart = xSize - remainingXSize;
        int remainingYStart = ySize - remainingYSize;
        int remainingZStart = zSize - remainingZSize;
        for (int cubeY = 0; cubeY < cubeYCount; ++cubeY) {
            for (int cubeX = 0; cubeX < cubeXCount; ++cubeX) {
                for (int cubeZ = 0; cubeZ < cubeZCount; ++cubeZ) {
                    BlockPos cubeCorner = from.func_177982_a(cubeX * 32, cubeY * 32, cubeZ * 32);
                    NetUtils.sendChatMessage(this.makeCommand(cubeCorner, cubeCorner.func_177982_a(31, 31, 31), extraArgs));
                }
            }
        }
        List<Box> fullSquareSolution = CommandAreaExtension.toBoxY(this.solve2D(remainingYSize, xSize, zSize), remainingYStart, remainingYSize);
        List<Box> longSolution = CommandAreaExtension.toBoxX(this.solve2D(remainingXSize, zSize, remainingYStart), remainingXStart, remainingXSize);
        List<Box> shortSolution = CommandAreaExtension.toBoxZ(this.solve2D(remainingZSize, remainingXStart, remainingYStart), remainingZStart, remainingZSize);
        ArrayList<Box> curSolution = new ArrayList<Box>();
        curSolution.addAll(fullSquareSolution);
        curSolution.addAll(longSolution);
        curSolution.addAll(shortSolution);
        ArrayList<Box> bestSolution = curSolution;
        longSolution = CommandAreaExtension.toBoxZ(this.solve2D(remainingZSize, xSize, remainingYStart), remainingZStart, remainingZSize);
        shortSolution = CommandAreaExtension.toBoxX(this.solve2D(remainingXSize, remainingZStart, remainingYStart), remainingXStart, remainingXSize);
        curSolution = new ArrayList();
        curSolution.addAll(fullSquareSolution);
        curSolution.addAll(longSolution);
        curSolution.addAll(shortSolution);
        if (curSolution.size() < bestSolution.size()) {
            bestSolution = curSolution;
        }
        fullSquareSolution = CommandAreaExtension.toBoxX(this.solve2D(remainingXSize, zSize, ySize), remainingXStart, remainingXSize);
        longSolution = CommandAreaExtension.toBoxY(this.solve2D(remainingYSize, remainingXStart, zSize), remainingYStart, remainingYSize);
        shortSolution = CommandAreaExtension.toBoxZ(this.solve2D(remainingZSize, remainingXStart, remainingYStart), remainingZStart, remainingZSize);
        curSolution = new ArrayList();
        curSolution.addAll(longSolution);
        curSolution.addAll(fullSquareSolution);
        curSolution.addAll(shortSolution);
        if (curSolution.size() < bestSolution.size()) {
            bestSolution = curSolution;
        }
        longSolution = CommandAreaExtension.toBoxZ(this.solve2D(remainingZSize, remainingXStart, ySize), remainingZStart, remainingZSize);
        shortSolution = CommandAreaExtension.toBoxY(this.solve2D(remainingYSize, remainingXStart, remainingZStart), remainingYStart, remainingYSize);
        curSolution = new ArrayList();
        curSolution.addAll(shortSolution);
        curSolution.addAll(fullSquareSolution);
        curSolution.addAll(longSolution);
        if (curSolution.size() < bestSolution.size()) {
            bestSolution = curSolution;
        }
        fullSquareSolution = CommandAreaExtension.toBoxZ(this.solve2D(remainingZSize, xSize, ySize), remainingZStart, remainingZSize);
        longSolution = CommandAreaExtension.toBoxX(this.solve2D(remainingXSize, remainingZStart, ySize), remainingXStart, remainingXSize);
        shortSolution = CommandAreaExtension.toBoxY(this.solve2D(remainingYSize, remainingXStart, remainingZStart), remainingYStart, remainingYSize);
        curSolution = new ArrayList();
        curSolution.addAll(shortSolution);
        curSolution.addAll(fullSquareSolution);
        curSolution.addAll(longSolution);
        if (curSolution.size() < bestSolution.size()) {
            bestSolution = curSolution;
        }
        longSolution = CommandAreaExtension.toBoxY(this.solve2D(remainingYSize, xSize, remainingZStart), remainingYStart, remainingYSize);
        shortSolution = CommandAreaExtension.toBoxX(this.solve2D(remainingXSize, remainingZStart, remainingYStart), remainingXStart, remainingXSize);
        curSolution = new ArrayList();
        curSolution.addAll(longSolution);
        curSolution.addAll(fullSquareSolution);
        curSolution.addAll(shortSolution);
        if (curSolution.size() < bestSolution.size()) {
            bestSolution = curSolution;
        }
        for (Box box : bestSolution) {
            BlockPos corner = from.func_177982_a(box.getX(), box.getY(), box.getZ());
            NetUtils.sendChatMessage(this.makeCommand(corner, corner.func_177982_a(box.getXSize() - 1, box.getYSize() - 1, box.getZSize() - 1), extraArgs));
        }
    }

    private List<Rectangle> solve2D(int depth, int width, int height) {
        int rectHeightRight;
        int tmp;
        if (depth == 0) {
            return Collections.emptyList();
        }
        int maxArea = 32768 / depth;
        int rectWidth = (int)Math.sqrt(maxArea);
        int rectHeight = maxArea / rectWidth;
        if (rectWidth >= width) {
            if (rectHeight >= height) {
                return Collections.singletonList(new Rectangle(0, 0, width, height));
            }
            if (rectWidth < rectHeight) {
                tmp = rectWidth;
                rectWidth = rectHeight;
                rectHeight = tmp;
            }
        } else if (rectHeight < rectWidth) {
            tmp = rectWidth;
            rectWidth = rectHeight;
            rectHeight = tmp;
        }
        ArrayList<Rectangle> rects = new ArrayList<Rectangle>();
        int rectXCount = width / rectWidth;
        int rectYCount = height / rectHeight;
        int remainingWidth = width % rectWidth;
        int remainingHeight = height % rectHeight;
        int remainingXStart = width - remainingWidth;
        int remainingYStart = height - remainingHeight;
        for (int rectY = 0; rectY < rectYCount; ++rectY) {
            for (int rectX = 0; rectX < rectXCount; ++rectX) {
                rects.add(new Rectangle(rectX * rectWidth, rectY * rectHeight, rectWidth, rectHeight));
            }
        }
        int rectWidthBottom = remainingHeight == 0 ? Integer.MAX_VALUE : maxArea / remainingHeight;
        int n = rectHeightRight = remainingWidth == 0 ? Integer.MAX_VALUE : maxArea / remainingWidth;
        if (remainingYStart % rectHeightRight == 0 || remainingYStart * rectWidthBottom + width * rectHeightRight < height * rectWidthBottom + remainingXStart * rectHeightRight) {
            for (int y = 0; y < remainingYStart; y += rectHeightRight) {
                rects.add(new Rectangle(remainingXStart, y, remainingWidth, Math.min(rectHeightRight, remainingYStart - y)));
            }
            for (int x = 0; x < width; x += rectWidthBottom) {
                rects.add(new Rectangle(x, remainingYStart, Math.min(rectWidthBottom, width - x), remainingHeight));
            }
        } else {
            for (int y = 0; y < remainingYStart; y += rectHeightRight) {
                rects.add(new Rectangle(remainingXStart, y, remainingWidth, Math.min(rectHeightRight, height - y)));
            }
            for (int x = 0; x < remainingWidth; x += rectWidthBottom) {
                rects.add(new Rectangle(x, remainingYStart, Math.min(rectWidthBottom, remainingXStart - x), remainingHeight));
            }
        }
        return rects;
    }

    private static List<Box> toBoxX(List<Rectangle> rects, int remainingXStart, int remainingXSize) {
        return rects.stream().map(rect -> new Box(remainingXStart, rect.getY(), rect.getX(), remainingXSize, rect.getHeight(), rect.getWidth())).filter(box -> !box.isEmpty()).collect(Collectors.toList());
    }

    private static List<Box> toBoxY(List<Rectangle> rects, int remainingYStart, int remainingYSize) {
        return rects.stream().map(rect -> new Box(rect.getX(), remainingYStart, rect.getY(), rect.getWidth(), remainingYSize, rect.getHeight())).filter(box -> !box.isEmpty()).collect(Collectors.toList());
    }

    private static List<Box> toBoxZ(List<Rectangle> rects, int remainingZStart, int remainingZSize) {
        return rects.stream().map(rect -> new Box(rect.getX(), rect.getY(), remainingZStart, rect.getWidth(), rect.getHeight(), remainingZSize)).filter(box -> !box.isEmpty()).collect(Collectors.toList());
    }

    protected abstract String makeCommand(BlockPos var1, BlockPos var2, Object[] var3);
}

