/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import net.earthcomputer.clientcommands.WorldEditSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSenderWrapper;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.client.IClientCommand;

public abstract class ClientCommandBase
extends CommandBase
implements IClientCommand {
    protected static ICommandSender correctSender(final ICommandSender sender) {
        return new CommandSenderWrapper(sender, sender.func_174791_d(), sender.func_180425_c().func_177963_a(-0.5, 0.0, -0.5), 0, sender.func_174793_f(), true){

            public boolean func_70003_b(int permLevel, String commandName) {
                return sender.func_70003_b(permLevel, commandName);
            }
        };
    }

    public boolean func_184882_a(MinecraftServer p_checkPermission_1_, ICommandSender p_checkPermission_2_) {
        return true;
    }

    public boolean allowUsageWithoutPrefix(ICommandSender arg0, String arg1) {
        return false;
    }

    protected static void ensureCreativeMode() throws CommandException {
        if (!Minecraft.func_71410_x().field_71442_b.func_78758_h()) {
            throw new CommandException("commands.client.notCreative", new Object[0]);
        }
    }

    protected static ITextComponent getCoordsTextComponent(BlockPos pos) {
        TextComponentTranslation text = new TextComponentTranslation("commands.client.blockpos", new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
        text.func_150256_b().func_150228_d(Boolean.valueOf(true));
        text.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/clook block %d %d %d", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())));
        text.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(String.format("/clook block %d %d %d", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()))));
        return text;
    }

    protected static SelectionInfo parseSelectionInfo(ICommandSender sender, String[] args, int index) throws CommandException {
        try {
            if ("selection".equals(args[index])) {
                if (WorldEditSettings.hasSelection()) {
                    return new SelectionInfo(WorldEditSettings.getSelectFrom(), WorldEditSettings.getSelectTo(), 1);
                }
                throw new CommandException("commands.generic.noSelection", new Object[0]);
            }
            BlockPos from = ClientCommandBase.func_175757_a((ICommandSender)sender, (String[])args, (int)index, (boolean)false);
            BlockPos to = ClientCommandBase.func_175757_a((ICommandSender)sender, (String[])args, (int)(index + 3), (boolean)false);
            return new SelectionInfo(from, to, 6);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new CommandException("commands.generic.invalidSelection", new Object[0]);
        }
    }

    public static class SelectionInfo {
        public BlockPos from;
        public BlockPos to;
        public int argLen;

        public SelectionInfo(BlockPos from, BlockPos to, int argLen) {
            this.from = from;
            this.to = to;
            this.argLen = argLen;
        }
    }
}

