/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.earthcomputer.clientcommands.EventManager;
import net.earthcomputer.clientcommands.network.NetUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCommandBlock;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockStructure;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketEntityAction;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.client.CPacketPlayerTryUseItem;
import net.minecraft.network.play.client.CPacketPlayerTryUseItemOnBlock;
import net.minecraft.network.play.client.CPacketUseEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ToolDamageManager {
    private static List<Class<? extends Packet<?>>> packetsToBlock = new ArrayList();
    private static int timesToBlockUseItem = 0;
    private static int timesToBlockStopUseItem = 0;
    private static int timesToBlockAttackEntity = 0;
    private static int timesToBlockUseEntity = 0;

    private ToolDamageManager() {
    }

    public static void registerEvents() {
        EventManager.addOutboundPacketPreListener(e -> {
            Iterator<Class<Packet<?>>> packetItr = packetsToBlock.iterator();
            while (packetItr.hasNext()) {
                if (!packetItr.next().isInstance(e.getPacket())) continue;
                e.setCanceled(true);
                packetItr.remove();
                return;
            }
        });
        EventManager.addPlayerTickListener(e -> {
            ItemStack elytra;
            EntityPlayer player = e.player;
            if (player.func_184613_cA() && !(elytra = player.field_71071_by.func_70440_f(2)).func_190926_b() && elytra.func_77973_b() == Items.field_185160_cR && ToolDamageManager.postToolDamaged(player, elytra, 1)) {
                NetUtils.sendPacket(new CPacketEntityAction((Entity)player, CPacketEntityAction.Action.START_FALL_FLYING));
            }
        });
        EventManager.addUseBlockListener(e -> {
            ItemStack stack = e.getItemStack();
            if (stack.func_190926_b()) {
                return;
            }
            Item item = stack.func_77973_b();
            IBlockState state = e.getWorld().func_180495_p(e.getPos());
            if (state.func_177230_c() == Blocks.field_150335_W && item == Items.field_151033_d) {
                if (ToolDamageManager.postToolDamaged(e.getEntityPlayer(), stack, 1)) {
                    e.setCanceled(true);
                    packetsToBlock.add(CPacketPlayerTryUseItemOnBlock.class);
                }
                return;
            }
            if (e.getEntityPlayer().func_175151_a(e.getPos().func_177972_a(e.getFace()), e.getFace(), stack)) {
                if (item instanceof ItemHoe) {
                    boolean usedHoe = false;
                    if (state.func_177230_c() == Blocks.field_150349_c || state.func_177230_c() == Blocks.field_185774_da) {
                        usedHoe = true;
                    } else if (state.func_177230_c() == Blocks.field_150346_d) {
                        BlockDirt.DirtType variant = (BlockDirt.DirtType)state.func_177229_b((IProperty)BlockDirt.field_176386_a);
                        boolean bl = usedHoe = variant == BlockDirt.DirtType.DIRT || variant == BlockDirt.DirtType.COARSE_DIRT;
                    }
                    if (usedHoe && ToolDamageManager.postToolDamaged(e.getEntityPlayer(), stack, 1)) {
                        e.setCanceled(true);
                        packetsToBlock.add(CPacketPlayerTryUseItemOnBlock.class);
                    }
                    return;
                }
                if (item == Items.field_151033_d) {
                    if (ToolDamageManager.postToolDamaged(e.getEntityPlayer(), stack, 1)) {
                        e.setCanceled(true);
                        packetsToBlock.add(CPacketPlayerTryUseItemOnBlock.class);
                    }
                    return;
                }
                if (item instanceof ItemSpade && e.getFace() != EnumFacing.DOWN && e.getWorld().func_180495_p(e.getPos().func_177984_a()).func_185904_a() == Material.field_151579_a && e.getWorld().func_180495_p(e.getPos()).func_177230_c() == Blocks.field_150349_c) {
                    if (ToolDamageManager.postToolDamaged(e.getEntityPlayer(), stack, 1)) {
                        e.setCanceled(true);
                        packetsToBlock.add(CPacketPlayerTryUseItemOnBlock.class);
                    }
                    return;
                }
            }
        });
        EventManager.addAttackBlockListener(e -> {
            if (!Minecraft.func_71410_x().field_71442_b.func_78758_h()) {
                IBlockState hitState = e.getWorld().func_180495_p(e.getPos());
                int damage = ToolDamageManager.getDestroyBlockDamage(e.getWorld(), e.getPos(), e.getEntityPlayer());
                if (damage != 0) {
                    if (ToolDamageManager.postToolDamagedPre(e.getEntityPlayer(), e.getItemStack(), damage)) {
                        e.setCanceled(true);
                        packetsToBlock.add(CPacketPlayerDigging.class);
                    } else if (hitState.func_185904_a() != Material.field_151579_a && hitState.func_185903_a(e.getEntityPlayer(), e.getWorld(), e.getPos()) >= 1.0f) {
                        ToolDamageManager.postToolDamagedPost(e.getEntityPlayer(), e.getItemStack(), damage);
                    }
                }
            }
        });
        EventManager.addOutboundPacketPreListener(e -> {
            Packet<?> packet = e.getPacket();
            if (packet instanceof CPacketPlayerTryUseItem) {
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                CPacketPlayerTryUseItem useItem = (CPacketPlayerTryUseItem)packet;
                ItemStack stack = player.func_184586_b(useItem.func_187028_a());
                if (stack.func_190926_b()) {
                    return;
                }
                Item item = stack.func_77973_b();
                if (player.func_184811_cZ().func_185141_a(item)) {
                    return;
                }
                if (item == Items.field_151146_bM) {
                    if (ToolDamageManager.postToolDamaged((EntityPlayer)player, stack, 7)) {
                        e.setCanceled(true);
                        ++timesToBlockUseItem;
                    }
                    return;
                }
                if (item instanceof ItemFishingRod) {
                    if (ToolDamageManager.postToolDamaged((EntityPlayer)player, stack, 5)) {
                        e.setCanceled(true);
                        ++timesToBlockUseItem;
                    }
                    return;
                }
            } else if (packet instanceof CPacketUseEntity) {
                CPacketUseEntity useEntity = (CPacketUseEntity)packet;
                if (Minecraft.func_71410_x().field_71442_b.func_78747_a()) {
                    return;
                }
                if (useEntity.func_149565_c() == CPacketUseEntity.Action.ATTACK) {
                    EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                    ItemStack stack = player.func_184614_ca();
                    if (stack.func_190926_b()) {
                        return;
                    }
                    Item item = stack.func_77973_b();
                    int damage = 0;
                    if (item instanceof ItemSword || item instanceof ItemHoe) {
                        damage = 1;
                    } else if (item instanceof ItemTool) {
                        damage = 2;
                    }
                    if (damage != 0 && ToolDamageManager.postToolDamaged((EntityPlayer)player, stack, damage)) {
                        e.setCanceled(true);
                        ++timesToBlockAttackEntity;
                    }
                } else if (useEntity.func_149565_c() == CPacketUseEntity.Action.INTERACT) {
                    boolean isDamagingItem = false;
                    EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                    ItemStack stack = player.func_184586_b(useEntity.func_186994_b());
                    if (stack.func_190926_b()) {
                        return;
                    }
                    Item item = stack.func_77973_b();
                    Entity target = useEntity.func_149564_a((World)Minecraft.func_71410_x().field_71441_e);
                    if (item instanceof ItemShears) {
                        if (target instanceof IShearable && ((IShearable)target).isShearable(stack, (IBlockAccess)target.field_70170_p, new BlockPos(target))) {
                            isDamagingItem = true;
                        }
                    } else if (item == Items.field_151033_d && target instanceof EntityCreeper) {
                        isDamagingItem = true;
                    }
                    if (isDamagingItem) {
                        if (ToolDamageManager.postToolDamaged((EntityPlayer)player, stack, 1)) {
                            e.setCanceled(true);
                            ++timesToBlockUseEntity;
                        }
                        return;
                    }
                }
            } else if (packet instanceof CPacketPlayerDigging) {
                CPacketPlayerDigging playerDigging = (CPacketPlayerDigging)packet;
                if (playerDigging.func_180762_c() == CPacketPlayerDigging.Action.RELEASE_USE_ITEM) {
                    EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                    if (player.field_71075_bZ.field_75098_d) {
                        return;
                    }
                    ItemStack stack = player.func_184607_cu();
                    if (stack.func_190926_b()) {
                        return;
                    }
                    Item item = stack.func_77973_b();
                    if (item instanceof ItemBow) {
                        boolean hasAmmo = false;
                        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                            ItemStack arrow = player.field_71071_by.func_70301_a(i);
                            if (arrow.func_190926_b() || !(arrow.func_77973_b() instanceof ItemArrow)) continue;
                            hasAmmo = true;
                            break;
                        }
                        int charge = stack.func_77988_m() - player.func_184605_cv();
                        if (hasAmmo && (double)ItemBow.func_185059_b((int)charge) >= 0.1 && ToolDamageManager.postToolDamaged((EntityPlayer)player, stack, 1)) {
                            e.setCanceled(true);
                            ++timesToBlockStopUseItem;
                        }
                    }
                } else if (playerDigging.func_180762_c() == CPacketPlayerDigging.Action.STOP_DESTROY_BLOCK) {
                    Minecraft mc = Minecraft.func_71410_x();
                    int damage = ToolDamageManager.getDestroyBlockDamage((World)mc.field_71441_e, playerDigging.func_179715_a(), (EntityPlayer)mc.field_71439_g);
                    if (damage != 0) {
                        ToolDamageManager.postToolDamagedPost((EntityPlayer)mc.field_71439_g, mc.field_71439_g.func_184614_ca(), damage);
                    }
                }
            }
        });
        EventManager.addUseItemListener(e -> {
            if (timesToBlockUseItem > 0) {
                --timesToBlockUseItem;
                e.setCanceled(true);
            }
        });
        EventManager.addStopUseItemListener(e -> {
            if (timesToBlockStopUseItem > 0) {
                --timesToBlockStopUseItem;
                e.setCanceled(true);
            }
        });
        EventManager.addAttackEntityListener(e -> {
            if (timesToBlockAttackEntity > 0) {
                --timesToBlockAttackEntity;
                e.setCanceled(true);
            }
        });
        EventManager.addUseEntityListener(e -> {
            if (timesToBlockUseEntity > 0) {
                --timesToBlockUseEntity;
                e.setCanceled(true);
            }
        });
    }

    private static int getDestroyBlockDamage(World world, BlockPos pos, EntityPlayer player) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        ItemStack stack = player.func_184614_ca();
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71442_b.func_178889_l().func_82752_c()) {
            if (mc.field_71442_b.func_178889_l() == GameType.SPECTATOR) {
                return 0;
            }
            if (!player.func_175142_cm()) {
                if (stack.func_190926_b()) {
                    return 0;
                }
                if (!stack.func_179544_c(block)) {
                    return 0;
                }
            }
        }
        if (block instanceof BlockCommandBlock || block instanceof BlockStructure) {
            return 0;
        }
        if (state.func_185904_a() == Material.field_151579_a) {
            return 0;
        }
        if (!stack.func_190926_b()) {
            Item item = stack.func_77973_b();
            if (item instanceof ItemShears) {
                return 1;
            }
            if ((item instanceof ItemSword || item instanceof ItemTool) && world.func_180495_p(pos).func_185887_b(world, pos) != 0.0f) {
                return item instanceof ItemSword ? 2 : 1;
            }
        }
        return 0;
    }

    private static boolean postToolDamaged(EntityPlayer player, ItemStack stack, int damageAmount) {
        if (ToolDamageManager.postToolDamagedPre(player, stack, damageAmount)) {
            return true;
        }
        ToolDamageManager.postToolDamagedPost(player, stack, damageAmount);
        return false;
    }

    private static boolean postToolDamagedPre(EntityPlayer player, ItemStack stack, int damageAmount) {
        return MinecraftForge.EVENT_BUS.post((Event)new ToolDamagedEvent.Pre(player, stack, damageAmount));
    }

    private static void postToolDamagedPost(EntityPlayer player, ItemStack stack, int damageAmount) {
        MinecraftForge.EVENT_BUS.post((Event)new ToolDamagedEvent.Post(player, stack, damageAmount));
    }

    public static class ToolDamagedEvent
    extends PlayerEvent {
        private ItemStack stack;
        private int damageAmount;

        public ToolDamagedEvent(EntityPlayer player, ItemStack stack, int damageAmount) {
            super(player);
            this.stack = stack;
            this.damageAmount = damageAmount;
        }

        public ItemStack getItemStack() {
            return this.stack;
        }

        public int getDamageAmount() {
            return this.damageAmount;
        }

        public static class Post
        extends ToolDamagedEvent {
            public Post(EntityPlayer player, ItemStack stack, int damageAmount) {
                super(player, stack, damageAmount);
            }
        }

        @Cancelable
        public static class Pre
        extends ToolDamagedEvent {
            public Pre(EntityPlayer player, ItemStack stack, int damageAmount) {
                super(player, stack, damageAmount);
            }
        }
    }
}

