/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import net.earthcomputer.clientcommands.EnchantmentCracker;
import net.earthcomputer.clientcommands.EventManager;
import net.earthcomputer.clientcommands.TempRules;
import net.earthcomputer.clientcommands.WorldEditSettings;
import net.earthcomputer.clientcommands.network.NetUtils;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentDurability;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class TempRulesImpl {
    private static AtomicBoolean isDesynced = new AtomicBoolean(false);
    private static List<BlockPos> blocksToUpdate = new ArrayList<BlockPos>();

    private TempRulesImpl() {
    }

    public static void registerEvents() {
        TempRulesImpl.initBlockReachDistance();
        TempRulesImpl.initToolBreakProtection();
        TempRulesImpl.initGhostBlockFix();
        TempRulesImpl.initAxeWand();
        TempRulesImpl.initIniniteTools();
    }

    private static void initBlockReachDistance() {
        TempRules.BLOCK_REACH_DISTANCE.addValueChangeListener(e -> Minecraft.func_71410_x().field_71439_g.func_110140_aT().func_111151_a(EntityPlayer.REACH_DISTANCE).func_111128_a(((Double)e.getNewValue()).doubleValue()));
    }

    private static void initToolBreakProtection() {
        EventManager.addPlayerTickListener(e -> {
            if (isDesynced.getAndSet(false)) {
                NetUtils.resyncInventory(slot -> slot.field_75224_c == Minecraft.func_71410_x().field_71439_g.field_71071_by);
            }
        });
        EventManager.addPreDamageItemListener(e -> {
            if (TempRules.TOOL_BREAK_PROTECTION.getValue().booleanValue() && e.getItemStack().func_77952_i() + e.getDamageAmount() > e.getItemStack().func_77958_k()) {
                e.setCanceled(true);
                Minecraft.func_71410_x().field_71456_v.func_110326_a(I18n.func_135052_a((String)"tempRules.toolBreakProtection.protected", (Object[])new Object[0]), false);
            }
        });
        EventManager.addPostDamageItemListener(e -> {
            if (TempRules.TOOL_BREAK_PROTECTION.getValue().booleanValue()) {
                e.getItemStack().func_77964_b(e.getItemStack().func_77952_i() + e.getDamageAmount());
                if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)e.getItemStack()) > 0) {
                    isDesynced.set(true);
                }
            }
        });
    }

    private static void initGhostBlockFix() {
        EventManager.addAttackBlockListener(e -> {
            if (TempRules.GHOST_BLOCK_FIX.getValue().booleanValue()) {
                boolean canInstaMine;
                PlayerControllerMP controller = Minecraft.func_71410_x().field_71442_b;
                IBlockState state = e.getWorld().func_180495_p(e.getPos());
                boolean bl = canInstaMine = state.func_185904_a() != Material.field_151579_a && state.func_185903_a(e.getEntityPlayer(), e.getWorld(), e.getPos()) >= 1.0f;
                if (controller.func_78762_g() && canInstaMine) {
                    blocksToUpdate.add(e.getPos());
                }
            }
        });
        EventManager.addPlayerTickListener(e -> {
            if (!blocksToUpdate.isEmpty()) {
                for (BlockPos pos : blocksToUpdate) {
                    NetUtils.sendPacket(new CPacketPlayerDigging(CPacketPlayerDigging.Action.ABORT_DESTROY_BLOCK, pos, EnumFacing.DOWN));
                }
                blocksToUpdate.clear();
            }
        });
    }

    private static void initAxeWand() {
        EventManager.addUseItemListener(e -> {
            if (WorldEditSettings.isWand(e.getItemStack())) {
                RayTraceResult rayTrace = Minecraft.func_71410_x().field_71476_x;
                BlockPos pos = rayTrace.field_72313_a == RayTraceResult.Type.BLOCK ? rayTrace.func_178782_a() : new BlockPos((Entity)Minecraft.func_71410_x().field_71439_g);
                WorldEditSettings.setSelectTo(pos);
                e.setCanceled(true);
            }
        });
        EventManager.addAttackAirListener(e -> {
            if (WorldEditSettings.isWand(e.getItemStack())) {
                WorldEditSettings.setSelectFrom(e.getPos());
            }
        });
        EventManager.addAttackBlockListener(e -> {
            if (WorldEditSettings.isWand(e.getItemStack())) {
                WorldEditSettings.setSelectFrom(e.getPos());
                EventManager.addEndTickListener(new EventManager.Listener<TickEvent.ClientTickEvent>(){

                    @Override
                    public void accept(TickEvent.ClientTickEvent e) {
                        Minecraft.func_71410_x().field_71442_b.func_78767_c();
                    }

                    @Override
                    public boolean wasFinalAction() {
                        return true;
                    }
                });
                e.setCanceled(true);
            }
        });
    }

    private static void initIniniteTools() {
        EventManager.addPreDamageItemListener(e -> {
            EnchantmentCracker.EnchantManipulationStatus status;
            int unbreakingLvl;
            if (TempRules.INFINITE_TOOLS.getValue().booleanValue() && (unbreakingLvl = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)e.getItemStack())) > 0 && (status = EnchantmentCracker.throwItemsUntil(rand -> {
                for (int i = 0; i < e.getDamageAmount(); ++i) {
                    if (EnchantmentDurability.func_92097_a((ItemStack)e.getItemStack(), (int)unbreakingLvl, (Random)rand)) continue;
                    return false;
                }
                return true;
            })) != EnchantmentCracker.EnchantManipulationStatus.OK) {
                Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentString(TextFormatting.RED + I18n.func_135052_a((String)status.getTranslation(), (Object[])new Object[0])));
            }
        });
    }
}

