/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.earthcomputer.clientcommands.EnchantmentCracker;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.util.IStringSerializable;

public class TempRules {
    private static Map<String, Rule<?>> rules = new HashMap();
    public static final Rule<Boolean> ENCHANTING_PREDICTION = TempRules.registerRule("enchantingPrediction", DataType.BOOLEAN, Boolean.FALSE);
    public static final Rule<EnchantmentCracker.EnumCrackState> ENCHANTING_CRACK_STATE = TempRules.registerRule("enchantingCrackState", EnumDataType.of(EnchantmentCracker.EnumCrackState.class), EnchantmentCracker.EnumCrackState.UNCRACKED).setReadOnly();
    public static final Rule<Double> BLOCK_REACH_DISTANCE = TempRules.registerRule("blockReachDistance", DataType.DOUBLE.min(0.0), 5.0);
    public static final Rule<Boolean> TOOL_BREAK_PROTECTION = TempRules.registerRule("toolBreakProtection", DataType.BOOLEAN, Boolean.FALSE);
    public static final Rule<Boolean> MOCKING_TIME = TempRules.registerRule("mockingTime", DataType.BOOLEAN, Boolean.FALSE).setReadOnly();
    public static final Rule<Boolean> MOCKING_WEATHER = TempRules.registerRule("mockingWeather", DataType.BOOLEAN, Boolean.FALSE).setReadOnly();
    public static final Rule<Boolean> GHOST_BLOCK_FIX = TempRules.registerRule("ghostBlockFix", DataType.BOOLEAN, Boolean.FALSE);
    public static final Rule<Double> CALC_ANSWER = TempRules.registerRule("calcAns", DataType.DOUBLE, 0.0).setReadOnly();
    public static final Rule<Boolean> INFINITE_TOOLS = TempRules.registerRule("infiniteTools", DataType.BOOLEAN, Boolean.FALSE);

    public static boolean hasRule(String name) {
        return rules.containsKey(name);
    }

    public static Rule<?> getRule(String name) {
        return rules.get(name);
    }

    public static Collection<Rule<?>> getRules() {
        return rules.values();
    }

    public static List<String> getRuleNames() {
        return rules.keySet().stream().sorted().collect(Collectors.toList());
    }

    public static void resetToDefault() {
        rules.values().forEach(Rule::setToDefault);
    }

    public static <T> Rule<T> registerRule(String name, DataType<T> dataType, T defaultValue) {
        Rule rule = new Rule(name, dataType, defaultValue);
        rules.put(name, rule);
        return rule;
    }

    public static class EnumDataType<T extends Enum<T>>
    implements DataType<T> {
        private Map<String, T> nameToValue;

        private EnumDataType(Map<String, T> nameToValue) {
            this.nameToValue = nameToValue;
        }

        public static <T extends Enum<T>> EnumDataType<T> of(Class<T> clazz) {
            Map<String, Object> nameToValue = Arrays.stream(clazz.getEnumConstants()).collect(Collectors.groupingBy(x -> ((IStringSerializable)x).func_176610_l(), Collectors.reducing(null, (a, b) -> a == null ? b : a)));
            return new EnumDataType<Object>(nameToValue);
        }

        @Override
        public T parse(String str) throws CommandException {
            Enum val = (Enum)this.nameToValue.get(str);
            if (val == null) {
                throw new CommandException("tempRules.enum.invalid", new Object[]{str});
            }
            return (T)val;
        }

        @Override
        public List<String> getTabCompletionOptions() {
            return this.nameToValue.keySet().stream().sorted().collect(Collectors.toList());
        }

        @Override
        public String toString(T val) {
            return ((IStringSerializable)val).func_176610_l();
        }
    }

    public static class DoubleDataType
    implements DataType<Double> {
        private double min = -1.7976931348623157E308;
        private double max = Double.MAX_VALUE;

        public DoubleDataType range(double min, double max) {
            DoubleDataType _new = new DoubleDataType();
            _new.min = min;
            _new.max = max;
            return _new;
        }

        public DoubleDataType min(double min) {
            return this.range(min, this.max);
        }

        public DoubleDataType max(double max) {
            return this.range(this.min, max);
        }

        @Override
        public Double parse(String str) throws CommandException {
            return CommandBase.func_175756_a((String)str, (double)this.min, (double)this.max);
        }

        @Override
        public List<String> getTabCompletionOptions() {
            return Collections.emptyList();
        }

        @Override
        public String toString(Double val) {
            return String.valueOf(val);
        }
    }

    public static class IntegerDataType
    implements DataType<Integer> {
        private int min = Integer.MIN_VALUE;
        private int max = Integer.MAX_VALUE;

        public IntegerDataType range(int min, int max) {
            IntegerDataType _new = new IntegerDataType();
            _new.min = min;
            _new.max = max;
            return _new;
        }

        public IntegerDataType min(int min) {
            return this.range(min, this.max);
        }

        public IntegerDataType max(int max) {
            return this.range(this.min, max);
        }

        @Override
        public Integer parse(String str) throws CommandException {
            return CommandBase.func_175764_a((String)str, (int)this.min, (int)this.max);
        }

        @Override
        public List<String> getTabCompletionOptions() {
            return Collections.emptyList();
        }

        @Override
        public String toString(Integer val) {
            return String.valueOf(val);
        }
    }

    public static class StringDataType
    implements DataType<String> {
        private Predicate<String> filter = str -> true;

        public StringDataType filter(Predicate<String> filter) {
            StringDataType _new = new StringDataType();
            _new.filter = this.filter.and(filter);
            return _new;
        }

        @Override
        public String parse(String str) throws CommandException {
            if (!this.filter.test(str)) {
                throw new CommandException("tempRules.string.invalid", new Object[]{str});
            }
            return str;
        }

        @Override
        public List<String> getTabCompletionOptions() {
            return Collections.emptyList();
        }

        @Override
        public String toString(String val) {
            return val;
        }
    }

    public static interface DataType<T> {
        public static final StringDataType STRING = new StringDataType();
        public static final IntegerDataType INTEGER = new IntegerDataType();
        public static final DoubleDataType DOUBLE = new DoubleDataType();
        public static final DataType<Boolean> BOOLEAN = new DataType<Boolean>(){

            @Override
            public Boolean parse(String str) {
                return Boolean.parseBoolean(str);
            }

            @Override
            public List<String> getTabCompletionOptions() {
                return Arrays.asList("false", "true");
            }

            @Override
            public String toString(Boolean val) {
                return String.valueOf(val);
            }
        };

        public T parse(String var1) throws CommandException;

        public List<String> getTabCompletionOptions();

        public String toString(T var1);
    }

    public static class ValueChangeEvent<T> {
        private Rule<T> rule;
        private T oldValue;
        private T newValue;

        public ValueChangeEvent(Rule<T> rule, T oldValue, T newValue) {
            this.rule = rule;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public Rule<T> getRule() {
            return this.rule;
        }

        public T getOldValue() {
            return this.oldValue;
        }

        public T getNewValue() {
            return this.newValue;
        }
    }

    public static class Rule<T> {
        private String name;
        private DataType<T> dataType;
        private T defaultValue;
        private T value;
        private boolean readOnly = false;
        private boolean hidden = false;
        private List<Consumer<ValueChangeEvent<T>>> listeners = new ArrayList<Consumer<ValueChangeEvent<T>>>();

        private Rule(String name, DataType<T> dataType, T defaultValue) {
            this.name = name;
            this.dataType = dataType;
            this.value = defaultValue;
            this.defaultValue = this.value;
        }

        public String getName() {
            return this.name;
        }

        public DataType<T> getDataType() {
            return this.dataType;
        }

        public T getDefaultValue() {
            return this.defaultValue;
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            if (!value.equals(this.value)) {
                ValueChangeEvent event = new ValueChangeEvent(this, this.value, value);
                this.listeners.forEach(l -> l.accept(event));
                this.value = value;
            }
        }

        public void setToDefault() {
            if (!this.value.equals(this.defaultValue)) {
                ValueChangeEvent event = new ValueChangeEvent(this, this.value, this.defaultValue);
                this.listeners.forEach(l -> l.accept(event));
                this.value = this.defaultValue;
            }
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public Rule<T> setReadOnly() {
            this.readOnly = true;
            return this;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public Rule<T> setHidden() {
            this.hidden = true;
            return this;
        }

        public void addValueChangeListener(Consumer<ValueChangeEvent<T>> listener) {
            this.listeners.add(listener);
        }

        public void removeValueChangeListener(Consumer<ValueChangeEvent<T>> listener) {
            this.listeners.remove(listener);
        }
    }
}

