/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands;

import java.util.ArrayList;
import java.util.List;
import net.earthcomputer.clientcommands.ToolDamageManager;
import net.earthcomputer.clientcommands.command.CommandRelog;
import net.earthcomputer.clientcommands.network.PacketEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.network.EnumPacketDirection;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;

public class EventManager {
    public static final EventManager INSTANCE = new EventManager();
    private static Listeners<FMLNetworkEvent.ClientDisconnectionFromServerEvent> disconnectExceptRelogListeners = new Listeners();
    private static Listeners<FMLNetworkEvent.ClientDisconnectionFromServerEvent> disconnectListeners = new Listeners();
    private static boolean connecting = false;
    private static Listeners<EntityJoinWorldEvent> connectListeners = new Listeners();
    private static Listeners<TickEvent.ClientTickEvent> tickListeners = new Listeners();
    private static Listeners<TickEvent.ClientTickEvent> endTickListeners = new Listeners();
    private static Listeners<TickEvent.ServerTickEvent> serverTickListeners = new Listeners();
    private static Listeners<TickEvent.ServerTickEvent> serverEndTickListeners = new Listeners();
    private static Listeners<PacketEvent.Outbound.Pre> outboundPacketPreListeners = new Listeners();
    private static Listeners<PacketEvent.Outbound.Post> outboundPacketPostListeners = new Listeners();
    private static Listeners<PacketEvent.Inbound.Pre> inboundPacketPreListeners = new Listeners();
    private static Listeners<PacketEvent.Inbound.Post> inboundPacketPostListeners = new Listeners();
    private static Listeners<RenderWorldLastEvent> renderWorldLastListeners = new Listeners();
    private static Listeners<GuiOpenEvent> guiOpenListeners = new Listeners();
    private static Listeners<GuiScreenEvent.InitGuiEvent.Post> initGuiListeners = new Listeners();
    private static Listeners<GuiScreenEvent.KeyboardInputEvent.Pre> guiKeyPressedListeners = new Listeners();
    private static Listeners<GuiScreenEvent.ActionPerformedEvent.Pre> guiActionPerformedListeners = new Listeners();
    private static Listeners<GuiScreenEvent.DrawScreenEvent.Post> guiOverlayListeners = new Listeners();
    private static Listeners<ClientChatEvent> chatSentListeners = new Listeners();
    private static Listeners<ClientChatReceivedEvent> chatReceivedListeners = new Listeners();
    private static Listeners<EntityEvent.EntityConstructing> entityConstructingListeners = new Listeners();
    private static Listeners<EntityJoinWorldEvent> entitySpawnListeners = new Listeners();
    private static Listeners<TickEvent.PlayerTickEvent> playerTickListeners = new Listeners();
    private static Listeners<LivingAttackEvent> livingAttackListeners = new Listeners();
    private static Listeners<AnvilRepairEvent> anvilRepairListeners = new Listeners();
    private static Listeners<PlayerInteractEvent.LeftClickEmpty> attackAirListeners = new Listeners();
    private static Listeners<PlayerInteractEvent.LeftClickBlock> attackBlockListeners = new Listeners();
    private static Listeners<AttackEntityEvent> attackEntityListeners = new Listeners();
    private static Listeners<PlayerInteractEvent.RightClickBlock> useBlockListeners = new Listeners();
    private static Listeners<PlayerInteractEvent.RightClickItem> useItemListeners = new Listeners();
    private static Listeners<LivingEntityUseItemEvent.Stop> stopUseItemListeners = new Listeners();
    private static Listeners<LivingEntityUseItemEvent.Finish> finishUseItemListeners = new Listeners();
    private static Listeners<PlayerInteractEvent.EntityInteract> useEntityListeners = new Listeners();
    private static Listeners<ArrowLooseEvent> fireBowListeners = new Listeners();
    private static Listeners<ToolDamageManager.ToolDamagedEvent.Pre> preDamageItemListeners = new Listeners();
    private static Listeners<ToolDamageManager.ToolDamagedEvent.Post> postDamageItemListeners = new Listeners();

    private EventManager() {
    }

    public static void addDisconnectExceptRelogListener(Listener<FMLNetworkEvent.ClientDisconnectionFromServerEvent> listener) {
        disconnectExceptRelogListeners.add(listener);
    }

    @SubscribeEvent
    public void onDisconnectExceptRelog(FMLNetworkEvent.ClientDisconnectionFromServerEvent e) {
        if (CommandRelog.isRelogging) {
            CommandRelog.isRelogging = false;
        } else {
            disconnectExceptRelogListeners.invoke(e);
        }
    }

    public static void addDisconnectListener(Listener<FMLNetworkEvent.ClientDisconnectionFromServerEvent> listener) {
        disconnectListeners.add(listener);
    }

    @SubscribeEvent
    public void onDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent e) {
        disconnectListeners.invoke(e);
    }

    public static void addConnectListener(Listener<EntityJoinWorldEvent> listener) {
        connectListeners.add(listener);
    }

    @SubscribeEvent
    public void onConnectedToServer(FMLNetworkEvent.ClientConnectedToServerEvent e) {
        connecting = true;
    }

    @SubscribeEvent
    public void onDisconnectedFromServer(FMLNetworkEvent.ClientDisconnectionFromServerEvent e) {
        connecting = false;
    }

    @SubscribeEvent
    public void onConnect(EntityJoinWorldEvent e) {
        if (connecting && e.getEntity() == Minecraft.func_71410_x().field_71439_g) {
            connectListeners.invoke(e);
            connecting = false;
        }
    }

    public static void addTickListener(Listener<TickEvent.ClientTickEvent> listener) {
        tickListeners.add(listener);
    }

    public static void addEndTickListener(Listener<TickEvent.ClientTickEvent> listener) {
        endTickListeners.add(listener);
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            tickListeners.invoke(e);
        } else {
            endTickListeners.invoke(e);
        }
    }

    public static void addServerTickListener(Listener<TickEvent.ServerTickEvent> listener) {
        serverTickListeners.add(listener);
    }

    public static void addServerEndTickListener(Listener<TickEvent.ServerTickEvent> listener) {
        serverEndTickListeners.add(listener);
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            serverTickListeners.invoke(e);
        } else {
            serverEndTickListeners.invoke(e);
        }
    }

    public static void addOutboundPacketPreListener(Listener<PacketEvent.Outbound.Pre> listener) {
        outboundPacketPreListeners.add(listener);
    }

    @SubscribeEvent
    public void onPacketOutboundPre(PacketEvent.Outbound.Pre e) {
        outboundPacketPreListeners.invoke(e);
    }

    public static Packet<?> firePacketOutboundPre(NetworkManager netManager, Packet<?> packet) {
        if (netManager.getDirection() == EnumPacketDirection.SERVERBOUND) {
            return packet;
        }
        PacketEvent.Outbound.Pre event = new PacketEvent.Outbound.Pre(packet);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.isCanceled() ? null : event.getPacket();
    }

    public static void addOutboundPacketPostListener(Listener<PacketEvent.Outbound.Post> listener) {
        outboundPacketPostListeners.add(listener);
    }

    @SubscribeEvent
    public void onPacketOutboundPost(PacketEvent.Outbound.Post e) {
        outboundPacketPostListeners.invoke(e);
    }

    public static void firePacketOutboundPost(NetworkManager netManager, Packet<?> packet) {
        if (netManager.getDirection() == EnumPacketDirection.CLIENTBOUND) {
            MinecraftForge.EVENT_BUS.post((Event)new PacketEvent.Outbound.Post(packet));
        }
    }

    public static void addInboundPacketPreListener(Listener<PacketEvent.Inbound.Pre> listener) {
        inboundPacketPreListeners.add(listener);
    }

    @SubscribeEvent
    public void onPacketInboundPre(PacketEvent.Inbound.Pre e) {
        inboundPacketPreListeners.invoke(e);
    }

    public static Packet<?> firePacketInboundPre(NetworkManager netManager, Packet<?> packet) {
        if (netManager == null ? !Minecraft.func_71410_x().func_152345_ab() : netManager.getDirection() == EnumPacketDirection.SERVERBOUND) {
            return packet;
        }
        PacketEvent.Inbound.Pre event = new PacketEvent.Inbound.Pre(packet);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.isCanceled() ? null : event.getPacket();
    }

    public static void addInboundPacketPostListener(Listener<PacketEvent.Inbound.Post> listener) {
        inboundPacketPostListeners.add(listener);
    }

    @SubscribeEvent
    public void onPacketInboundPost(PacketEvent.Inbound.Post e) {
        inboundPacketPostListeners.invoke(e);
    }

    public static void firePacketInboundPost(NetworkManager netManager, Packet<?> packet) {
        if (netManager == null ? !Minecraft.func_71410_x().func_152345_ab() : netManager.getDirection() == EnumPacketDirection.SERVERBOUND) {
            return;
        }
        MinecraftForge.EVENT_BUS.post((Event)new PacketEvent.Inbound.Post(packet));
    }

    public static void addRenderWorldLastListener(Listener<RenderWorldLastEvent> listener) {
        renderWorldLastListeners.add(listener);
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent e) {
        renderWorldLastListeners.invoke(e);
    }

    public static void addGuiOpenListener(Listener<GuiOpenEvent> listener) {
        guiOpenListeners.add(listener);
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent e) {
        guiOpenListeners.invoke(e);
    }

    public static void addInitGuiListener(Listener<GuiScreenEvent.InitGuiEvent.Post> listener) {
        initGuiListeners.add(listener);
    }

    @SubscribeEvent
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Post e) {
        initGuiListeners.invoke(e);
    }

    public static void addGuiKeyPressedListener(Listener<GuiScreenEvent.KeyboardInputEvent.Pre> listener) {
        guiKeyPressedListeners.add(listener);
    }

    @SubscribeEvent
    public void onGuiKeyPressed(GuiScreenEvent.KeyboardInputEvent.Pre e) {
        guiKeyPressedListeners.invoke(e);
    }

    public static void addGuiActionPerformedListener(Listener<GuiScreenEvent.ActionPerformedEvent.Pre> listener) {
        guiActionPerformedListeners.add(listener);
    }

    @SubscribeEvent
    public void onGuiActionPerformed(GuiScreenEvent.ActionPerformedEvent.Pre e) {
        guiActionPerformedListeners.invoke(e);
    }

    public static void addGuiOverlayListener(Listener<GuiScreenEvent.DrawScreenEvent.Post> listener) {
        guiOverlayListeners.add(listener);
    }

    @SubscribeEvent
    public void onGuiOverlay(GuiScreenEvent.DrawScreenEvent.Post e) {
        guiOverlayListeners.invoke(e);
    }

    public static void addChatSentListener(Listener<ClientChatEvent> listener) {
        chatSentListeners.add(listener);
    }

    @SubscribeEvent
    public void onChatSent(ClientChatEvent e) {
        chatSentListeners.invoke(e);
    }

    public static void addChatReceivedListener(Listener<ClientChatReceivedEvent> listener) {
        chatReceivedListeners.add(listener);
    }

    @SubscribeEvent
    public void onChatReceived(ClientChatReceivedEvent e) {
        chatReceivedListeners.invoke(e);
    }

    public static void addEntityConstructingListener(Listener<EntityEvent.EntityConstructing> listener) {
        entityConstructingListeners.add(listener);
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing e) {
        entityConstructingListeners.invoke(e);
    }

    public static void addEntitySpawnListener(Listener<EntityJoinWorldEvent> listener) {
        entitySpawnListeners.add(listener);
    }

    @SubscribeEvent
    public void onEntitySpawn(EntityJoinWorldEvent e) {
        if (Minecraft.func_71410_x().field_71439_g != null && e.getWorld().field_72995_K) {
            entitySpawnListeners.invoke(e);
        }
    }

    public static void addPlayerTickListener(Listener<TickEvent.PlayerTickEvent> listener) {
        playerTickListeners.add(listener);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent e) {
        if (e.player == Minecraft.func_71410_x().field_71439_g && e.phase == TickEvent.Phase.END) {
            playerTickListeners.invoke(e);
        }
    }

    public static void addLivingAttackListener(Listener<LivingAttackEvent> listener) {
        livingAttackListeners.add(listener);
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent e) {
        livingAttackListeners.invoke(e);
    }

    public static void addAnvilRepairListener(Listener<AnvilRepairEvent> listener) {
        anvilRepairListeners.add(listener);
    }

    @SubscribeEvent
    public void onAnvilRepair(AnvilRepairEvent e) {
        if (e.getEntityPlayer() == Minecraft.func_71410_x().field_71439_g) {
            anvilRepairListeners.invoke(e);
        }
    }

    public static void addAttackAirListener(Listener<PlayerInteractEvent.LeftClickEmpty> listener) {
        attackAirListeners.add(listener);
    }

    @SubscribeEvent
    public void onAttackAir(PlayerInteractEvent.LeftClickEmpty e) {
        if (e.getSide() == Side.CLIENT) {
            attackAirListeners.invoke(e);
        }
    }

    public static void addAttackBlockListener(Listener<PlayerInteractEvent.LeftClickBlock> listener) {
        attackBlockListeners.add(listener);
    }

    @SubscribeEvent
    public void onAttackBlock(PlayerInteractEvent.LeftClickBlock e) {
        if (e.getSide() == Side.CLIENT) {
            attackBlockListeners.invoke(e);
        }
    }

    public static void addAttackEntityListener(Listener<AttackEntityEvent> listener) {
        attackEntityListeners.add(listener);
    }

    @SubscribeEvent
    public void onAttackEntity(AttackEntityEvent e) {
        if (e.getEntityPlayer() == Minecraft.func_71410_x().field_71439_g) {
            attackEntityListeners.invoke(e);
        }
    }

    public static void addUseBlockListener(Listener<PlayerInteractEvent.RightClickBlock> listener) {
        useBlockListeners.add(listener);
    }

    @SubscribeEvent
    public void onUseBlock(PlayerInteractEvent.RightClickBlock e) {
        if (e.getSide() == Side.CLIENT) {
            useBlockListeners.invoke(e);
        }
    }

    public static void addUseItemListener(Listener<PlayerInteractEvent.RightClickItem> listener) {
        useItemListeners.add(listener);
    }

    @SubscribeEvent
    public void onUseItem(PlayerInteractEvent.RightClickItem e) {
        if (e.getSide() == Side.CLIENT) {
            useItemListeners.invoke(e);
        }
    }

    public static void addStopUseItemListener(Listener<LivingEntityUseItemEvent.Stop> listener) {
        stopUseItemListeners.add(listener);
    }

    @SubscribeEvent
    public void onStopUseItem(LivingEntityUseItemEvent.Stop e) {
        if (e.getEntity() == Minecraft.func_71410_x().field_71439_g) {
            stopUseItemListeners.invoke(e);
        }
    }

    public static void addFinishUseItemListener(Listener<LivingEntityUseItemEvent.Finish> listener) {
        finishUseItemListeners.add(listener);
    }

    @SubscribeEvent
    public void onFinishUseItem(LivingEntityUseItemEvent.Finish e) {
        if (e.getEntity() == Minecraft.func_71410_x().field_71439_g) {
            finishUseItemListeners.invoke(e);
        }
    }

    public static void addUseEntityListener(Listener<PlayerInteractEvent.EntityInteract> listener) {
        useEntityListeners.add(listener);
    }

    @SubscribeEvent
    public void onUseEntity(PlayerInteractEvent.EntityInteract e) {
        if (e.getSide() == Side.CLIENT) {
            useEntityListeners.invoke(e);
        }
    }

    public static void addFireBowListener(Listener<ArrowLooseEvent> listener) {
        fireBowListeners.add(listener);
    }

    @SubscribeEvent
    public void onFireBow(ArrowLooseEvent e) {
        if (e.getEntityPlayer() == Minecraft.func_71410_x().field_71439_g) {
            fireBowListeners.invoke(e);
        }
    }

    public static void addPreDamageItemListener(Listener<ToolDamageManager.ToolDamagedEvent.Pre> listener) {
        preDamageItemListeners.add(listener);
    }

    @SubscribeEvent
    public void onPreDamageItem(ToolDamageManager.ToolDamagedEvent.Pre e) {
        preDamageItemListeners.invoke(e);
    }

    public static void addPostDamageItemListener(Listener<ToolDamageManager.ToolDamagedEvent.Post> listener) {
        postDamageItemListeners.add(listener);
    }

    @SubscribeEvent
    public void onPostDamageItem(ToolDamageManager.ToolDamagedEvent.Post e) {
        postDamageItemListeners.invoke(e);
    }

    private static class Listeners<E extends Event> {
        private List<Listener<E>> listeners = new ArrayList<Listener<E>>();

        private Listeners() {
        }

        public void invoke(E e) {
            for (Listener<E> listener : new ArrayList<Listener<E>>(this.listeners)) {
                listener.accept(e);
                if (!listener.wasFinalAction()) continue;
                this.listeners.remove(listener);
            }
        }

        public void add(Listener<E> listener) {
            this.listeners.add(listener);
        }
    }

    @FunctionalInterface
    public static interface Listener<E extends Event> {
        public void accept(E var1);

        default public boolean wasFinalAction() {
            return false;
        }
    }
}

