/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import net.earthcomputer.clientcommands.EventManager;
import net.earthcomputer.clientcommands.TempRules;
import net.earthcomputer.clientcommands.task.LongTask;
import net.earthcomputer.clientcommands.task.TaskManager;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiEnchantment;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentDurability;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerEnchantment;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketChatMessage;
import net.minecraft.network.play.client.CPacketEnchantItem;
import net.minecraft.network.play.client.CPacketPlayer;
import net.minecraft.network.play.server.SPacketAdvancementInfo;
import net.minecraft.network.play.server.SPacketEntityStatus;
import net.minecraft.network.play.server.SPacketWindowProperty;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EnchantmentCracker {
    private static final Logger LOGGER = LogManager.getLogger((String)"clientcommands");
    private static boolean wasWet = false;
    private static int expectedThrows = 0;
    private static final long MULTIPLIER = 25214903917L;
    private static final long ADDEND = 11L;
    private static final long MASK = 0xFFFFFFFFFFFFL;
    private static Set<Integer> possibleXPSeeds = new HashSet<Integer>(0x100000);
    private static boolean onFirstXPSeed = true;
    private static int windowPropertyUpdatesUntilXPSeedUpdate = -1;
    private static Set<Long> possiblePlayerRandSeeds = new HashSet<Long>(65536);
    private static Random playerRand = new Random();
    private static boolean doneEnchantment = false;

    public static void registerEvents() {
        EnchantmentCracker.registerRNGCheckEvents();
        EnchantmentCracker.registerRenderingEvents();
        EnchantmentCracker.registerLogicEvents();
    }

    private static void registerRNGCheckEvents() {
        EventManager.addLivingAttackListener(e -> {
            if (EnchantmentCracker.isEnchantingPredictionEnabled() && e.getEntity() == Minecraft.func_71410_x().field_71439_g) {
                EnchantmentCracker.resetCracker("playerHurt");
            }
        });
        EventManager.addPlayerTickListener(e -> {
            if (EnchantmentCracker.isEnchantingPredictionEnabled()) {
                EntityPlayer player = e.player;
                if (player.func_70051_ag()) {
                    EnchantmentCracker.resetCracker("sprint");
                }
                if (player.func_70026_G() && !wasWet) {
                    EnchantmentCracker.resetCracker("enterWater");
                }
                if (!(!player.func_70026_G() || player.func_70093_af() && player.field_70122_E)) {
                    EnchantmentCracker.resetCracker("swim");
                }
                if (!player.func_70651_bq().isEmpty()) {
                    EnchantmentCracker.resetCracker("potion");
                }
                if (!EnchantmentHelper.func_92099_a((Enchantment)Enchantments.field_185296_A, (EntityLivingBase)player).func_190926_b() && !player.field_70170_p.func_72872_a(EntityXPOrb.class, player.func_174813_aQ()).isEmpty()) {
                    EnchantmentCracker.resetCracker("mending");
                }
                if (player.func_70055_a(Material.field_151586_h) && EnchantmentHelper.func_185292_c((EntityLivingBase)player) > 0) {
                    EnchantmentCracker.resetCracker("respiration");
                }
                if (EnchantmentHelper.func_189869_j((EntityLivingBase)player)) {
                    EnchantmentCracker.frostWalkerCheck(player, EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185301_j, (EntityLivingBase)player));
                }
                wasWet = player.func_70026_G();
            }
        });
        EventManager.addEntitySpawnListener(e -> {
            if (EnchantmentCracker.isEnchantingPredictionEnabled() && e.getEntity() instanceof EntityItem && e.getEntity().func_174813_aQ().func_72326_a(Minecraft.func_71410_x().field_71439_g.func_174813_aQ())) {
                if (expectedThrows == 0) {
                    EnchantmentCracker.resetCracker("dropItem");
                } else {
                    --expectedThrows;
                }
            }
        });
        EventManager.addAnvilRepairListener(e -> {
            if (EnchantmentCracker.isEnchantingPredictionEnabled()) {
                EnchantmentCracker.resetCracker("anvil");
            }
        });
        EventManager.addUseItemListener(e -> {
            if (EnchantmentCracker.isEnchantingPredictionEnabled()) {
                ItemStack stack = e.getItemStack();
                if (stack.func_190926_b()) {
                    return;
                }
                if (e.getItemStack().func_77975_n() == EnumAction.EAT && TempRules.ENCHANTING_CRACK_STATE.getValue() != EnumCrackState.CRACKED) {
                    EnchantmentCracker.resetCracker("eat");
                }
            }
        });
        EventManager.addStopUseItemListener(e -> {
            if (e.getItem().func_77975_n() == EnumAction.EAT) {
                EnchantmentCracker.resetCracker("eat");
            }
        });
        EventManager.addFinishUseItemListener(e -> {
            if (e.getItem().func_77975_n() == EnumAction.EAT && TempRules.ENCHANTING_CRACK_STATE.getValue() == EnumCrackState.CRACKED) {
                for (int i = 0; i < 159; ++i) {
                    playerRand.nextInt();
                }
            }
        });
        EventManager.addAttackEntityListener(e -> {
            ItemStack heldStack;
            if (EnchantmentCracker.isEnchantingPredictionEnabled() && !(heldStack = e.getEntityPlayer().func_184614_ca()).func_190926_b() && e.getTarget() instanceof EntityLiving && ((EntityLiving)e.getTarget()).func_70668_bt() == EnumCreatureAttribute.ARTHROPOD && EnchantmentHelper.func_82781_a((ItemStack)heldStack).containsKey(Enchantments.field_180312_n)) {
                EnchantmentCracker.resetCracker("baneOfArthropods");
            }
        });
        EventManager.addInboundPacketPreListener(e -> {
            if (EnchantmentCracker.isEnchantingPredictionEnabled()) {
                SPacketEntityStatus entityStatus;
                Packet<?> packet = e.getPacket();
                if (packet instanceof SPacketAdvancementInfo) {
                    SPacketAdvancementInfo advancementInfo = (SPacketAdvancementInfo)packet;
                    if (!advancementInfo.func_192602_d() && advancementInfo.func_192604_c().values().stream().anyMatch(AdvancementProgress::func_192105_a)) {
                        EnchantmentCracker.resetCracker("advancement");
                    }
                } else if (packet instanceof SPacketEntityStatus && (entityStatus = (SPacketEntityStatus)packet).func_149160_c() == 29 && entityStatus.func_149161_a((World)Minecraft.func_71410_x().field_71441_e) == Minecraft.func_71410_x().field_71439_g) {
                    EnchantmentCracker.resetCracker("shield");
                }
            }
        });
        EventManager.addOutboundPacketPreListener(e -> {
            CPacketChatMessage chat;
            String message;
            Packet<?> packet;
            if (EnchantmentCracker.isEnchantingPredictionEnabled() && (packet = e.getPacket()) instanceof CPacketChatMessage && (message = (chat = (CPacketChatMessage)packet).func_149439_c()).startsWith("/") && message.substring(1).trim().startsWith("give")) {
                EnchantmentCracker.resetCracker("give");
            }
        });
        EventManager.addPostDamageItemListener(e -> {
            ItemStack heldStack = e.getItemStack();
            if (EnchantmentHelper.func_82781_a((ItemStack)heldStack).containsKey(Enchantments.field_185307_s)) {
                if (TempRules.INFINITE_TOOLS.getValue().booleanValue()) {
                    for (int i = 0; i < e.getDamageAmount(); ++i) {
                        EnchantmentDurability.func_92097_a((ItemStack)e.getItemStack(), (int)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)e.getItemStack()), (Random)playerRand);
                    }
                } else {
                    EnchantmentCracker.resetCracker("unbreaking");
                }
            } else if (heldStack.func_77952_i() + e.getDamageAmount() > heldStack.func_77958_k() + 1) {
                EnchantmentCracker.resetCracker("itemBreak");
            }
        });
    }

    private static void frostWalkerCheck(EntityPlayer player, int level) {
        World world = player.field_70170_p;
        BlockPos pos = new BlockPos((Entity)player);
        if (player.field_70122_E) {
            float radius = Math.min(16, 2 + level);
            BlockPos.MutableBlockPos posAboveWater = new BlockPos.MutableBlockPos(0, 0, 0);
            for (BlockPos.MutableBlockPos waterPos : BlockPos.func_177975_b((BlockPos)pos.func_177963_a((double)(-radius), -1.0, (double)(-radius)), (BlockPos)pos.func_177963_a((double)radius, -1.0, (double)radius))) {
                IBlockState stateAtWater;
                if (!(waterPos.func_177957_d(player.field_70165_t, player.field_70163_u, player.field_70161_v) <= (double)(radius * radius))) continue;
                posAboveWater.func_181079_c(waterPos.func_177958_n(), waterPos.func_177956_o() + 1, waterPos.func_177952_p());
                IBlockState stateAboveWater = world.func_180495_p((BlockPos)posAboveWater);
                if (stateAboveWater.func_185904_a() != Material.field_151579_a || (stateAtWater = world.func_180495_p((BlockPos)waterPos)).func_177230_c() != Blocks.field_185778_de) continue;
                EnchantmentCracker.resetCracker("frostWalker");
                return;
            }
        }
    }

    public static void resetCracker(String reason) {
        if (TempRules.ENCHANTING_CRACK_STATE.getValue() != EnumCrackState.UNCRACKED) {
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentString(TextFormatting.RED + I18n.func_135052_a((String)"enchCrack.reset", (Object[])new Object[]{I18n.func_135052_a((String)("enchCrack.reset." + reason), (Object[])new Object[0])})));
        }
        EnchantmentCracker.resetCracker();
    }

    private static void registerRenderingEvents() {
        EventManager.addGuiOverlayListener(e -> {
            if (EnchantmentCracker.isEnchantingPredictionEnabled() && e.getGui() instanceof GuiEnchantment) {
                EnchantmentCracker.drawEnchantmentGUIOverlay();
            }
        });
    }

    private static void drawEnchantmentGUIOverlay() {
        EnumCrackState crackState = TempRules.ENCHANTING_CRACK_STATE.getValue();
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(I18n.func_135052_a((String)"enchCrack.state", (Object[])new Object[]{I18n.func_135052_a((String)("enchCrack.state." + crackState.func_176610_l()), (Object[])new Object[0])}));
        lines.add("");
        if (crackState == EnumCrackState.CRACKED_ENCH_SEED) {
            lines.add(I18n.func_135052_a((String)"enchCrack.xpSeed.one", (Object[])new Object[]{possibleXPSeeds.iterator().next()}));
        } else if (crackState == EnumCrackState.CRACKING_ENCH_SEED) {
            lines.add(I18n.func_135052_a((String)"enchCrack.xpSeed.many", (Object[])new Object[]{possibleXPSeeds.size()}));
        } else if (crackState == EnumCrackState.CRACKING && !possiblePlayerRandSeeds.isEmpty()) {
            lines.add(I18n.func_135052_a((String)"enchCrack.playerRNGSeed.many", (Object[])new Object[]{possiblePlayerRandSeeds.size()}));
        }
        lines.add("");
        if (crackState == EnumCrackState.CRACKED || crackState == EnumCrackState.CRACKED_ENCH_SEED) {
            lines.add(I18n.func_135052_a((String)"enchCrack.enchantments", (Object[])new Object[0]));
        } else {
            lines.add(I18n.func_135052_a((String)"enchCrack.clues", (Object[])new Object[0]));
        }
        for (int slot = 0; slot < 3; ++slot) {
            lines.add(I18n.func_135052_a((String)"enchCrack.slot", (Object[])new Object[]{slot + 1}));
            List<EnchantmentData> enchs = EnchantmentCracker.getEnchantmentsInTable(slot);
            if (enchs == null) continue;
            for (EnchantmentData ench : enchs) {
                lines.add("   " + ench.field_76302_b.func_77316_c(ench.field_76303_c));
            }
        }
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int y = 0;
        for (String line : lines) {
            fontRenderer.func_78276_b(line, 0, y, 0xFFFFFF);
            y += fontRenderer.field_78288_b;
        }
    }

    private static void registerLogicEvents() {
        TempRules.ENCHANTING_PREDICTION.addValueChangeListener(e -> {
            if (!((Boolean)e.getNewValue()).booleanValue()) {
                EnchantmentCracker.resetCracker();
            }
        });
        EventManager.addInboundPacketPreListener(e -> {
            Packet<?> packet;
            if (EnchantmentCracker.isEnchantingPredictionEnabled() && (packet = e.getPacket()) instanceof SPacketWindowProperty) {
                SPacketWindowProperty windowProp = (SPacketWindowProperty)packet;
                Minecraft mc = Minecraft.func_71410_x();
                Container container = mc.field_71439_g.field_71070_bA;
                if (container instanceof ContainerEnchantment && windowProp.func_149182_c() == container.field_75152_c) {
                    ContainerEnchantment enchContainer = (ContainerEnchantment)container;
                    int currentValue = windowProp.func_149181_d() < 3 ? enchContainer.field_75167_g[windowProp.func_149181_d()] : (windowProp.func_149181_d() == 3 ? enchContainer.field_178149_f : (windowProp.func_149181_d() < 7 ? enchContainer.field_185001_h[windowProp.func_149181_d() - 4] : enchContainer.field_185002_i[windowProp.func_149181_d() - 7]));
                    if (windowProp.func_149180_e() != currentValue) {
                        windowPropertyUpdatesUntilXPSeedUpdate = 10;
                    } else if (windowPropertyUpdatesUntilXPSeedUpdate >= 0 && --windowPropertyUpdatesUntilXPSeedUpdate == 0) {
                        BlockPos tablePos = null;
                        if (mc.field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK && mc.field_71441_e.func_180495_p(mc.field_71476_x.func_178782_a()).func_177230_c() == Blocks.field_150381_bn) {
                            tablePos = mc.field_71476_x.func_178782_a();
                        }
                        if (tablePos != null) {
                            EnchantmentCracker.addEnchantmentSeedInfo((World)mc.field_71441_e, tablePos, enchContainer);
                        }
                    }
                }
            }
        });
        EventManager.addOutboundPacketPreListener(e -> {
            Packet<?> packet;
            if (EnchantmentCracker.isEnchantingPredictionEnabled() && (packet = e.getPacket()) instanceof CPacketEnchantItem) {
                EnchantmentCracker.onEnchantedItem();
                doneEnchantment = true;
            }
        });
    }

    public static void resetCracker() {
        TempRules.ENCHANTING_CRACK_STATE.setValue(EnumCrackState.UNCRACKED);
        onFirstXPSeed = true;
        possibleXPSeeds.clear();
        possiblePlayerRandSeeds.clear();
    }

    private static void prepareForNextEnchantmentSeedCrack(int serverReportedXPSeed) {
        serverReportedXPSeed &= 0xFFF0;
        for (int highBits = 0; highBits < 65536; ++highBits) {
            for (int low4Bits = 0; low4Bits < 16; ++low4Bits) {
                possibleXPSeeds.add(highBits << 16 | serverReportedXPSeed | low4Bits);
            }
        }
    }

    private static void addEnchantmentSeedInfo(World world, BlockPos tablePos, ContainerEnchantment container) {
        EnumCrackState crackState = TempRules.ENCHANTING_CRACK_STATE.getValue();
        if (crackState == EnumCrackState.CRACKED_ENCH_SEED || crackState == EnumCrackState.CRACKED) {
            return;
        }
        ItemStack itemToEnchant = container.field_75168_e.func_70301_a(0);
        if (itemToEnchant.func_190926_b() || !itemToEnchant.func_77956_u()) {
            return;
        }
        if (crackState == EnumCrackState.UNCRACKED || crackState == EnumCrackState.CRACKING) {
            TempRules.ENCHANTING_CRACK_STATE.setValue(EnumCrackState.CRACKING_ENCH_SEED);
            EnchantmentCracker.prepareForNextEnchantmentSeedCrack(container.field_178149_f);
        }
        int power = EnchantmentCracker.getEnchantPower(world, tablePos);
        Random rand = new Random();
        int[] actualEnchantLevels = container.field_75167_g;
        int[] actualEnchantmentClues = container.field_185001_h;
        int[] actualLevelClues = container.field_185002_i;
        Iterator<Integer> xpSeedItr = possibleXPSeeds.iterator();
        block0: while (xpSeedItr.hasNext()) {
            int slot;
            int xpSeed = xpSeedItr.next();
            rand.setSeed(xpSeed);
            for (slot = 0; slot < 3; ++slot) {
                int level = EnchantmentHelper.func_77514_a((Random)rand, (int)slot, (int)power, (ItemStack)itemToEnchant);
                if (level < slot + 1) {
                    level = 0;
                }
                if ((level = ForgeEventFactory.onEnchantmentLevelSet((World)world, (BlockPos)tablePos, (int)slot, (int)power, (ItemStack)itemToEnchant, (int)level)) == actualEnchantLevels[slot]) continue;
                xpSeedItr.remove();
                continue block0;
            }
            for (slot = 0; slot < 3; ++slot) {
                if (actualEnchantLevels[slot] <= 0) continue;
                List<EnchantmentData> enchantments = EnchantmentCracker.getEnchantmentList(rand, xpSeed, itemToEnchant, slot, actualEnchantLevels[slot]);
                if (enchantments == null || enchantments.isEmpty()) {
                    if (actualEnchantmentClues[slot] == -1 && actualLevelClues[slot] == -1) continue;
                    xpSeedItr.remove();
                    continue block0;
                }
                EnchantmentData clue = enchantments.get(rand.nextInt(enchantments.size()));
                if (Enchantment.func_185258_b((Enchantment)clue.field_76302_b) == actualEnchantmentClues[slot] && clue.field_76303_c == actualLevelClues[slot]) continue;
                xpSeedItr.remove();
                continue block0;
            }
        }
        if (possibleXPSeeds.size() == 0) {
            TempRules.ENCHANTING_CRACK_STATE.setValue(EnumCrackState.INVALID);
            LOGGER.warn("Invalid enchantment seed information. Has the server got unknown mods, is there a desync, or is the client just bugged?");
        } else if (possibleXPSeeds.size() == 1) {
            TempRules.ENCHANTING_CRACK_STATE.setValue(EnumCrackState.CRACKED_ENCH_SEED);
            if (!onFirstXPSeed) {
                EnchantmentCracker.addPlayerRNGInfo(possibleXPSeeds.iterator().next());
            }
            onFirstXPSeed = false;
        }
    }

    private static void addPlayerRNGInfo(int enchantmentSeed) {
        EnumCrackState crackState = TempRules.ENCHANTING_CRACK_STATE.getValue();
        if (crackState == EnumCrackState.CRACKED) {
            return;
        }
        long newSeedHigh = (long)enchantmentSeed << 16 & 0xFFFFFFFF0000L;
        if (possiblePlayerRandSeeds.isEmpty() && crackState != EnumCrackState.INVALID) {
            for (int lowBits = 0; lowBits < 65536; ++lowBits) {
                possiblePlayerRandSeeds.add(newSeedHigh | (long)lowBits);
            }
        } else {
            HashSet<Long> newPlayerRandSeeds = new HashSet<Long>();
            for (long oldSeed : possiblePlayerRandSeeds) {
                long newSeed = oldSeed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
                if ((newSeed & 0xFFFFFFFF0000L) != newSeedHigh) continue;
                newPlayerRandSeeds.add(newSeed);
            }
            possiblePlayerRandSeeds.clear();
            possiblePlayerRandSeeds.addAll(newPlayerRandSeeds);
            if (possiblePlayerRandSeeds.size() == 0) {
                TempRules.ENCHANTING_CRACK_STATE.setValue(EnumCrackState.INVALID);
                LOGGER.warn("Invalid player RNG information. Has the server got unknown mods, is there a desync, has an operator used /give, or is the client just bugged?");
            } else if (possiblePlayerRandSeeds.size() == 1) {
                TempRules.ENCHANTING_CRACK_STATE.setValue(EnumCrackState.CRACKED);
                playerRand.setSeed((long)(possiblePlayerRandSeeds.iterator().next() ^ 0x5DEECE66DL));
                possiblePlayerRandSeeds.clear();
            }
        }
    }

    public static void onEnchantedItem() {
        EnumCrackState crackState = TempRules.ENCHANTING_CRACK_STATE.getValue();
        if (crackState == EnumCrackState.CRACKED) {
            possibleXPSeeds.clear();
            possibleXPSeeds.add(playerRand.nextInt());
        } else if (crackState == EnumCrackState.CRACKED_ENCH_SEED) {
            possibleXPSeeds.clear();
            TempRules.ENCHANTING_CRACK_STATE.setValue(EnumCrackState.CRACKING);
        } else {
            EnchantmentCracker.resetCracker();
            onFirstXPSeed = false;
        }
    }

    private static EnchantManipulationStatus manipulateEnchantmentsSanityCheck(EntityPlayer player) {
        if (TempRules.ENCHANTING_CRACK_STATE.getValue() != EnumCrackState.CRACKED) {
            return EnchantManipulationStatus.NOT_CRACKED;
        }
        if (!player.field_70122_E) {
            return EnchantManipulationStatus.NOT_ON_GROUND;
        }
        if (player.field_71069_bz.func_75138_a().stream().allMatch(ItemStack::func_190926_b)) {
            return EnchantManipulationStatus.EMPTY_INVENTORY;
        }
        return EnchantManipulationStatus.OK;
    }

    public static EnchantManipulationStatus manipulateEnchantments(Item item, Predicate<List<EnchantmentData>> enchantmentsPredicate) {
        int i;
        final EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        EnchantManipulationStatus status = EnchantmentCracker.manipulateEnchantmentsSanityCheck((EntityPlayer)player);
        if (status != EnchantManipulationStatus.OK) {
            return status;
        }
        ItemStack stack = new ItemStack(item);
        long seed = ((AtomicLong)ReflectionHelper.getPrivateValue(Random.class, (Object)playerRand, (String[])new String[]{"seed"})).get();
        int timesNeeded = -2;
        int bookshelvesNeeded = 0;
        int slot = 0;
        int[] enchantLevels = new int[3];
        block0: for (i = -1; i < 1000; ++i) {
            int xpSeed = (int)((i == -1 ? seed : seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL) >>> 16);
            Random rand = new Random();
            for (bookshelvesNeeded = 0; bookshelvesNeeded <= 15; ++bookshelvesNeeded) {
                rand.setSeed(xpSeed);
                for (slot = 0; slot < 3; ++slot) {
                    int level = EnchantmentHelper.func_77514_a((Random)rand, (int)slot, (int)bookshelvesNeeded, (ItemStack)stack);
                    if (level < slot + 1) {
                        level = 0;
                    }
                    enchantLevels[slot] = level;
                }
                for (slot = 0; slot < 3; ++slot) {
                    List<EnchantmentData> enchantments = EnchantmentCracker.getEnchantmentList(rand, xpSeed, stack, slot, enchantLevels[slot]);
                    if (!enchantmentsPredicate.test(enchantments)) continue;
                    timesNeeded = i;
                    break block0;
                }
            }
            if (i == -1) continue;
            for (int j = 0; j < 4; ++j) {
                seed = seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
            }
        }
        if (timesNeeded == -2) {
            return EnchantManipulationStatus.IMPOSSIBLE;
        }
        if (timesNeeded != -1) {
            if (timesNeeded != 0) {
                player.func_70012_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, 90.0f);
                player.field_71174_a.func_147297_a((Packet)new CPacketPlayer.Rotation(player.field_70177_z, 90.0f, player.field_70122_E));
            }
            for (i = 0; i < timesNeeded; ++i) {
                TaskManager.addLongTask(new LongTask(){
                    private boolean firstTick = true;

                    @Override
                    protected void taskTick() {
                        if (this.firstTick) {
                            EnchantManipulationStatus status = EnchantmentCracker.manipulateEnchantmentsSanityCheck((EntityPlayer)player);
                            if (status != EnchantManipulationStatus.OK && status != EnchantManipulationStatus.EMPTY_INVENTORY) {
                                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + I18n.func_135052_a((String)status.getTranslation(), (Object[])new Object[0])));
                                TaskManager.abortTasks();
                                return;
                            }
                            Slot matchingSlot = player.field_71069_bz.field_75151_b.stream().filter(Slot::func_75216_d).findAny().orElse(null);
                            if (matchingSlot == null) {
                                return;
                            }
                            expectedThrows++;
                            for (int i = 0; i < 4; ++i) {
                                playerRand.nextInt();
                            }
                            Minecraft.func_71410_x().field_71442_b.func_187098_a(player.field_71069_bz.field_75152_c, matchingSlot.field_75222_d, 0, ClickType.THROW, (EntityPlayer)player);
                            this.firstTick = false;
                        } else {
                            this.setFinished();
                        }
                    }
                });
            }
            TaskManager.addLongTask(new LongTask(){

                @Override
                public void start() {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("enchCrack.insn.dummy", new Object[0]));
                    doneEnchantment = false;
                }

                @Override
                protected void taskTick() {
                    if (doneEnchantment) {
                        this.setFinished();
                    }
                }

                @Override
                protected int getTimeout() {
                    return Integer.MAX_VALUE;
                }
            });
        }
        final int bookshelvesNeeded_f = bookshelvesNeeded;
        final int slot_f = slot;
        TaskManager.addLongTask(new LongTask(){

            @Override
            public void start() {
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.BOLD + I18n.func_135052_a((String)"enchCrack.insn.ready", (Object[])new Object[0])));
                player.func_145747_a((ITextComponent)new TextComponentTranslation("enchCrack.insn.bookshelves", new Object[]{bookshelvesNeeded_f}));
                player.func_145747_a((ITextComponent)new TextComponentTranslation("enchCrack.insn.slot", new Object[]{slot_f + 1}));
                this.setFinished();
            }

            @Override
            protected void taskTick() {
            }
        });
        return EnchantManipulationStatus.OK;
    }

    public static EnchantManipulationStatus throwItemsUntil(Predicate<Random> condition) {
        return EnchantmentCracker.throwItemsUntil(condition, Integer.MAX_VALUE);
    }

    public static EnchantManipulationStatus throwItemsUntil(Predicate<Random> condition, int max) {
        int itemsNeeded;
        if (TempRules.ENCHANTING_CRACK_STATE.getValue() != EnumCrackState.CRACKED) {
            return EnchantManipulationStatus.NOT_CRACKED;
        }
        long seed = ((AtomicLong)ReflectionHelper.getPrivateValue(Random.class, (Object)playerRand, (String[])new String[]{"seed"})).get();
        Random rand = new Random(seed ^ 0x5DEECE66DL);
        for (itemsNeeded = 0; itemsNeeded <= max && !condition.test(rand); ++itemsNeeded) {
            for (int i = 0; i < 4; ++i) {
                seed = seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
            }
            rand.setSeed(seed ^ 0x5DEECE66DL);
        }
        if (itemsNeeded > max) {
            return EnchantManipulationStatus.IMPOSSIBLE;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        for (int i = 0; i < itemsNeeded; ++i) {
            EnchantManipulationStatus status = EnchantmentCracker.manipulateEnchantmentsSanityCheck((EntityPlayer)player);
            if (status != EnchantManipulationStatus.OK) {
                return status;
            }
            Slot matchingSlot = player.field_71069_bz.field_75151_b.stream().filter(Slot::func_75216_d).findAny().orElse(null);
            if (matchingSlot == null) {
                return EnchantManipulationStatus.EMPTY_INVENTORY;
            }
            ++expectedThrows;
            for (int j = 0; j < 4; ++j) {
                playerRand.nextInt();
            }
            Minecraft.func_71410_x().field_71442_b.func_187098_a(player.field_71069_bz.field_75152_c, matchingSlot.field_75222_d, 0, ClickType.THROW, (EntityPlayer)player);
        }
        return EnchantManipulationStatus.OK;
    }

    public static long singlePlayerCrackRNG() {
        EntityPlayerMP serverPlayer = Minecraft.func_71410_x().func_71401_C().func_184103_al().func_177451_a(Minecraft.func_71410_x().field_71439_g.func_110124_au());
        long seed = ((AtomicLong)ReflectionHelper.getPrivateValue(Random.class, (Object)serverPlayer.func_70681_au(), (String[])new String[]{"seed"})).get();
        playerRand.setSeed(seed ^ 0x5DEECE66DL);
        possibleXPSeeds.clear();
        possibleXPSeeds.add(serverPlayer.func_175138_ci());
        TempRules.ENCHANTING_CRACK_STATE.setValue(EnumCrackState.CRACKED);
        return seed;
    }

    private static boolean isEnchantingPredictionEnabled() {
        return TempRules.ENCHANTING_PREDICTION.getValue();
    }

    private static int getEnchantPower(World world, BlockPos tablePos) {
        float power = 0.0f;
        for (int dz = -1; dz <= 1; ++dz) {
            for (int dx = -1; dx <= 1; ++dx) {
                if (dz == 0 && dx == 0 || !world.func_175623_d(tablePos.func_177982_a(dx, 0, dz)) || !world.func_175623_d(tablePos.func_177982_a(dx, 1, dz))) continue;
                power += ForgeHooks.getEnchantPower((World)world, (BlockPos)tablePos.func_177982_a(dx * 2, 0, dz * 2));
                power += ForgeHooks.getEnchantPower((World)world, (BlockPos)tablePos.func_177982_a(dx * 2, 1, dz * 2));
                if (dx == 0 || dz == 0) continue;
                power += ForgeHooks.getEnchantPower((World)world, (BlockPos)tablePos.func_177982_a(dx * 2, 0, dz));
                power += ForgeHooks.getEnchantPower((World)world, (BlockPos)tablePos.func_177982_a(dx * 2, 1, dz));
                power += ForgeHooks.getEnchantPower((World)world, (BlockPos)tablePos.func_177982_a(dx, 0, dz * 2));
                power += ForgeHooks.getEnchantPower((World)world, (BlockPos)tablePos.func_177982_a(dx, 1, dz * 2));
            }
        }
        return (int)power;
    }

    private static List<EnchantmentData> getEnchantmentList(Random rand, int xpSeed, ItemStack stack, int enchantSlot, int level) {
        rand.setSeed(xpSeed + enchantSlot);
        List list = EnchantmentHelper.func_77513_b((Random)rand, (ItemStack)stack, (int)level, (boolean)false);
        if (stack.func_77973_b() == Items.field_151122_aG && list.size() > 1) {
            list.remove(rand.nextInt(list.size()));
        }
        return list;
    }

    public static List<EnchantmentData> getEnchantmentsInTable(int slot) {
        EnumCrackState crackState = TempRules.ENCHANTING_CRACK_STATE.getValue();
        ContainerEnchantment enchContainer = (ContainerEnchantment)Minecraft.func_71410_x().field_71439_g.field_71070_bA;
        if (crackState != EnumCrackState.CRACKED_ENCH_SEED && crackState != EnumCrackState.CRACKED) {
            if (enchContainer.field_185001_h[slot] == -1) {
                return null;
            }
            return Collections.singletonList(new EnchantmentData(Enchantment.func_185262_c((int)enchContainer.field_185001_h[slot]), enchContainer.field_185002_i[slot]));
        }
        Random rand = new Random();
        int xpSeed = possibleXPSeeds.iterator().next();
        ItemStack enchantingStack = enchContainer.field_75168_e.func_70301_a(0);
        int enchantLevels = enchContainer.field_75167_g[slot];
        return EnchantmentCracker.getEnchantmentList(rand, xpSeed, enchantingStack, slot, enchantLevels);
    }

    public static enum EnumCrackState implements IStringSerializable
    {
        UNCRACKED("uncracked"),
        CRACKING_ENCH_SEED("crackingEnchSeed"),
        CRACKED_ENCH_SEED("crackedEnchSeed"),
        CRACKING("cracking"),
        CRACKED("cracked"),
        INVALID("invalid");

        private String name;

        private EnumCrackState(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }

    public static enum EnchantManipulationStatus {
        OK("ok"),
        NOT_CRACKED("notCracked"),
        NOT_ON_GROUND("notOnGround"),
        EMPTY_INVENTORY("emptyInventory"),
        IMPOSSIBLE("impossible");

        private String translation;

        private EnchantManipulationStatus(String translation) {
            this.translation = translation;
        }

        public String getTranslation() {
            return "enchCrack.manipStatus." + this.translation;
        }
    }
}

