/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.passthroughsigns.util;

import com.girafi.passthroughsigns.api.IPassable;
import com.girafi.passthroughsigns.api.PassthroughSignsAPI;
import com.girafi.passthroughsigns.util.ConfigurationHandler;
import com.girafi.passthroughsigns.util.Reference;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class PassableHandler {
    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = world.func_180495_p(pos);
        EntityPlayer player = event.getEntityPlayer();
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block == Blocks.field_150444_as && ConfigurationHandler.shouldWallSignBePassable || (block == Blocks.field_180394_cL || block == Blocks.field_180393_cK) && ConfigurationHandler.shouldBannerBePassable || block instanceof IPassable && ((IPassable)block).canBePassed(world, pos, IPassable.EnumPassableType.WALL_BLOCK) || PassthroughSignsAPI.BLOCK_PASSABLES.contains(block)) {
            EnumFacing facingOpposite = EnumFacing.func_82600_a((int)block.func_176201_c(state)).func_176734_d();
            ItemStack heldStack = player.func_184614_ca();
            if (heldStack.func_77973_b() instanceof ItemBlock) {
                event.setUseItem(Event.Result.DENY);
            }
            if (block == Blocks.field_150444_as) {
                if (Reference.IS_QUARK_LOADED && player.func_70093_af() && ConfigurationHandler.shiftClickQuark) {
                    PassableHandler.rightClick(world, pos, player, event.getHand(), event.getFace(), facingOpposite);
                } else if (!Reference.IS_QUARK_LOADED) {
                    PassableHandler.rightClick(world, pos, player, event.getHand(), event.getFace(), facingOpposite);
                }
            } else if (!player.func_70093_af()) {
                PassableHandler.rightClick(world, pos, player, event.getHand(), event.getFace(), facingOpposite);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        EntityPlayer player = event.getEntityPlayer();
        Entity entity = event.getTarget();
        if (entity instanceof EntityItemFrame && ConfigurationHandler.shouldItemFrameBePassable || entity instanceof EntityPainting && ConfigurationHandler.shouldPaintingsBePassable || entity instanceof IPassable && ((IPassable)entity).canBePassed(world, pos, IPassable.EnumPassableType.HANGING_ENTITY) || PassthroughSignsAPI.ENTITY_PASSABLES.contains(entity.getClass())) {
            EnumFacing facingOpposite = entity.func_174811_aO().func_176734_d();
            if (!player.func_70093_af()) {
                if (entity instanceof EntityItemFrame && ConfigurationHandler.turnOffItemRotation) {
                    event.setCanceled(true);
                }
                PassableHandler.rightClick(world, pos, player, event.getHand(), event.getFace(), facingOpposite);
            }
        }
    }

    private static void rightClick(World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing facing, EnumFacing facingOpposite) {
        if (hand == EnumHand.MAIN_HAND) {
            BlockPos posOffset = pos.func_177982_a(facingOpposite.func_82601_c(), facingOpposite.func_96559_d(), facingOpposite.func_82599_e());
            IBlockState attachedState = world.func_180495_p(posOffset);
            IBlockState stateDown = world.func_180495_p(pos.func_177977_b());
            if (!world.func_175623_d(pos.func_177977_b()) && attachedState.func_177230_c().isAir(attachedState, (IBlockAccess)world, pos)) {
                stateDown.func_177230_c().func_180639_a(world, pos.func_177977_b(), stateDown, player, hand, null, 0.0f, 0.0f, 0.0f);
            } else if (!attachedState.func_177230_c().isAir(attachedState, (IBlockAccess)world, pos)) {
                attachedState.func_177230_c().func_180639_a(world, posOffset, attachedState, player, hand, facing, 0.0f, 0.0f, 0.0f);
            }
        }
    }
}

